/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.archives.webtools.modules;

import de.schlichtherle.io.ArchiveDetector;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.internal.Server;
import org.eclipse.wst.server.core.model.IModuleFile;
import org.eclipse.wst.server.core.model.IModuleFolder;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.eclipse.wst.server.core.model.IModuleResourceDelta;
import org.jboss.ide.eclipse.archives.core.util.internal.TrueZipUtil;
import org.jboss.ide.eclipse.as.core.publishers.PublishUtil;
import org.jboss.ide.eclipse.as.core.server.IDeployableServer;
import org.jboss.ide.eclipse.as.core.server.internal.DeployableServerBehavior;
import org.jboss.ide.eclipse.as.core.util.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalZippedPublisherUtil
extends PublishUtil {
    private IServer server;
    private String deployRoot;
    private IModule[] module;
    private int publishType;
    private IModuleResourceDelta[] delta;

    public IStatus publishModule(IServer server, String deployRoot, IModule[] module, int publishType, IModuleResourceDelta[] delta, IProgressMonitor monitor) throws CoreException {
        IStatus finalStatus;
        IStatus[] returnStatus;
        this.server = server;
        this.deployRoot = deployRoot;
        this.module = module;
        this.publishType = publishType;
        this.delta = delta;
        if (publishType == 3) {
            returnStatus = this.removeModule(server, deployRoot, module);
        } else if (publishType == 2) {
            returnStatus = this.fullPublish(server, deployRoot, module);
        } else {
            ArrayList<IStatus> results = new ArrayList<IStatus>();
            if (LocalZippedPublisherUtil.countChanges((IModuleResourceDelta[])delta) > 0) {
                results.addAll(Arrays.asList(this.publishChanges(server, deployRoot, module)));
            }
            IModule[] children = server.getChildModules(module, (IProgressMonitor)new NullProgressMonitor());
            results.addAll(Arrays.asList(this.handleChildrenDeltas(server, deployRoot, module, children)));
            List removed = this.getBehaviour(server).getRemovedModules();
            for (IModule[] removedArray : removed) {
                if (!removedArray[0].getId().equals(module[0].getId())) continue;
                results.addAll(Arrays.asList(this.removeModule(server, deployRoot, removedArray)));
            }
            returnStatus = results.toArray(new IStatus[results.size()]);
        }
        TrueZipUtil.umount();
        if (returnStatus.length > 0) {
            MultiStatus ms = new MultiStatus("org.jboss.ide.eclipse.as.core", 0x2020004, "Publish Failed for module " + module[0].getName(), null);
            int i = 0;
            while (i < returnStatus.length) {
                ms.add(returnStatus[i]);
                ++i;
            }
            finalStatus = ms;
        } else {
            finalStatus = Status.OK_STATUS;
        }
        return finalStatus;
    }

    protected IDeployableServer getDeployableServer(IServer server) {
        return (IDeployableServer)server.loadAdapter(IDeployableServer.class, (IProgressMonitor)new NullProgressMonitor());
    }

    protected DeployableServerBehavior getBehaviour(IServer server) {
        return (DeployableServerBehavior)server.loadAdapter(DeployableServerBehavior.class, (IProgressMonitor)new NullProgressMonitor());
    }

    protected List<IModule[]> getRemovedModules(IServer s) {
        return this.getBehaviour(s).getRemovedModules();
    }

    protected IStatus[] handleChildrenDeltas(IServer server, String deployRoot, IModule[] module, IModule[] children) {
        ArrayList<IStatus> results = new ArrayList<IStatus>();
        int i = 0;
        while (i < children.length) {
            IModule[] combinedChild = this.combine(module, children[i]);
            if (!this.getBehaviour(server).hasBeenPublished(combinedChild)) {
                results.addAll(Arrays.asList(this.fullPublish(server, deployRoot, combinedChild)));
            } else if (this.isRemoved(server, combinedChild)) {
                results.addAll(Arrays.asList(this.removeModule(server, deployRoot, combinedChild)));
            } else {
                results.addAll(Arrays.asList(this.publishChanges(server, deployRoot, combinedChild)));
                IModule[] children2 = server.getChildModules(combinedChild, (IProgressMonitor)new NullProgressMonitor());
                results.addAll(Arrays.asList(this.handleChildrenDeltas(server, deployRoot, children, children2)));
            }
            ++i;
        }
        return results.toArray(new IStatus[results.size()]);
    }

    protected boolean isRemoved(IServer server, IModule[] child) {
        List removed = this.getBehaviour(server).getRemovedModules();
        for (IModule[] next : removed) {
            if (next.length != child.length) continue;
            int j = 0;
            while (j < next.length) {
                if (!next[j].getId().equals(child[j].getId())) {
                    // empty if block
                }
                ++j;
            }
            return true;
        }
        return false;
    }

    protected IStatus[] removeModule(IServer server, String deployRoot, IModule[] module) {
        IPath deployPath = this.getOutputFilePath(module);
        final ArrayList status = new ArrayList();
        FileUtil.IFileUtilListener listener = new FileUtil.IFileUtilListener(){

            public void fileCopied(File source, File dest, boolean result, Exception e) {
            }

            public void fileDeleted(File file, boolean result, Exception e) {
                if (!result || e != null) {
                    status.add(new Status(4, "org.jboss.ide.eclipse.as.core", 0x2020008, "Attempt to delete " + file.getAbsolutePath() + " failed", (Throwable)e));
                }
            }

            public void folderDeleted(File file, boolean result, Exception e) {
                if (!result || e != null) {
                    status.add(new Status(4, "org.jboss.ide.eclipse.as.core", 0x2020008, "Attempt to delete " + file.getAbsolutePath() + " failed", (Throwable)e));
                }
            }
        };
        FileUtil.safeDelete((File)deployPath.toFile(), (FileUtil.IFileUtilListener)listener);
        return status.toArray(new IStatus[status.size()]);
    }

    protected IStatus[] fullPublish(IServer server, String deployRoot, IModule[] module) {
        ArrayList<IStatus> results = new ArrayList<IStatus>();
        try {
            IPath path = this.getOutputFilePath(module);
            FileUtil.safeDelete((File)path.toFile(), null);
            TrueZipUtil.createArchive((IPath)path);
            de.schlichtherle.io.File root = TrueZipUtil.getFile((IPath)path, (ArchiveDetector)TrueZipUtil.getJarArchiveDetector());
            IModuleResource[] resources = LocalZippedPublisherUtil.getResources((IModule[])module);
            results.addAll(Arrays.asList(this.copy(root, resources)));
            IModule[] children = server.getChildModules(module, (IProgressMonitor)new NullProgressMonitor());
            int i = 0;
            while (i < children.length) {
                results.addAll(Arrays.asList(this.fullPublish(server, deployRoot, this.combine(module, children[i]))));
                ++i;
            }
            TrueZipUtil.umount();
            return results.toArray(new IStatus[results.size()]);
        }
        catch (CoreException ce) {
            results.add(this.generateCoreExceptionStatus(ce));
            return results.toArray(new IStatus[results.size()]);
        }
    }

    protected IStatus[] publishChanges(IServer server, String deployRoot, IModule[] module) {
        IPath path = this.getOutputFilePath(module);
        de.schlichtherle.io.File root = TrueZipUtil.getFile((IPath)path, (ArchiveDetector)TrueZipUtil.getJarArchiveDetector());
        IModuleResourceDelta[] deltas = ((Server)server).getPublishedResourceDelta(module);
        return this.publishChanges(server, deltas, root);
    }

    protected IStatus[] publishChanges(IServer server, IModuleResourceDelta[] deltas, de.schlichtherle.io.File root) {
        ArrayList<IStatus> results = new ArrayList<IStatus>();
        if (deltas == null || deltas.length == 0) {
            return new IStatus[0];
        }
        int i = 0;
        while (i < deltas.length) {
            int dKind = deltas[i].getKind();
            IModuleResource resource = deltas[i].getModuleResource();
            if (dKind == 1) {
                results.addAll(Arrays.asList(this.copy(root, new IModuleResource[]{resource})));
            } else if (dKind == 2) {
                if (resource instanceof IModuleFile) {
                    results.addAll(Arrays.asList(this.copy(root, new IModuleResource[]{resource})));
                }
                results.addAll(Arrays.asList(this.publishChanges(server, deltas[i].getAffectedChildren(), root)));
            } else if (dKind == 3) {
                de.schlichtherle.io.File f = this.getFileInArchive(root, resource.getModuleRelativePath().append(resource.getName()));
                boolean b = f.deleteAll();
                if (!b) {
                    results.add(this.generateDeleteFailedStatus((File)f));
                }
            } else if (dKind == 0) {
                results.addAll(Arrays.asList(this.publishChanges(server, deltas[i].getAffectedChildren(), root)));
            }
            ++i;
        }
        return results.toArray(new IStatus[results.size()]);
    }

    protected IStatus[] copy(de.schlichtherle.io.File root, IModuleResource[] children) {
        ArrayList<IStatus> results = new ArrayList<IStatus>();
        int i = 0;
        while (i < children.length) {
            if (children[i] instanceof IModuleFile) {
                de.schlichtherle.io.File destination;
                IModuleFile mf = (IModuleFile)children[i];
                File source = LocalZippedPublisherUtil.getFile((IModuleFile)mf);
                boolean b = new de.schlichtherle.io.File(source).copyAllTo((File)(destination = this.getFileInArchive(root, mf.getModuleRelativePath().append(mf.getName()))));
                if (!b) {
                    results.add(this.generateCopyFailStatus(source, (File)destination));
                }
            } else if (children[i] instanceof IModuleFolder) {
                de.schlichtherle.io.File destination = this.getFileInArchive(root, children[i].getModuleRelativePath().append(children[i].getName()));
                destination.mkdirs();
                IModuleFolder mf = (IModuleFolder)children[i];
                results.addAll(Arrays.asList(this.copy(root, mf.members())));
            }
            ++i;
        }
        return results.toArray(new IStatus[results.size()]);
    }

    protected IStatus generateDeleteFailedStatus(File file) {
        return new Status(4, "org.jboss.ide.eclipse.archives.webtools", "Could not delete file " + file);
    }

    protected IStatus generateCoreExceptionStatus(CoreException ce) {
        return new Status(4, "org.jboss.ide.eclipse.archives.webtools", ce.getMessage(), (Throwable)ce);
    }

    protected IStatus generateCopyFailStatus(File source, File destination) {
        return new Status(4, "org.jboss.ide.eclipse.archives.webtools", "Copy of " + source + " to " + destination + " has failed");
    }

    protected de.schlichtherle.io.File getFileInArchive(de.schlichtherle.io.File root, IPath relative) {
        while (relative.segmentCount() > 0) {
            root = new de.schlichtherle.io.File((File)root, relative.segment(0), (ArchiveDetector)ArchiveDetector.DEFAULT);
            relative = relative.removeFirstSegments(1);
        }
        return root;
    }

    private IModule[] combine(IModule[] module, IModule newMod) {
        IModule[] retval = new IModule[module.length + 1];
        int i = 0;
        while (i < module.length) {
            retval[i] = module[i];
            ++i;
        }
        retval[retval.length - 1] = newMod;
        return retval;
    }

    public IPath getOutputFilePath(IModule[] module) {
        return LocalZippedPublisherUtil.getDeployPath((IModule[])module, (String)this.deployRoot);
    }
}

