/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.archives.webtools.modules;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.eclipse.wst.server.core.model.IModuleResourceDelta;
import org.jboss.ide.eclipse.archives.core.model.IArchive;
import org.jboss.ide.eclipse.archives.core.model.IArchiveNode;
import org.jboss.ide.eclipse.archives.core.util.PathUtils;
import org.jboss.ide.eclipse.archives.webtools.Messages;
import org.jboss.ide.eclipse.archives.webtools.modules.PackageModuleFactory;
import org.jboss.ide.eclipse.as.core.publishers.PublishUtil;
import org.jboss.ide.eclipse.as.core.server.IDeployableServer;
import org.jboss.ide.eclipse.as.core.server.IJBossServerPublishMethod;
import org.jboss.ide.eclipse.as.core.server.IJBossServerPublisher;
import org.jboss.ide.eclipse.as.core.util.FileUtil;
import org.jboss.ide.eclipse.as.core.util.ServerConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackagesPublisher
implements IJBossServerPublisher {
    protected IDeployableServer server;
    protected IModuleResourceDelta[] delta;
    protected FileUtil.FileUtilListener listener;

    public int getPublishState() {
        return 1;
    }

    public boolean accepts(String method, IServer server, IModule[] module) {
        return "local".equals(method) && module != null && module.length > 0 && "jboss.package".equals(module[0].getModuleType().getId());
    }

    public IStatus publishModule(IJBossServerPublishMethod method, IServer server, IModule[] module, int publishType, IModuleResourceDelta[] delta, IProgressMonitor monitor) throws CoreException {
        this.listener = new FileUtil.FileUtilListener();
        this.server = ServerConverter.getDeployableServer((IServer)server);
        this.delta = delta;
        IModule module2 = module[0];
        try {
            if (publishType == 3) {
                this.removeModule(module2, monitor);
            } else if (publishType == 2) {
                this.publishModule(module2, false, monitor);
            } else if (publishType == 1) {
                this.publishModule(module2, true, monitor);
            }
        }
        catch (Exception e) {
            Status status = new Status(4, "org.jboss.ide.eclipse.archives.webtools", NLS.bind((String)Messages.ErrorDuringPublish, (Object)module2.getName()), (Throwable)e);
            return status;
        }
        if (this.listener.getStatuses().length > 0) {
            MultiStatus ms = new MultiStatus("org.jboss.ide.eclipse.archives.webtools", 4, NLS.bind((String)Messages.ErrorDuringPublish, (Object)module2.getName()), null);
            int i = 0;
            while (i < this.listener.getStatuses().length) {
                ms.add(this.listener.getStatuses()[i]);
                ++i;
            }
            return ms;
        }
        Status ret = new Status(0, "org.jboss.ide.eclipse.archives.webtools", NLS.bind((String)Messages.PublishSuccessful, (Object)module2.getName()));
        return ret;
    }

    protected void removeModule(IModule module, IProgressMonitor monitor) {
        IArchive pack = this.getPackage(module);
        if (pack != null) {
            IPath sourcePath = pack.getArchiveFilePath();
            IModule[] tree = new IModule[]{module};
            IPath destPath = PublishUtil.getDeployPath((IModule[])tree, (IDeployableServer)this.server);
            IPath destPath2 = destPath.append(sourcePath.lastSegment());
            FileUtil.safeDelete((File)destPath2.toFile(), (FileUtil.IFileUtilListener)this.listener);
        }
    }

    protected void publishModule(IModule module, boolean incremental, IProgressMonitor monitor) {
        IArchive pack = this.getPackage(module);
        IPath sourcePath = pack.getArchiveFilePath();
        IModule[] tree = new IModule[]{module};
        IPath destPathRoot = PublishUtil.getDeployPath((IModule[])tree, (IDeployableServer)this.server);
        if (destPathRoot.toOSString().equals(PathUtils.getGlobalLocation((IArchiveNode)pack).toOSString())) {
            return;
        }
        if (!incremental || !pack.isExploded()) {
            FileUtil.fileSafeCopy((File)sourcePath.toFile(), (File)destPathRoot.toFile(), (FileUtil.IFileUtilListener)this.listener);
        } else if (destPathRoot.toFile().exists() && destPathRoot.toFile().isFile()) {
            FileUtil.fileSafeCopy((File)sourcePath.toFile(), (File)destPathRoot.toFile(), (FileUtil.IFileUtilListener)this.listener);
        } else {
            this.publishFromDelta(module, destPathRoot, sourcePath.removeLastSegments(1), this.delta);
        }
    }

    protected void publishFromDelta(IModule module, IPath destPathRoot, IPath sourcePrefix, IModuleResourceDelta[] delta) {
        ArrayList<IPath> changedFiles = new ArrayList<IPath>();
        int i = 0;
        while (i < delta.length) {
            this.publishFromDeltaHandle(delta[i], destPathRoot, sourcePrefix, changedFiles);
            ++i;
        }
    }

    protected void publishFromDeltaHandle(IModuleResourceDelta delta, IPath destRoot, IPath sourcePrefix, ArrayList<IPath> changedFiles) {
        IModuleResourceDelta[] children;
        IModuleResource imr = delta.getModuleResource();
        File f = (File)imr.getAdapter(File.class);
        if (f != null) {
            IPath destPath = destRoot.append(imr.getModuleRelativePath()).append(imr.getName());
            switch (delta.getKind()) {
                case 3: {
                    FileUtil.safeDelete((File)destPath.toFile(), (FileUtil.IFileUtilListener)this.listener);
                    return;
                }
                case 1: {
                    FileUtil.fileSafeCopy((File)f, (File)destPath.toFile(), (FileUtil.IFileUtilListener)this.listener);
                    return;
                }
                case 2: {
                    FileUtil.fileSafeCopy((File)f, (File)destPath.toFile(), (FileUtil.IFileUtilListener)this.listener);
                }
            }
        }
        if ((children = delta.getAffectedChildren()) != null) {
            int i = 0;
            while (i < children.length) {
                this.publishFromDeltaHandle(children[i], destRoot, sourcePrefix, changedFiles);
                ++i;
            }
        }
    }

    protected IArchive getPackage(IModule module) {
        PackageModuleFactory.PackagedModuleDelegate delegate = (PackageModuleFactory.PackagedModuleDelegate)((Object)module.loadAdapter(PackageModuleFactory.PackagedModuleDelegate.class, (IProgressMonitor)new NullProgressMonitor()));
        return delegate == null ? null : delegate.getPackage();
    }
}

