/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.jboss.ide.eclipse.as.core.server.IJBossServerPublisher;
import org.jboss.ide.eclipse.as.core.server.IPollerFailureHandler;
import org.jboss.ide.eclipse.as.core.server.IServerStatePoller;
import org.jboss.ide.eclipse.as.core.server.internal.ServerStatePollerType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionManager {
    private static ExtensionManager instance;
    private HashMap<String, ServerStatePollerType> pollers;
    private HashMap<String, IPollerFailureHandler> pollerFailureHandlers;
    private ArrayList<PublisherWrapper> publishers;

    public static ExtensionManager getDefault() {
        if (instance == null) {
            instance = new ExtensionManager();
        }
        return instance;
    }

    public void loadPollers() {
        this.pollers = new HashMap();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor("org.jboss.ide.eclipse.as.core", "pollers");
        int i = 0;
        while (i < cf.length) {
            this.pollers.put(cf[i].getAttribute("id"), new ServerStatePollerType(cf[i]));
            ++i;
        }
    }

    public ServerStatePollerType getPollerType(String id) {
        if (this.pollers == null) {
            this.loadPollers();
        }
        return this.pollers.get(id);
    }

    public ServerStatePollerType[] getStartupPollers() {
        if (this.pollers == null) {
            this.loadPollers();
        }
        ArrayList<ServerStatePollerType> list = new ArrayList<ServerStatePollerType>();
        for (ServerStatePollerType type : this.pollers.values()) {
            if (!type.supportsStartup()) continue;
            list.add(type);
        }
        return list.toArray(new ServerStatePollerType[list.size()]);
    }

    public ServerStatePollerType[] getShutdownPollers() {
        if (this.pollers == null) {
            this.loadPollers();
        }
        ArrayList<ServerStatePollerType> list = new ArrayList<ServerStatePollerType>();
        for (ServerStatePollerType type : this.pollers.values()) {
            if (!type.supportsShutdown()) continue;
            list.add(type);
        }
        return list.toArray(new ServerStatePollerType[list.size()]);
    }

    public void loadFailureHandler() {
        this.pollerFailureHandlers = new HashMap();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor("org.jboss.ide.eclipse.as.core", "pollerFailureHandler");
        int i = 0;
        while (i < cf.length) {
            try {
                this.pollerFailureHandlers.put(cf[i].getAttribute("id"), (IPollerFailureHandler)cf[i].createExecutableExtension("class"));
            }
            catch (CoreException coreException) {
            }
            catch (ClassCastException classCastException) {}
            ++i;
        }
    }

    public IPollerFailureHandler[] getPollerFailureHandlers() {
        if (this.pollerFailureHandlers == null) {
            this.loadFailureHandler();
        }
        Collection<IPollerFailureHandler> c = this.pollerFailureHandlers.values();
        return c.toArray(new IPollerFailureHandler[c.size()]);
    }

    public IPollerFailureHandler getFirstPollFailureHandler(IServerStatePoller poller, String action, List<String> requiredProperties) {
        IPollerFailureHandler[] handlers = this.getPollerFailureHandlers();
        int i = 0;
        while (i < handlers.length) {
            if (handlers[i].accepts(poller, action, requiredProperties)) {
                return handlers[i];
            }
            ++i;
        }
        return null;
    }

    public IJBossServerPublisher getPublisher(IServer server, IModule[] module, String deployMethod) {
        if (this.publishers == null) {
            this.loadPublishers();
        }
        for (PublisherWrapper wrapper : this.publishers) {
            if (!wrapper.publisher.accepts(deployMethod, server, module)) continue;
            return wrapper.getNewInstance();
        }
        return null;
    }

    public IJBossServerPublisher[] getZippedPublishers() {
        if (this.publishers == null) {
            this.loadPublishers();
        }
        ArrayList<IJBossServerPublisher> list = new ArrayList<IJBossServerPublisher>();
        for (PublisherWrapper wrapper : this.publishers) {
            if (!wrapper.isZipDelegate) continue;
            list.add(wrapper.getNewInstance());
        }
        return list.toArray(new IJBossServerPublisher[list.size()]);
    }

    private void loadPublishers() {
        ArrayList<PublisherWrapper> publishers = new ArrayList<PublisherWrapper>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor("org.jboss.ide.eclipse.as.core", "publishers");
        int i = 0;
        while (i < cf.length) {
            try {
                Object clazz = cf[i].createExecutableExtension("class");
                String priority = cf[i].getAttribute("priority");
                String zipDelegate = cf[i].getAttribute("zipDelegate");
                int p = -1;
                try {
                    p = Integer.parseInt(priority);
                }
                catch (NumberFormatException numberFormatException) {}
                publishers.add(new PublisherWrapper(p, zipDelegate, (IJBossServerPublisher)clazz, cf[i]));
            }
            catch (CoreException coreException) {
            }
            catch (ClassCastException classCastException) {}
            ++i;
        }
        this.publishers = publishers;
        Comparator<PublisherWrapper> comparator = new Comparator<PublisherWrapper>(){

            @Override
            public int compare(PublisherWrapper o1, PublisherWrapper o2) {
                return o2.priority - o1.priority;
            }
        };
        Collections.sort(this.publishers, comparator);
    }

    private class PublisherWrapper {
        private int priority;
        private IJBossServerPublisher publisher;
        private boolean isZipDelegate = false;
        private IConfigurationElement element;

        private PublisherWrapper(int priority, String zipDelegate, IJBossServerPublisher publisher, IConfigurationElement element) {
            this.priority = priority;
            this.publisher = publisher;
            this.isZipDelegate = Boolean.parseBoolean(zipDelegate);
            this.element = element;
        }

        private IJBossServerPublisher getNewInstance() {
            try {
                Object clazz = this.element.createExecutableExtension("class");
                return (IJBossServerPublisher)clazz;
            }
            catch (CoreException coreException) {
                return this.publisher;
            }
        }
    }
}

