/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.core.extensions.descriptors;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.jboss.ide.eclipse.as.core.JBossServerCorePlugin;
import org.jboss.ide.eclipse.as.core.Messages;
import org.xml.sax.SAXException;

public class XMLDocumentRepository {
    private static XMLDocumentRepository instance = null;
    private static final String LOAD_EXTERNAL_DTD_KEY = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
    private HashMap<String, Document> pathToDocument = new HashMap();
    private HashMap<String, Long> pathToTimestamp = new HashMap();
    private XMLDocumentRepository parent;

    public static XMLDocumentRepository getDefault() {
        if (instance == null) {
            instance = new XMLDocumentRepository();
        }
        return instance;
    }

    XMLDocumentRepository() {
    }

    public XMLDocumentRepository(XMLDocumentRepository parent) {
        this.parent = parent;
    }

    public Document getDocument(String fullPath) {
        return this.getDocument(fullPath, true);
    }

    public Document getDocument(String fullPath, boolean load) {
        return this.getDocument(fullPath, load, true);
    }

    public Document getDocument(String fullPath, boolean load, boolean save) {
        Document d = this.pathToDocument.get(fullPath);
        if (d == null && this.parent != null) {
            d = this.parent.getDocument(fullPath, false, save);
        }
        if (d == null && load) {
            d = this.loadDocument(fullPath);
            if (save) {
                this.pathToDocument.put(fullPath, d);
                this.pathToTimestamp.put(fullPath, new Long(new File(fullPath).lastModified()));
            }
        }
        return d;
    }

    public boolean refresh(String fullPath) {
        boolean found;
        boolean bl = found = this.pathToTimestamp.get(fullPath) != null;
        if (!found || new File(fullPath).lastModified() != this.pathToTimestamp.get(fullPath).longValue()) {
            this.pathToDocument.put(fullPath, this.loadDocument(fullPath));
            this.pathToTimestamp.put(fullPath, new Long(new File(fullPath).lastModified()));
            return true;
        }
        return false;
    }

    private Document loadDocument(String fullpath) {
        Throwable ex = null;
        try {
            URL url = new File(fullpath).toURI().toURL();
            SAXParserFactory spf = SAXParserFactory.newInstance();
            SAXParser sp = spf.newSAXParser();
            sp.getXMLReader().setFeature(LOAD_EXTERNAL_DTD_KEY, false);
            SAXReader reader = new SAXReader(false);
            reader.setXMLReader(sp.getXMLReader());
            Document document = reader.read(url);
            return document;
        }
        catch (MalformedURLException e) {
            ex = e;
        }
        catch (ParserConfigurationException e) {
            ex = e;
        }
        catch (SAXException e) {
            ex = e;
        }
        catch (DocumentException e) {
            ex = e;
        }
        if (ex != null) {
            JBossServerCorePlugin.getDefault().getLog().log((IStatus)new Status(4, "org.jboss.ide.eclipse.as.core", NLS.bind((String)Messages.loadXMLDocumentFailed, (Object)fullpath), ex));
        }
        return null;
    }

    public static void saveDocument(Document doc, String fullPath) {
        IOException ex = null;
        try {
            File outFile = new File(fullPath);
            FileOutputStream os = new FileOutputStream(outFile);
            OutputFormat outformat = OutputFormat.createPrettyPrint();
            XMLWriter writer = new XMLWriter((OutputStream)os, outformat);
            writer.write(doc);
            writer.flush();
        }
        catch (MalformedURLException e) {
            ex = e;
        }
        catch (FileNotFoundException e) {
            ex = e;
        }
        catch (UnsupportedEncodingException e) {
            ex = e;
        }
        catch (IOException e) {
            ex = e;
        }
        if (ex != null) {
            JBossServerCorePlugin.getDefault().getLog().log((IStatus)new Status(4, "org.jboss.ide.eclipse.as.core", NLS.bind((String)Messages.saveXMLDocumentFailed, (Object)fullPath), (Throwable)ex));
        }
    }
}

