/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.core.extensions.descriptors;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.wst.server.core.IServer;
import org.jboss.ide.eclipse.as.core.JBossServerCorePlugin;
import org.jboss.ide.eclipse.as.core.Messages;
import org.jboss.ide.eclipse.as.core.extensions.descriptors.XPathCategory;
import org.jboss.ide.eclipse.as.core.extensions.descriptors.XPathFileResult;
import org.jboss.ide.eclipse.as.core.extensions.descriptors.XPathQuery;
import org.jboss.ide.eclipse.as.core.server.UnitedServerListener;
import org.jboss.ide.eclipse.as.core.server.internal.LocalJBossServerRuntime;
import org.jboss.ide.eclipse.as.core.server.internal.ServerAttributeHelper;
import org.jboss.tools.jmx.core.IMemento;
import org.jboss.tools.jmx.core.util.XMLMemento;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XPathModel
extends UnitedServerListener {
    public static final String EMPTY_STRING = "org.jboss.ide.eclipse.as.core.model.descriptor.EmptyString";
    public static final String PORTS_CATEGORY_NAME = Messages.Ports;
    private static final String DELIMITER = ",";
    private static final String CATEGORY_LIST = "org.jboss.ide.eclipse.as.core.model.descriptor.Categories";
    private static XPathModel instance;
    protected HashMap<String, ArrayList<XPathCategory>> serverToCategories = new HashMap();
    private static HashMap<String, IPath> rtToPortsFile;
    private static final String ATTRIBUTE_SUFFIX = "_ATTRIBUTE";
    private static final String FILE_SUFFIX = "_FILE";
    public Properties namespaceMap = null;

    static {
        Path properties = new Path("properties");
        rtToPortsFile = new HashMap();
        rtToPortsFile.put("org.jboss.ide.eclipse.as.runtime.32", properties.append("jboss.32.default.ports.properties"));
        rtToPortsFile.put("org.jboss.ide.eclipse.as.runtime.40", properties.append("jboss.40.default.ports.properties"));
        rtToPortsFile.put("org.jboss.ide.eclipse.as.runtime.42", properties.append("jboss.42.default.ports.properties"));
        rtToPortsFile.put("org.jboss.ide.eclipse.as.runtime.50", properties.append("jboss.50.default.ports.properties"));
        rtToPortsFile.put("org.jboss.ide.eclipse.as.runtime.51", properties.append("jboss.51.default.ports.properties"));
        rtToPortsFile.put("org.jboss.ide.eclipse.as.runtime.eap.43", properties.append("jboss.eap.43.default.ports.properties"));
        rtToPortsFile.put("org.jboss.ide.eclipse.as.runtime.eap.50", properties.append("jboss.eap.50.default.ports.properties"));
    }

    public static XPathModel getDefault() {
        if (instance == null) {
            instance = new XPathModel();
        }
        return instance;
    }

    @Override
    public void serverAdded(IServer server) {
        final IServer server2 = server;
        new Job(Messages.AddXPathDetailsJob){

            protected IStatus run(IProgressMonitor monitor) {
                if (server2 == null || server2.getRuntime() == null) {
                    return Status.OK_STATUS;
                }
                LocalJBossServerRuntime ajbsr = (LocalJBossServerRuntime)server2.getRuntime().loadAdapter(LocalJBossServerRuntime.class, null);
                if (ajbsr != null) {
                    IPath configFolder = ajbsr.getConfigurationFullPath();
                    ArrayList defaults = XPathModel.loadDefaults(server2, configFolder.toOSString());
                    XPathModel.this.serverToCategories.put(server2.getId(), defaults);
                    XPathModel.this.save(server2);
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    public XPathQuery getQuery(IServer server, IPath path) {
        XPathCategory cat = this.getCategory(server, path.segment(0));
        if (cat != null) {
            return cat.getQuery(path.segment(1));
        }
        return null;
    }

    protected ArrayList<XPathCategory> getCategoryCollection(IServer server) {
        if (this.serverToCategories.get(server.getId()) == null) {
            ArrayList<XPathCategory> val = new ArrayList<XPathCategory>(Arrays.asList(this.load(server)));
            this.serverToCategories.put(server.getId(), val);
        }
        return this.serverToCategories.get(server.getId());
    }

    public XPathCategory[] getCategories(IServer jbs) {
        ArrayList<XPathCategory> val = this.getCategoryCollection(jbs);
        return val.toArray(new XPathCategory[val.size()]);
    }

    public boolean containsCategory(IServer jbs, String name) {
        return this.getCategory(jbs, name) != null;
    }

    public XPathCategory getCategory(IServer jbs, String name) {
        ArrayList<XPathCategory> list = this.getCategoryCollection(jbs);
        for (XPathCategory c : list) {
            if (!c.getName().equals(name)) continue;
            return c;
        }
        return null;
    }

    public XPathCategory addCategory(IServer jbs, String name) {
        if (!this.containsCategory(jbs, name)) {
            XPathCategory c = new XPathCategory(name, jbs);
            this.getCategoryCollection(jbs).add(c);
            return c;
        }
        return this.getCategory(jbs, name);
    }

    public void addCategory(IServer server, XPathCategory category) {
        if (!this.containsCategory(server, category.getName())) {
            this.getCategoryCollection(server).add(category);
        }
    }

    public void removeCategory(IServer server, String name) {
        ArrayList<XPathCategory> list = this.getCategoryCollection(server);
        Iterator<XPathCategory> i = list.iterator();
        while (i.hasNext()) {
            XPathCategory cat = i.next();
            if (!cat.getName().equals(name)) continue;
            i.remove();
            return;
        }
    }

    protected File getFile(IServer server) {
        return JBossServerCorePlugin.getServerStateLocation(server).append("xpaths.xml").toFile();
    }

    public void save(IServer server) {
        if (!this.serverToCategories.containsKey(server.getId())) {
            return;
        }
        XMLMemento memento = XMLMemento.createWriteRoot((String)"xpaths");
        XPathCategory[] categories = this.getCategories(server);
        int i = 0;
        while (i < categories.length) {
            XMLMemento child = (XMLMemento)memento.createChild("category");
            this.saveCategory(categories[i], server, child);
            ++i;
        }
        try {
            memento.save((OutputStream)new FileOutputStream(this.getFile(server)));
        }
        catch (IOException iOException) {}
    }

    public void saveCategory(XPathCategory category, IServer server, XMLMemento memento) {
        memento.putString("name", category.getName());
        if (category.queriesLoaded()) {
            XPathQuery[] queries = category.getQueries();
            int i = 0;
            while (i < queries.length) {
                XMLMemento child = (XMLMemento)memento.createChild("query");
                this.saveQuery(queries[i], category, server, child);
                ++i;
            }
        }
    }

    private void saveQuery(XPathQuery query, XPathCategory category, IServer server, XMLMemento memento) {
        memento.putString("name", query.getName());
        memento.putString("dir", query.getBaseDir());
        memento.putString("filePattern", query.getFilePattern());
        memento.putString("xpathPattern", query.getXpathPattern());
        memento.putString("attribute", query.getAttribute());
    }

    private XPathCategory[] load(IServer server) {
        if (this.getFile(server).exists()) {
            return this.loadXML(server);
        }
        return this.load_LEGACY(server);
    }

    private XPathCategory[] loadXML(IServer server) {
        XPathCategory[] categories = null;
        try {
            File file = this.getFile(server);
            XMLMemento memento = XMLMemento.createReadRoot((InputStream)new FileInputStream(file));
            IMemento[] categoryMementos = memento.getChildren("category");
            categories = new XPathCategory[categoryMementos.length];
            int i = 0;
            while (i < categoryMementos.length) {
                categories[i] = new XPathCategory(server, categoryMementos[i]);
                ++i;
            }
        }
        catch (IOException iOException) {}
        return categories == null ? new XPathCategory[]{} : categories;
    }

    private XPathCategory[] load_LEGACY(IServer server) {
        ServerAttributeHelper helper = ServerAttributeHelper.createHelper(server);
        String list = helper.getAttribute(CATEGORY_LIST, (String)null);
        if (list == null) {
            return new XPathCategory[0];
        }
        String[] byName = list.split(DELIMITER);
        XPathCategory[] cats = new XPathCategory[byName.length];
        int i = 0;
        while (i < byName.length) {
            cats[i] = new XPathCategory(byName[i], server);
            ++i;
        }
        return cats;
    }

    private static ArrayList<XPathCategory> loadDefaults(IServer server, String configFolder) {
        ArrayList<XPathCategory> retVal = new ArrayList<XPathCategory>();
        Path p = (Path)rtToPortsFile.get(server.getRuntime().getRuntimeType().getId());
        if (p == null) {
            return retVal;
        }
        URL url = FileLocator.find((Bundle)JBossServerCorePlugin.getDefault().getBundle(), (IPath)p, null);
        if (url == null) {
            return retVal;
        }
        Properties pr = new Properties();
        try {
            pr.load(url.openStream());
            XPathCategory ports = new XPathCategory(PORTS_CATEGORY_NAME, server);
            for (String string : pr.keySet()) {
                if (string.endsWith(ATTRIBUTE_SUFFIX) || string.endsWith(FILE_SUFFIX)) continue;
                String xpath = pr.getProperty(string);
                String attributeName = pr.getProperty(String.valueOf(string) + ATTRIBUTE_SUFFIX);
                String file = pr.getProperty(String.valueOf(string) + FILE_SUFFIX);
                XPathQuery query = new XPathQuery(string.replace('_', ' '), configFolder, file, xpath, attributeName);
                ports.addQuery(query);
            }
            retVal.add(ports);
        }
        catch (IOException e) {
            JBossServerCorePlugin.getDefault().getLog().log((IStatus)new Status(4, "org.jboss.ide.eclipse.as.core", Messages.XPathLoadFailure, (Throwable)e));
        }
        return retVal;
    }

    public Properties getNamespaceMap() {
        if (this.namespaceMap == null) {
            this.loadNamespaceMap();
        }
        return (Properties)this.namespaceMap.clone();
    }

    protected void loadNamespaceMap() {
        URL url;
        IPath p = new Path("properties").append("namespaceMap.properties");
        if (p != null && (url = FileLocator.find((Bundle)JBossServerCorePlugin.getDefault().getBundle(), (IPath)p, null)) != null) {
            Properties pr = new Properties();
            try {
                pr.load(url.openStream());
                this.namespaceMap = pr;
                return;
            }
            catch (IOException iOException) {}
        }
        this.namespaceMap = new Properties();
    }

    public void setNamespaceMap(Properties map) {
        this.namespaceMap = map;
    }

    public static XPathFileResult.XPathResultNode getResultNode(Object data) {
        XPathFileResult item;
        if (data instanceof XPathFileResult.XPathResultNode) {
            return (XPathFileResult.XPathResultNode)data;
        }
        if (data instanceof XPathFileResult && ((XPathFileResult)data).getChildren().length == 1) {
            return ((XPathFileResult)data).getChildren()[0];
        }
        if (data instanceof XPathQuery && ((XPathQuery)data).getResults().length == 1 && (item = ((XPathQuery)data).getResults()[0]).getChildren().length == 1) {
            return item.getChildren()[0];
        }
        return null;
    }

    public static XPathFileResult.XPathResultNode[] getResultNodes(XPathQuery query) {
        ArrayList<XPathFileResult.XPathResultNode> l = new ArrayList<XPathFileResult.XPathResultNode>();
        XPathFileResult[] files = query.getResults();
        int i = 0;
        while (i < files.length) {
            l.addAll(Arrays.asList(files[i].getChildren()));
            ++i;
        }
        return l.toArray(new XPathFileResult.XPathResultNode[l.size()]);
    }
}

