/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.core.extensions.descriptors;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.dom4j.Document;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.jaxen.JaxenException;
import org.jaxen.NamespaceContext;
import org.jaxen.SimpleNamespaceContext;
import org.jaxen.dom4j.Dom4jXPath;
import org.jboss.ide.eclipse.as.core.extensions.descriptors.AntFileFilter;
import org.jboss.ide.eclipse.as.core.extensions.descriptors.XMLDocumentRepository;
import org.jboss.ide.eclipse.as.core.extensions.descriptors.XPathCategory;
import org.jboss.ide.eclipse.as.core.extensions.descriptors.XPathFileResult;
import org.jboss.ide.eclipse.as.core.extensions.descriptors.XPathModel;
import org.jboss.tools.jmx.core.IMemento;

public class XPathQuery
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected String name;
    protected String baseDir;
    protected volatile String effectiveBaseDir;
    protected String filePattern;
    protected String xpathPattern;
    protected String attribute;
    protected transient AntFileFilter filter;
    protected transient XPathFileResult[] results;
    protected transient XPathCategory category;
    protected transient XMLDocumentRepository repository = null;

    public XPathQuery(IMemento memento) {
        this.name = memento.getString("name");
        this.baseDir = memento.getString("dir");
        this.filePattern = memento.getString("filePattern");
        this.xpathPattern = memento.getString("xpathPattern");
        this.attribute = memento.getString("attribute");
        this.setEffectiveBaseDir();
    }

    public XPathQuery(String name, List list) {
        this.name = name;
        this.baseDir = list.get(0).equals("org.jboss.ide.eclipse.as.core.model.descriptor.EmptyString") ? null : (String)list.get(0);
        this.filePattern = list.get(1).equals("org.jboss.ide.eclipse.as.core.model.descriptor.EmptyString") ? null : (String)list.get(1);
        this.xpathPattern = list.get(2).equals("org.jboss.ide.eclipse.as.core.model.descriptor.EmptyString") ? null : (String)list.get(2);
        this.attribute = list.size() < 3 || list.get(3).equals("org.jboss.ide.eclipse.as.core.model.descriptor.EmptyString") ? null : (String)list.get(3);
        this.setEffectiveBaseDir();
    }

    public XPathQuery(String name, String baseDir, String filePattern, String xpathPattern, String attribute) {
        this.name = name;
        this.baseDir = baseDir;
        this.filePattern = filePattern;
        this.xpathPattern = xpathPattern;
        this.attribute = attribute;
        this.results = null;
        this.setEffectiveBaseDir();
    }

    private void setEffectiveBaseDir() {
        Path dir;
        Path path = dir = this.baseDir == null ? null : new Path(this.baseDir);
        if (dir == null && this.category != null) {
            dir = this.getCategory().getServer().getRuntime().getLocation();
        }
        if (dir != null && !dir.isAbsolute() && this.category != null) {
            dir = this.getCategory().getServer().getRuntime().getLocation().append((IPath)dir);
        }
        this.effectiveBaseDir = dir == null ? null : dir.toString();
    }

    protected AntFileFilter getFilter() {
        if (this.filter == null) {
            this.filter = new AntFileFilter(this.effectiveBaseDir, this.filePattern);
        }
        return this.filter;
    }

    public void refresh() {
        String[] files = this.getFilter().getIncludedFiles();
        boolean changed = false;
        int i = 0;
        while (i < files.length) {
            changed = changed || this.getRepository().refresh(new Path(this.effectiveBaseDir).append(files[i]).toOSString());
            ++i;
        }
        if (changed) {
            this.results = null;
        }
    }

    public String[] getPossibleFileMatches() {
        return this.getFilter().getIncludedFiles();
    }

    public XPathFileResult[] getResults() {
        if (this.results == null) {
            this.loadResults();
        }
        return this.results;
    }

    public boolean resultsLoaded() {
        return this.results != null;
    }

    protected void loadResults() {
        try {
            String[] files = this.getFilter().getIncludedFiles();
            ArrayList<XPathFileResult> resultList = new ArrayList<XPathFileResult>();
            List nodeList = null;
            int i = 0;
            while (i < files.length) {
                String fileLoc = new Path(this.effectiveBaseDir).append(files[i]).toOSString();
                Document d = this.getRepository().getDocument(fileLoc);
                if (d != null) {
                    Dom4jXPath xpath = new Dom4jXPath(this.xpathPattern);
                    Properties map = XPathModel.getDefault().getNamespaceMap();
                    xpath.setNamespaceContext((NamespaceContext)new SimpleNamespaceContext((Map)map));
                    xpath.selectNodes((Object)d);
                    nodeList = xpath.selectNodes((Object)d);
                }
                if (nodeList != null && nodeList.size() > 0) {
                    resultList.add(new XPathFileResult(this, fileLoc, nodeList));
                }
                ++i;
            }
            this.results = resultList.toArray(new XPathFileResult[resultList.size()]);
        }
        catch (IllegalStateException illegalStateException) {
            this.results = new XPathFileResult[0];
        }
        catch (JaxenException jaxenException) {
            this.results = new XPathFileResult[0];
        }
    }

    public String getFirstResult() {
        XPathFileResult.XPathResultNode[] nodes;
        XPathFileResult[] fileResults = this.getResults();
        if (fileResults.length > 0 && (nodes = fileResults[0].getChildren()).length > 0) {
            return nodes[0].getText();
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (this.category != null) {
            this.category.renameQuery(this.name, name);
        }
        this.name = name;
    }

    public String getFilePattern() {
        return this.filePattern;
    }

    public void setFilePattern(String filePattern) {
        this.filePattern = filePattern;
    }

    public String getXpathPattern() {
        return this.xpathPattern;
    }

    public void setXpathPattern(String xpathPattern) {
        this.xpathPattern = xpathPattern;
    }

    public String getAttribute() {
        return this.attribute;
    }

    public void setAttribute(String attribute) {
        this.attribute = attribute;
    }

    public String getBaseDir() {
        return this.baseDir;
    }

    public void setBaseDir(String baseDir) {
        this.baseDir = baseDir;
        this.setEffectiveBaseDir();
    }

    public XPathCategory getCategory() {
        return this.category;
    }

    public void setCategory(XPathCategory category) {
        boolean hadCategory = this.category != null;
        this.category = category;
        if (!hadCategory) {
            this.setEffectiveBaseDir();
        }
    }

    public void setRepository(XMLDocumentRepository repo) {
        this.repository = repo;
    }

    public XMLDocumentRepository getRepository() {
        return this.repository == null ? XMLDocumentRepository.getDefault() : this.repository;
    }
}

