/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.core.extensions.events;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;
import org.jboss.ide.eclipse.as.core.JBossServerCorePlugin;
import org.jboss.ide.eclipse.as.core.extensions.events.IServerLogListener;
import org.jboss.ide.eclipse.as.core.extensions.events.ServerLog;

public class ServerLogger {
    private static ServerLogger instance;
    private HashMap<String, ServerLog> map = new HashMap();
    private HashMap<String, ArrayList<IServerLogListener>> listeners = new HashMap();

    public static ServerLogger getDefault() {
        if (instance == null) {
            instance = new ServerLogger();
        }
        return instance;
    }

    public void addListener(IServer server, IServerLogListener listener) {
        ArrayList<IServerLogListener> list = this.listeners.get(server.getId());
        if (list == null) {
            list = new ArrayList();
            this.listeners.put(server.getId(), list);
        }
        list.add(listener);
    }

    public void removeListener(IServer server, IServerLogListener listener) {
        ArrayList<IServerLogListener> list = this.listeners.get(server.getId());
        if (list != null) {
            list.remove(listener);
        }
    }

    public void log(IServer server, IStatus status) {
        ServerLog log = this.map.get(server.getId());
        if (log == null) {
            log = new ServerLog(ServerLogger.getServerLogFile(server));
            this.map.put(server.getId(), log);
        }
        log.log(status);
        ArrayList<IServerLogListener> list = this.listeners.get(server.getId());
        if (list != null) {
            IServerLogListener[] listeners = list.toArray(new IServerLogListener[list.size()]);
            int i = 0;
            while (i < listeners.length) {
                listeners[i].logging(status, server);
                ++i;
            }
        }
    }

    public static File getServerLogFile(IServer server) {
        File f = JBossServerCorePlugin.getServerStateLocation(server).append("log").toFile();
        if (!f.getParentFile().exists()) {
            f.getParentFile().mkdirs();
        }
        return f;
    }

    public static IServer findServerForFile(File file) {
        if (file == null) {
            return null;
        }
        IServer[] servers = ServerCore.getServers();
        int i = 0;
        while (i < servers.length) {
            if (ServerLogger.getServerLogFile(servers[i]).equals(file)) {
                return servers[i];
            }
            ++i;
        }
        return null;
    }
}

