/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.core.extensions.jmx;

import java.io.IOException;
import javax.management.MBeanServerConnection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerListener;
import org.eclipse.wst.server.core.ServerEvent;
import org.jboss.ide.eclipse.as.core.JBossServerCorePlugin;
import org.jboss.ide.eclipse.as.core.extensions.jmx.JBossServerConnectionProvider;
import org.jboss.ide.eclipse.as.core.extensions.jmx.JMXClassLoaderRepository;
import org.jboss.ide.eclipse.as.core.extensions.jmx.JMXSafeRunner;
import org.jboss.tools.jmx.core.ExtensionManager;
import org.jboss.tools.jmx.core.IConnectionProvider;
import org.jboss.tools.jmx.core.IConnectionProviderListener;
import org.jboss.tools.jmx.core.IConnectionWrapper;
import org.jboss.tools.jmx.core.IJMXRunnable;
import org.jboss.tools.jmx.core.JMXException;
import org.jboss.tools.jmx.core.tree.ErrorRoot;
import org.jboss.tools.jmx.core.tree.NodeUtils;
import org.jboss.tools.jmx.core.tree.Root;

public class JBossServerConnection
implements IConnectionWrapper,
IServerListener,
IConnectionProviderListener {
    private IServer server;
    private Root root;
    private boolean isConnected;
    private boolean isLoading;

    public JBossServerConnection(IServer server) {
        this.server = server;
        this.isConnected = false;
        this.isLoading = false;
        this.checkState();
        ((JBossServerConnectionProvider)this.getProvider()).addListener(this);
        server.addServerListener((IServerListener)this);
    }

    public void connect() throws IOException {
    }

    public void disconnect() throws IOException {
    }

    public IConnectionProvider getProvider() {
        return ExtensionManager.getProvider((String)"org.jboss.ide.eclipse.as.core.extensions.jmx.JBossServerConnectionProvider");
    }

    public Root getRoot() {
        return this.root;
    }

    public void loadRoot(IProgressMonitor monitor) {
        if (this.isConnected() && !this.isLoading) {
            this.isLoading = true;
            JMXClassLoaderRepository.getDefault().addConcerned(this.server, this);
            try {
                try {
                    if (this.root == null) {
                        this.root = NodeUtils.createObjectNameTree((IConnectionWrapper)this, (IProgressMonitor)monitor);
                    }
                }
                catch (CoreException ce) {
                    Status status = new Status(4, "org.jboss.ide.eclipse.as.core", ce.getMessage(), (Throwable)ce);
                    JBossServerCorePlugin.getDefault().getLog().log((IStatus)status);
                    this.root = new ErrorRoot();
                    JMXClassLoaderRepository.getDefault().removeConcerned(this.server, this);
                    this.isLoading = false;
                }
            }
            finally {
                JMXClassLoaderRepository.getDefault().removeConcerned(this.server, this);
                this.isLoading = false;
            }
        }
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public void run(IJMXRunnable runnable) throws JMXException {
        if (this.server.getServerState() != 2) {
            return;
        }
        JMXSafeRunner.run(this.server, runnable);
    }

    public String getName() {
        return this.server.getName();
    }

    public void serverChanged(ServerEvent event) {
        int eventKind = event.getKind();
        if ((eventKind & 0x10) != 0 && (eventKind & 1) != 0) {
            this.checkState();
        }
    }

    protected void checkState() {
        block6: {
            if (this.server.getServerState() == 2) {
                try {
                    JMXSafeRunner.run(this.server, new IJMXRunnable(){

                        public void run(MBeanServerConnection connection) throws Exception {
                        }
                    });
                    if (!this.isConnected) {
                        this.isConnected = true;
                        ((JBossServerConnectionProvider)this.getProvider()).fireChanged(this);
                    }
                    break block6;
                }
                catch (Exception exception) {
                    if (this.isConnected) {
                        this.isConnected = false;
                        ((JBossServerConnectionProvider)this.getProvider()).fireChanged(this);
                    }
                    break block6;
                }
            }
            this.root = null;
            if (this.isConnected) {
                this.isConnected = false;
                ((JBossServerConnectionProvider)this.getProvider()).fireChanged(this);
            }
        }
    }

    public void connectionAdded(IConnectionWrapper connection) {
    }

    public void connectionChanged(IConnectionWrapper connection) {
    }

    public void connectionRemoved(IConnectionWrapper connection) {
        this.server.removeServerListener((IServerListener)this);
    }

    public boolean canControl() {
        return false;
    }
}

