/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.core.extensions.jmx;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerLifecycleListener;
import org.eclipse.wst.server.core.ServerCore;
import org.jboss.ide.eclipse.as.core.Messages;
import org.jboss.ide.eclipse.as.core.extensions.jmx.JBossServerConnection;
import org.jboss.ide.eclipse.as.core.util.ServerConverter;
import org.jboss.tools.jmx.core.ExtensionManager;
import org.jboss.tools.jmx.core.IConnectionProvider;
import org.jboss.tools.jmx.core.IConnectionProviderListener;
import org.jboss.tools.jmx.core.IConnectionWrapper;
import org.jboss.tools.jmx.core.IJMXRunnable;
import org.jboss.tools.jmx.core.JMXException;

public class JBossServerConnectionProvider
implements IConnectionProvider,
IServerLifecycleListener {
    public static final String PROVIDER_ID = "org.jboss.ide.eclipse.as.core.extensions.jmx.JBossServerConnectionProvider";
    private ArrayList<IConnectionProviderListener> listeners = new ArrayList();
    private HashMap<String, JBossServerConnection> idToConnection;

    public static JBossServerConnectionProvider getProvider() {
        return (JBossServerConnectionProvider)ExtensionManager.getProvider((String)PROVIDER_ID);
    }

    public static JBossServerConnection getConnection(IServer s) {
        return (JBossServerConnection)JBossServerConnectionProvider.getProvider().findConnection(s);
    }

    public static void run(IServer s, IJMXRunnable r) throws JMXException {
        JBossServerConnection c = JBossServerConnectionProvider.getConnection(s);
        if (c == null) {
            c = JBossServerConnectionProvider.getConnection(s);
        }
        c.run(r);
    }

    public JBossServerConnectionProvider() {
        ServerCore.addServerLifecycleListener((IServerLifecycleListener)this);
    }

    protected boolean belongsHere(IServer server) {
        return ServerConverter.getJBossServer(server) != null;
    }

    protected JBossServerConnection createConnection(IServer server) {
        return new JBossServerConnection(server);
    }

    public void serverAdded(IServer server) {
        if (this.belongsHere(server)) {
            this.getConnections();
            if (!this.idToConnection.containsKey(server.getId())) {
                JBossServerConnection connection = this.createConnection(server);
                this.idToConnection.put(server.getId(), connection);
            }
            this.fireAdded(this.idToConnection.get(server.getId()));
        }
    }

    public void serverChanged(IServer server) {
        if (this.belongsHere(server)) {
            this.getConnections();
            if (!this.idToConnection.containsKey(server.getId())) {
                JBossServerConnection connection = this.createConnection(server);
                this.idToConnection.put(server.getId(), connection);
            }
            this.fireAdded(this.idToConnection.get(server.getId()));
        }
    }

    public void serverRemoved(IServer server) {
        if (this.belongsHere(server)) {
            if (this.idToConnection != null) {
                JBossServerConnection connection = this.idToConnection.get(server.getId());
                if (connection != null) {
                    this.idToConnection.remove(server.getId());
                    this.fireRemoved(connection);
                }
            } else {
                this.getConnections();
                this.fireRemoved(this.createConnection(server));
            }
        }
    }

    public IConnectionWrapper findConnection(IServer s) {
        this.getConnections();
        return this.idToConnection.get(s.getId());
    }

    public IConnectionWrapper[] getConnections() {
        if (this.idToConnection == null) {
            this.idToConnection = new HashMap();
            IServer[] allServers = ServerCore.getServers();
            int i = 0;
            while (i < allServers.length) {
                JBossServerConnection c;
                if (this.belongsHere(allServers[i]) && (c = this.createConnection(allServers[i])) != null) {
                    this.idToConnection.put(allServers[i].getId(), c);
                }
                ++i;
            }
        }
        ArrayList<JBossServerConnection> list = new ArrayList<JBossServerConnection>();
        list.addAll(this.idToConnection.values());
        return list.toArray(new JBossServerConnection[list.size()]);
    }

    public String getName(IConnectionWrapper wrapper) {
        if (wrapper instanceof JBossServerConnection) {
            return ((JBossServerConnection)wrapper).getName();
        }
        return null;
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public void addListener(IConnectionProviderListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(IConnectionProviderListener listener) {
        this.listeners.remove(listener);
    }

    void fireAdded(IConnectionWrapper wrapper) {
        Iterator<IConnectionProviderListener> i = this.listeners.iterator();
        while (i.hasNext()) {
            try {
                i.next().connectionAdded(wrapper);
            }
            catch (RuntimeException runtimeException) {}
        }
    }

    void fireChanged(IConnectionWrapper wrapper) {
        Iterator<IConnectionProviderListener> i = this.listeners.iterator();
        while (i.hasNext()) {
            try {
                i.next().connectionChanged(wrapper);
            }
            catch (RuntimeException runtimeException) {}
        }
    }

    void fireRemoved(IConnectionWrapper wrapper) {
        Iterator<IConnectionProviderListener> i = this.listeners.iterator();
        while (i.hasNext()) {
            try {
                i.next().connectionRemoved(wrapper);
            }
            catch (RuntimeException runtimeException) {}
        }
    }

    public boolean canCreate() {
        return false;
    }

    public IConnectionWrapper createConnection(Map map) throws CoreException {
        throw new CoreException((IStatus)new Status(4, "org.jboss.ide.eclipse.as.core", Messages.NotSupported, null));
    }

    public void addConnection(IConnectionWrapper connection) {
    }

    public void removeConnection(IConnectionWrapper connection) {
    }

    public boolean canDelete(IConnectionWrapper wrapper) {
        return false;
    }

    public void connectionChanged(IConnectionWrapper connection) {
    }
}

