/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.core.extensions.polling;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.naming.CommunicationException;
import javax.naming.NamingException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IServer;
import org.jboss.ide.eclipse.as.core.Messages;
import org.jboss.ide.eclipse.as.core.extensions.events.ServerLogger;
import org.jboss.ide.eclipse.as.core.extensions.jmx.JMXClassLoaderRepository;
import org.jboss.ide.eclipse.as.core.extensions.jmx.JMXSafeRunner;
import org.jboss.ide.eclipse.as.core.server.IServerStatePoller;
import org.jboss.ide.eclipse.as.core.server.internal.PollThread;
import org.jboss.ide.eclipse.as.core.server.internal.ServerStatePollerType;
import org.jboss.tools.jmx.core.IJMXRunnable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMXPoller
implements IServerStatePoller {
    public static final String POLLER_ID = "org.jboss.ide.eclipse.as.core.runtime.server.JMXPoller";
    public static final int JMXPOLLER_CODE = 0x1020000;
    public static final Properties IGNORED_PROPERTIES = new Properties();
    public static final String REQUIRED_USER = "org.jboss.ide.eclipse.as.core.extensions.polling.jmx.REQUIRED_USER";
    public static final String REQUIRED_PASS = "org.jboss.ide.eclipse.as.core.extensions.polling.jmx.REQUIRED_PASS";
    public static final int STATE_STARTED = 1;
    public static final int STATE_STOPPED = 0;
    public static final int STATE_TRANSITION = 2;
    private int started;
    private boolean canceled;
    private boolean done;
    private boolean waitingForCredentials = false;
    private boolean ceFound;
    private boolean nnfeFound;
    private boolean startingFound;
    private IServer server;
    private ServerStatePollerType type;
    private IServerStatePoller.PollingException pollingException = null;
    private IServerStatePoller.RequiresInfoException requiresInfoException = null;
    private Properties requiredPropertiesReturned = null;
    private JMXPollerRunnable runnable;
    private JMXSafeRunner runner;

    @Override
    public void beginPolling(IServer server, boolean expectedState, PollThread pt) {
        this.done = false;
        this.canceled = false;
        this.startingFound = false;
        this.nnfeFound = false;
        this.ceFound = false;
        this.server = server;
        this.launchJMXPoller();
    }

    private void launchJMXPoller() {
        PollerRunnable run = new PollerRunnable();
        Thread t = new Thread((Runnable)run, Messages.JMXPoller);
        t.start();
    }

    @Override
    public void cancel(int type) {
        this.canceled = true;
    }

    @Override
    public void cleanup() {
    }

    @Override
    public boolean getState() throws IServerStatePoller.PollingException, IServerStatePoller.RequiresInfoException {
        if (this.pollingException != null) {
            throw this.pollingException;
        }
        if (this.requiresInfoException != null) {
            throw this.requiresInfoException;
        }
        if (this.started == 0) {
            return false;
        }
        if (this.started == 1) {
            return true;
        }
        return this.done || this.canceled;
    }

    @Override
    public boolean isComplete() throws IServerStatePoller.PollingException, IServerStatePoller.RequiresInfoException {
        if (this.pollingException != null) {
            throw this.pollingException;
        }
        if (this.requiresInfoException != null) {
            throw this.requiresInfoException;
        }
        return this.done;
    }

    @Override
    public void failureHandled(Properties properties) {
        this.requiredPropertiesReturned = properties == null ? IGNORED_PROPERTIES : properties;
    }

    @Override
    public List<String> getRequiredProperties() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(REQUIRED_USER);
        list.add(REQUIRED_PASS);
        return list;
    }

    @Override
    public ServerStatePollerType getPollerType() {
        return this.type;
    }

    @Override
    public void setPollerType(ServerStatePollerType type) {
        this.type = type;
    }

    @Override
    public IServer getServer() {
        return this.server;
    }

    @Override
    public int getTimeoutBehavior() {
        return 0;
    }

    private void log(IStatus s) {
        if (!this.canceled) {
            ServerLogger.getDefault().log(this.server, s);
        }
    }

    private class JMXPollerRunnable
    implements IJMXRunnable {
        private JMXPollerRunnable() {
        }

        public void run(MBeanServerConnection connection) throws Exception {
            Object attInfo = connection.getAttribute(new ObjectName("jboss.system:type=Server"), "Started");
            boolean b = (Boolean)attInfo;
            JMXPoller.this.started = b ? 1 : 2;
            JMXPoller.this.done = b;
            if (!JMXPoller.this.startingFound) {
                JMXPoller.this.startingFound = true;
                Status s = new Status(1, "org.jboss.ide.eclipse.as.core", 0x1020000 | JMXPoller.this.started, Messages.ServerStarting, null);
                JMXPoller.this.log((IStatus)s);
            }
        }
    }

    private class PollerRunnable
    implements Runnable {
        private PollerRunnable() {
        }

        public void run() {
            JMXClassLoaderRepository.getDefault().addConcerned(JMXPoller.this.server, this);
            JMXPoller.this.runnable = new JMXPollerRunnable();
            JMXPoller.this.runner = new JMXSafeRunner(JMXPoller.this.server);
            while (!JMXPoller.this.done && !JMXPoller.this.canceled) {
                try {
                    JMXPoller.this.runner.run(JMXPoller.this.runnable);
                }
                catch (CoreException ce) {
                    this.handleException(ce.getCause());
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
            JMXClassLoaderRepository.getDefault().removeConcerned(JMXPoller.this.server, this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void handleException(Throwable t) {
            if (t instanceof SecurityException) {
                PollerRunnable pollerRunnable = this;
                synchronized (pollerRunnable) {
                    if (!JMXPoller.this.waitingForCredentials) {
                        JMXPoller.this.waitingForCredentials = true;
                        JMXPoller.this.requiresInfoException = new PollingSecurityException(NLS.bind((String)Messages.securityException, (Object)t.getMessage()));
                    } else if (JMXPoller.this.requiredPropertiesReturned != null) {
                        if (JMXPoller.this.requiredPropertiesReturned == IGNORED_PROPERTIES) {
                            JMXPoller.this.requiresInfoException = null;
                            JMXPoller.this.done = true;
                            JMXPoller.this.started = 1;
                        } else {
                            JMXPoller.this.requiresInfoException = null;
                            String user = (String)JMXPoller.this.requiredPropertiesReturned.get(JMXPoller.REQUIRED_USER);
                            String pass = (String)JMXPoller.this.requiredPropertiesReturned.get(JMXPoller.REQUIRED_PASS);
                            JMXPoller.this.requiredPropertiesReturned = null;
                            JMXPoller.this.runner.setUser(user);
                            JMXPoller.this.runner.setPass(pass);
                            JMXPoller.this.waitingForCredentials = false;
                        }
                    }
                }
                return;
            }
            if (t instanceof CommunicationException) {
                JMXPoller.this.started = 0;
                if (!JMXPoller.this.ceFound) {
                    JMXPoller.this.ceFound = true;
                    Status s = new Status(2, "org.jboss.ide.eclipse.as.core", 0x1020000 | JMXPoller.this.started, t.getMessage(), t);
                    JMXPoller.this.log((IStatus)s);
                }
                return;
            }
            if (t instanceof NamingException) {
                JMXPoller.this.started = 0;
                if (!JMXPoller.this.nnfeFound) {
                    JMXPoller.this.nnfeFound = true;
                    Status s = new Status(2, "org.jboss.ide.eclipse.as.core", 0x1020000 | JMXPoller.this.started, t.getMessage(), t);
                    JMXPoller.this.log((IStatus)s);
                }
                return;
            }
            if (t != null) {
                JMXPoller.this.pollingException = new IServerStatePoller.PollingException(t.getMessage());
                JMXPoller.this.done = true;
            }
        }
    }

    public class PollingSecurityException
    extends IServerStatePoller.RequiresInfoException {
        private static final long serialVersionUID = 1L;

        public PollingSecurityException(String msg) {
            super(msg);
        }
    }
}

