/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.core.publishers;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.componentcore.ModuleCoreNature;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.eclipse.wst.server.core.model.IModuleResourceDelta;
import org.jboss.ide.eclipse.as.core.Messages;
import org.jboss.ide.eclipse.as.core.publishers.PublishUtil;
import org.jboss.ide.eclipse.as.core.server.IDeployableServer;
import org.jboss.ide.eclipse.as.core.server.IJBossServerPublishMethod;
import org.jboss.ide.eclipse.as.core.server.IJBossServerPublisher;
import org.jboss.ide.eclipse.as.core.server.xpl.PublishCopyUtil;
import org.jboss.ide.eclipse.as.core.util.FileUtil;
import org.jboss.ide.eclipse.as.core.util.ServerConverter;

public class JstPublisher
extends PublishUtil
implements IJBossServerPublisher {
    protected IModuleResourceDelta[] delta;
    protected IDeployableServer server;
    protected int publishState = 1;

    public boolean accepts(String type, IServer server, IModule[] module) {
        IDeployableServer ds = ServerConverter.getDeployableServer(server);
        boolean shouldAccept = ds != null && "local".equals(type) && ModuleCoreNature.isFlexibleProject((IProject)module[0].getProject()) && !ds.zipsWTPDeployments();
        return shouldAccept;
    }

    public IStatus publishModule(IJBossServerPublishMethod method, IServer server, IModule[] module, int publishType, IModuleResourceDelta[] delta, IProgressMonitor monitor) throws CoreException {
        IStatus status = null;
        this.server = ServerConverter.getDeployableServer(server);
        this.delta = delta;
        boolean deleted = false;
        int i = 0;
        while (i < module.length) {
            if (module[i].isExternal()) {
                deleted = true;
            }
            ++i;
        }
        if (publishType == 3) {
            status = this.unpublish(this.server, module, monitor);
        } else if (deleted) {
            this.publishState = 0;
        } else if (publishType == 2) {
            status = this.fullPublish(module, module[module.length - 1], monitor);
        } else if (publishType == 1) {
            status = JstPublisher.getDeployPath(module, this.server).toFile().isDirectory() ? this.incrementalPublish(module, module[module.length - 1], monitor) : this.fullPublish(module, module[module.length - 1], monitor);
        }
        return status;
    }

    protected IStatus fullPublish(IModule[] moduleTree, IModule module, IProgressMonitor monitor) throws CoreException {
        IPath deployPath = JstPublisher.getDeployPath(moduleTree, this.server);
        IPath tempDeployPath = JstPublisher.getTempDeployFolder(moduleTree, this.server);
        IModuleResource[] members = JstPublisher.getResources(module);
        ArrayList<IStatus> list = new ArrayList<IStatus>();
        if (new Path(module.getName()).segmentCount() <= 1) {
            list.addAll(Arrays.asList(this.localSafeDelete(deployPath)));
        }
        if (!JstPublisher.deployPackaged(moduleTree) && !JstPublisher.isBinaryObject(moduleTree)) {
            PublishCopyUtil.LocalCopyCallback handler = new PublishCopyUtil.LocalCopyCallback(this.server.getServer(), deployPath, tempDeployPath);
            PublishCopyUtil util = new PublishCopyUtil(handler);
            list.addAll(Arrays.asList(util.publishFull(members, monitor)));
        } else if (JstPublisher.isBinaryObject(moduleTree)) {
            list.addAll(Arrays.asList(this.copyBinaryModule(moduleTree)));
        } else {
            list.addAll(Arrays.asList(JstPublisher.packModuleIntoJar(moduleTree[moduleTree.length - 1], deployPath)));
        }
        FileFilter filter = new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.getAbsolutePath().toLowerCase().endsWith(".xml");
            }
        };
        FileUtil.touch(filter, deployPath.toFile(), true);
        if (list.size() > 0) {
            MultiStatus ms = new MultiStatus("org.jboss.ide.eclipse.as.core", 0x2020002, NLS.bind((String)Messages.FullPublishFail, (Object)module.getName()), null);
            int i = 0;
            while (i < list.size()) {
                ms.add((IStatus)list.get(i));
                ++i;
            }
            return ms;
        }
        this.publishState = 1;
        Status ret = new Status(0, "org.jboss.ide.eclipse.as.core", 0x2020001, NLS.bind((String)Messages.CountModifiedMembers, (Object)JstPublisher.countMembers(module), (Object)module.getName()), null);
        return ret;
    }

    protected IStatus incrementalPublish(IModule[] moduleTree, IModule module, IProgressMonitor monitor) throws CoreException {
        IStatus[] results = new IStatus[]{};
        IPath deployPath = JstPublisher.getDeployPath(moduleTree, this.server);
        IPath tempDeployPath = JstPublisher.getTempDeployFolder(moduleTree, this.server);
        if (!JstPublisher.deployPackaged(moduleTree) && !JstPublisher.isBinaryObject(moduleTree)) {
            PublishCopyUtil.LocalCopyCallback handler = new PublishCopyUtil.LocalCopyCallback(this.server.getServer(), deployPath, tempDeployPath);
            results = new PublishCopyUtil(handler).publishDelta(this.delta, monitor);
        } else if (this.delta.length > 0) {
            results = JstPublisher.isBinaryObject(moduleTree) ? this.copyBinaryModule(moduleTree) : JstPublisher.packModuleIntoJar(moduleTree[moduleTree.length - 1], deployPath);
        }
        if (results != null && results.length > 0) {
            MultiStatus ms = new MultiStatus("org.jboss.ide.eclipse.as.core", 0x2020004, NLS.bind((String)Messages.IncrementalPublishFail, (Object)module.getName()), null);
            int i = 0;
            while (i < results.length) {
                ms.add(results[i]);
                ++i;
            }
            return ms;
        }
        Status ret = new Status(0, "org.jboss.ide.eclipse.as.core", 0x2020001, NLS.bind((String)Messages.CountModifiedMembers, (Object)JstPublisher.countChanges(this.delta), (Object)module.getName()), null);
        return ret;
    }

    protected IStatus unpublish(IDeployableServer jbServer, IModule[] module, IProgressMonitor monitor) throws CoreException {
        IModule mod = module[module.length - 1];
        IStatus[] errors = this.localSafeDelete(JstPublisher.getDeployPath(module, this.server));
        if (errors.length > 0) {
            this.publishState = 3;
            MultiStatus ms = new MultiStatus("org.jboss.ide.eclipse.as.core", 0x2020006, NLS.bind((String)Messages.DeleteModuleFail, (Object)mod.getName()), (Throwable)new Exception(Messages.DeleteModuleFail2));
            int i = 0;
            while (i < errors.length) {
                ms.addAll(errors[i]);
                ++i;
            }
            throw new CoreException((IStatus)ms);
        }
        Status ret = new Status(0, "org.jboss.ide.eclipse.as.core", 0x2020005, NLS.bind((String)Messages.ModuleDeleted, (Object)mod.getName()), null);
        return ret;
    }

    protected IStatus[] copyBinaryModule(IModule[] moduleTree) {
        try {
            IPath deployPath = JstPublisher.getDeployPath(moduleTree, this.server);
            FileUtil.FileUtilListener listener = new FileUtil.FileUtilListener();
            IModuleResource[] members = JstPublisher.getResources(moduleTree);
            File source = JstPublisher.getFile(members[0]);
            if (source != null) {
                FileUtil.fileSafeCopy(source, deployPath.toFile(), listener);
                return listener.getStatuses();
            }
            Status s = new Status(4, "org.jboss.ide.eclipse.as.core", 0x2020007, NLS.bind((String)Messages.CouldNotPublishModule, (Object)moduleTree[moduleTree.length - 1]), null);
            return new IStatus[]{s};
        }
        catch (CoreException coreException) {
            Status s = new Status(4, "org.jboss.ide.eclipse.as.core", 0x2020007, NLS.bind((String)Messages.CouldNotPublishModule, (Object)moduleTree[moduleTree.length - 1]), null);
            return new IStatus[]{s};
        }
    }

    protected IStatus[] localSafeDelete(IPath deployPath) {
        String serverDeployFolder = this.server.getDeployFolder();
        Assert.isTrue((!deployPath.toFile().equals(new Path(serverDeployFolder).toFile()) ? 1 : 0) != 0, (String)"An attempt to delete your entire deploy folder has been prevented. This should never happen");
        final ArrayList status = new ArrayList();
        FileUtil.IFileUtilListener listener = new FileUtil.IFileUtilListener(){

            public void fileCopied(File source, File dest, boolean result, Exception e) {
            }

            public void fileDeleted(File file, boolean result, Exception e) {
                if (!result || e != null) {
                    status.add(new Status(4, "org.jboss.ide.eclipse.as.core", 0x2020008, NLS.bind((String)Messages.DeleteFileError, (Object)file.getAbsolutePath()), (Throwable)e));
                }
            }

            public void folderDeleted(File file, boolean result, Exception e) {
                if (!result || e != null) {
                    status.add(new Status(4, "org.jboss.ide.eclipse.as.core", 0x2020008, NLS.bind((String)Messages.DeleteFolderError, (Object)file.getAbsolutePath()), (Throwable)e));
                }
            }
        };
        FileUtil.safeDelete(deployPath.toFile(), listener);
        return status.toArray(new IStatus[status.size()]);
    }

    public int getPublishState() {
        return this.publishState;
    }
}

