/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.core.publishers;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.model.IModuleResourceDelta;
import org.jboss.ide.eclipse.as.core.ExtensionManager;
import org.jboss.ide.eclipse.as.core.extensions.events.ServerLogger;
import org.jboss.ide.eclipse.as.core.server.IJBossServerPublishMethod;
import org.jboss.ide.eclipse.as.core.server.IJBossServerPublisher;
import org.jboss.ide.eclipse.as.core.server.internal.DeployableServerBehavior;

public class LocalPublishMethod
implements IJBossServerPublishMethod {
    public static final String LOCAL_PUBLISH_METHOD = "local";

    public String getPublishMethodId() {
        return LOCAL_PUBLISH_METHOD;
    }

    public boolean accepts(String methodType) {
        return this.getPublishMethodId().equals(methodType);
    }

    public void publishStart(DeployableServerBehavior behaviour, IProgressMonitor monitor) throws CoreException {
    }

    public int publishFinish(DeployableServerBehavior behaviour, IProgressMonitor monitor) throws CoreException {
        IModule[] modules = behaviour.getServer().getModules();
        boolean allpublished = true;
        int i = 0;
        while (i < modules.length) {
            if (behaviour.getServer().getModulePublishState(new IModule[]{modules[i]}) != 1) {
                allpublished = false;
            }
            ++i;
        }
        return allpublished ? 1 : 2;
    }

    public int getServerPublishState(DeployableServerBehavior behaviour) {
        IModule[] modules = behaviour.getServer().getModules();
        boolean allpublished = true;
        int i = 0;
        while (i < modules.length) {
            if (behaviour.getServer().getModulePublishState(new IModule[]{modules[i]}) != 1) {
                allpublished = false;
            }
            ++i;
        }
        if (allpublished) {
            return 1;
        }
        return 2;
    }

    public int publishModule(DeployableServerBehavior behaviour, int kind, int deltaKind, IModule[] module, IProgressMonitor monitor) throws CoreException {
        if (module.length == 0) {
            return 1;
        }
        int modulePublishState = behaviour.getServer().getModulePublishState(module);
        int publishType = behaviour.getPublishType(kind, deltaKind, modulePublishState);
        if (module.length > 0) {
            IJBossServerPublisher publisher = ExtensionManager.getDefault().getPublisher(behaviour.getServer(), module, this.getPublishMethodId());
            IModuleResourceDelta[] deltas = new IModuleResourceDelta[]{};
            if (deltaKind != 3) {
                deltas = behaviour.getPublishedResourceDelta(module);
            }
            if (publisher != null) {
                IStatus result = publisher.publishModule(this, behaviour.getServer(), module, publishType, deltas, monitor);
                if (result != null) {
                    ServerLogger.getDefault().log(behaviour.getServer(), result);
                }
                return publisher.getPublishState();
            }
            return 2;
        }
        return 1;
    }
}

