/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.core.publishers;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.server.core.IEnterpriseApplication;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.model.IModuleFile;
import org.eclipse.wst.server.core.model.IModuleFolder;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.eclipse.wst.server.core.model.IModuleResourceDelta;
import org.eclipse.wst.server.core.model.ModuleDelegate;
import org.eclipse.wst.server.core.util.ProjectModule;
import org.jboss.ide.eclipse.as.core.server.IDeployableServer;
import org.jboss.ide.eclipse.as.core.server.xpl.ModulePackager;
import org.jboss.ide.eclipse.as.core.util.DeploymentPreferenceLoader;

public class PublishUtil {
    public static int countChanges(IModuleResourceDelta[] deltas) {
        int count = 0;
        if (deltas == null) {
            return 0;
        }
        int i = 0;
        while (i < deltas.length) {
            IModuleResource res = deltas[i].getModuleResource();
            if (res != null && res instanceof IModuleFile) {
                ++count;
            }
            count += PublishUtil.countChanges(deltas[i].getAffectedChildren());
            ++i;
        }
        return count;
    }

    public static int countMembers(IModule module) {
        try {
            ModuleDelegate delegate = (ModuleDelegate)module.loadAdapter(ModuleDelegate.class, (IProgressMonitor)new NullProgressMonitor());
            return delegate == null ? 0 : PublishUtil.countMembers(delegate.members());
        }
        catch (CoreException coreException) {
            return 0;
        }
    }

    public static int countMembers(IModuleResource[] resources) {
        int count = 0;
        if (resources == null) {
            return 0;
        }
        int i = 0;
        while (i < resources.length) {
            if (resources[i] instanceof IModuleFile) {
                ++count;
            } else if (resources[i] instanceof IModuleFolder) {
                count += PublishUtil.countMembers(((IModuleFolder)resources[i]).members());
            }
            ++i;
        }
        return count;
    }

    public static String getDeployRootFolder(IModule[] moduleTree, IDeployableServer server, String defaultFolder, String moduleProperty) {
        String loc;
        String folder = defaultFolder;
        DeploymentPreferenceLoader.DeploymentPreferences prefs = DeploymentPreferenceLoader.loadPreferencesFromServer(server.getServer());
        DeploymentPreferenceLoader.DeploymentTypePrefs typePrefs = prefs.getOrCreatePreferences("local");
        DeploymentPreferenceLoader.DeploymentModulePrefs modPrefs = typePrefs.getModulePrefs(moduleTree[0]);
        if (modPrefs != null && (loc = modPrefs.getProperty(moduleProperty)) != null && !loc.equals("")) {
            folder = !new Path(loc).isAbsolute() ? server.getServer().getRuntime().getLocation().append(loc).toString() : loc;
        }
        return folder;
    }

    public static IPath getDeployPath(IModule[] moduleTree, IDeployableServer server) {
        String folder = PublishUtil.getDeployRootFolder(moduleTree, server, server.getDeployFolder(), "location");
        return PublishUtil.getDeployPath(moduleTree, folder);
    }

    public static IPath getDeployRootFolder(IModule[] moduleTree, IDeployableServer server) {
        String folder = PublishUtil.getDeployRootFolder(moduleTree, server, server.getDeployFolder(), "location");
        return new Path(folder);
    }

    public static IPath getTempDeployFolder(IModule[] moduleTree, IDeployableServer server) {
        String folder = PublishUtil.getDeployRootFolder(moduleTree, server, server.getTempDeployFolder(), "tempLocation");
        return new Path(folder);
    }

    public static IPath getDeployPath(IModule[] moduleTree, String deployFolder) {
        Path root = new Path(deployFolder);
        int i = 0;
        while (i < moduleTree.length) {
            String type = moduleTree[i].getModuleType().getId();
            String modName = moduleTree[i].getName();
            String name = new Path(modName).lastSegment();
            String suffixedName = String.valueOf(name) + PublishUtil.getSuffix(type);
            String uri = PublishUtil.getParentRelativeURI(moduleTree, i, suffixedName);
            root = root.append(uri);
            ++i;
        }
        return root;
    }

    private static String getParentRelativeURI(IModule[] tree, int index, String defaultName) {
        String uri;
        IEnterpriseApplication parent;
        if (index != 0 && (parent = (IEnterpriseApplication)tree[index - 1].loadAdapter(IEnterpriseApplication.class, null)) != null && (uri = parent.getURI(tree[index])) != null) {
            return uri;
        }
        return defaultName;
    }

    private static String getSuffix(String type) {
        String suffix = null;
        suffix = "jst.ear".equals(type) ? ".ear" : ("jst.web".equals(type) ? ".war" : ("jst.connector".equals(type) ? ".rar" : ("jst.jboss.esb".equals(type) ? ".esb" : ("jboss.package".equals(type) ? "" : ".jar"))));
        return suffix;
    }

    public static boolean isBinaryObject(IModule[] moduleTree) {
        int i = 0;
        while (i < moduleTree.length) {
            String name = moduleTree[i].getName();
            if (new Path(name).segmentCount() > 1) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static IModuleResource[] getResources(IModule module) throws CoreException {
        ModuleDelegate md = (ModuleDelegate)module.loadAdapter(ModuleDelegate.class, (IProgressMonitor)new NullProgressMonitor());
        IModuleResource[] members = md.members();
        return members;
    }

    public static IModuleResource[] getResources(IModule[] tree) throws CoreException {
        return PublishUtil.getResources(tree[tree.length - 1]);
    }

    public static File getFile(IModuleResource resource) {
        IFile ifile;
        File source = (File)resource.getAdapter(File.class);
        if (source == null && (ifile = (IFile)resource.getAdapter(IFile.class)) != null) {
            source = ifile.getLocation().toFile();
        }
        return source;
    }

    public static boolean deployPackaged(IModule[] moduleTree) {
        if (moduleTree[moduleTree.length - 1].getModuleType().getId().equals("jst.utility")) {
            return true;
        }
        return moduleTree[moduleTree.length - 1].getModuleType().getId().equals("jst.appclient");
    }

    public static File getFile(IModuleFile mf) {
        return (IFile)mf.getAdapter(IFile.class) != null ? ((IFile)mf.getAdapter(IFile.class)).getLocation().toFile() : (File)mf.getAdapter(File.class);
    }

    public static IStatus[] packModuleIntoJar(IModule module, IPath destination) throws CoreException {
        String dest = destination.toString();
        ModulePackager packager = null;
        try {
            try {
                packager = new ModulePackager(dest, false);
                ProjectModule pm = (ProjectModule)module.loadAdapter(ProjectModule.class, null);
                IModuleResource[] resources = pm.members();
                int i = 0;
                while (i < resources.length) {
                    PublishUtil.doPackModule(resources[i], packager);
                    ++i;
                }
            }
            catch (IOException e) {
                Status status = new Status(4, "org.jboss.ide.eclipse.as.core", 0x2020009, "unable to assemble module " + module.getName(), (Throwable)e);
                IStatus[] iStatusArray = new IStatus[]{status};
                try {
                    if (packager != null) {
                        packager.finished();
                    }
                }
                catch (IOException e2) {
                    Status status2 = new Status(4, "org.jboss.ide.eclipse.as.core", 0x2020009, "unable to assemble module " + module.getName(), (Throwable)e2);
                    return new IStatus[]{status2};
                }
                return iStatusArray;
            }
        }
        catch (Throwable throwable) {
            try {
                if (packager != null) {
                    packager.finished();
                }
            }
            catch (IOException e) {
                Status status = new Status(4, "org.jboss.ide.eclipse.as.core", 0x2020009, "unable to assemble module " + module.getName(), (Throwable)e);
                return new IStatus[]{status};
            }
            throw throwable;
        }
        try {
            if (packager != null) {
                packager.finished();
            }
        }
        catch (IOException e) {
            Status status = new Status(4, "org.jboss.ide.eclipse.as.core", 0x2020009, "unable to assemble module " + module.getName(), (Throwable)e);
            return new IStatus[]{status};
        }
        return new IStatus[0];
    }

    public static void doPackModule(IModuleResource resource, ModulePackager packager) throws CoreException, IOException {
        if (resource instanceof IModuleFolder) {
            IModuleFolder mFolder = (IModuleFolder)resource;
            IModuleResource[] resources = mFolder.members();
            packager.writeFolder(resource.getModuleRelativePath().append(resource.getName()).toPortableString());
            int i = 0;
            while (resources != null && i < resources.length) {
                PublishUtil.doPackModule(resources[i], packager);
                ++i;
            }
        } else {
            String destination = resource.getModuleRelativePath().append(resource.getName()).toPortableString();
            IFile file = (IFile)resource.getAdapter(IFile.class);
            if (file != null) {
                packager.write(file, destination);
            } else {
                File file2 = (File)resource.getAdapter(File.class);
                packager.write(file2, destination);
            }
        }
    }
}

