/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.core.publishers;

import java.io.File;
import java.util.Date;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.model.IModuleResourceDelta;
import org.jboss.ide.eclipse.as.core.Messages;
import org.jboss.ide.eclipse.as.core.modules.SingleDeployableFactory;
import org.jboss.ide.eclipse.as.core.publishers.PublishUtil;
import org.jboss.ide.eclipse.as.core.server.IDeployableServer;
import org.jboss.ide.eclipse.as.core.server.IJBossServerPublishMethod;
import org.jboss.ide.eclipse.as.core.server.IJBossServerPublisher;
import org.jboss.ide.eclipse.as.core.util.FileUtil;
import org.jboss.ide.eclipse.as.core.util.ServerConverter;

public class SingleFilePublisher
implements IJBossServerPublisher {
    private IDeployableServer server;
    private int publishState = 1;

    public int getPublishState() {
        return this.publishState;
    }

    public boolean accepts(String method, IServer server, IModule[] module) {
        return "local".equals(method) && module != null && module.length > 0 && module[module.length - 1] != null && module[module.length - 1].getModuleType().getId().equals("jboss.singlefile");
    }

    public IStatus publishModule(IJBossServerPublishMethod method, IServer server, IModule[] module, int publishType, IModuleResourceDelta[] delta, IProgressMonitor monitor) throws CoreException {
        this.server = ServerConverter.getDeployableServer(server);
        IModule module2 = module[0];
        IStatus status = null;
        if (publishType == 3) {
            status = this.unpublish(this.server, module2, monitor);
        } else if (publishType == 2) {
            status = this.publish(this.server, module2, true, monitor);
        } else if (publishType == 1) {
            status = this.publish(this.server, module2, false, monitor);
        }
        return status;
    }

    protected IStatus publish(IDeployableServer server, IModule module, boolean updateTimestamp, IProgressMonitor monitor) throws CoreException {
        SingleDeployableFactory.SingleDeployableModuleDelegate delegate = (SingleDeployableFactory.SingleDeployableModuleDelegate)((Object)module.loadAdapter(SingleDeployableFactory.SingleDeployableModuleDelegate.class, (IProgressMonitor)new NullProgressMonitor()));
        if (delegate != null) {
            IPath sourcePath = delegate.getGlobalSourcePath();
            IPath destFolder = PublishUtil.getDeployPath(new IModule[]{module}, server).removeLastSegments(1);
            IPath tempDestFolder = PublishUtil.getTempDeployFolder(new IModule[]{module}, server).removeLastSegments(1);
            File destFile = destFolder.append(sourcePath.lastSegment()).toFile();
            File tempDestFile = tempDestFolder.append(sourcePath.lastSegment()).toFile();
            if (destFile.exists()) {
                destFile.delete();
            }
            FileUtilListener l = new FileUtilListener();
            FileUtil.fileSafeCopy(sourcePath.toFile(), tempDestFile, l);
            boolean success = tempDestFile.renameTo(destFile);
            if (success && updateTimestamp) {
                destFile.setLastModified(new Date().getTime());
            }
            if (l.errorFound || !success) {
                this.publishState = 3;
                Exception e = l.e != null ? l.e : new Exception(NLS.bind((String)Messages.CopyFileError, (Object)tempDestFile, (Object)destFile));
                return new Status(4, "org.jboss.ide.eclipse.as.core", 0x2030000, NLS.bind((String)Messages.CouldNotPublishModule, (Object)module.getName()), (Throwable)e);
            }
        } else {
            this.publishState = 0;
            Status status = new Status(2, "org.jboss.ide.eclipse.as.core", 33751056, NLS.bind((String)Messages.CouldNotPublishModule, (Object)module.getName()), null);
            return status;
        }
        Status status = new Status(0, "org.jboss.ide.eclipse.as.core", 33751041, NLS.bind((String)Messages.ModulePublished, (Object)module.getName()), null);
        return status;
    }

    protected IStatus unpublish(IDeployableServer server, IModule module, IProgressMonitor monitor) throws CoreException {
        SingleDeployableFactory.SingleDeployableModuleDelegate delegate = (SingleDeployableFactory.SingleDeployableModuleDelegate)((Object)module.loadAdapter(SingleDeployableFactory.SingleDeployableModuleDelegate.class, (IProgressMonitor)new NullProgressMonitor()));
        if (delegate != null) {
            IPath sourcePath = delegate.getGlobalSourcePath();
            IPath destFolder = PublishUtil.getDeployPath(new IModule[]{module}, server).removeLastSegments(1);
            FileUtilListener l = new FileUtilListener();
            File destFile = destFolder.append(sourcePath.lastSegment()).toFile();
            FileUtil.safeDelete(destFile, l);
            if (l.errorFound) {
                this.publishState = 3;
                return new Status(2, "org.jboss.ide.eclipse.as.core", 0x2030002, NLS.bind((String)Messages.DeleteModuleFail, (Object)module.getName()), (Throwable)l.e);
            }
        } else {
            this.publishState = 0;
            Status status = new Status(2, "org.jboss.ide.eclipse.as.core", 33751058, NLS.bind((String)Messages.DeleteModuleFail, (Object)module.getName()), null);
            return status;
        }
        Status status = new Status(0, "org.jboss.ide.eclipse.as.core", 0x2030003, NLS.bind((String)Messages.ModuleDeleted, (Object)module.getName()), null);
        return status;
    }

    public static class FileUtilListener
    implements FileUtil.IFileUtilListener {
        protected boolean errorFound = false;
        protected Exception e;

        public void fileCopied(File source, File dest, boolean result, Exception e) {
            if (!result || e != null) {
                this.errorFound = true;
                this.e = e;
            }
        }

        public void fileDeleted(File file, boolean result, Exception e) {
            if (!result || e != null) {
                this.errorFound = true;
                this.e = e;
            }
        }

        public void folderDeleted(File file, boolean result, Exception e) {
            if (!result || e != null) {
                this.errorFound = true;
                this.e = e;
            }
        }
    }
}

