/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.core.server;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.wst.server.core.IPublishListener;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerLifecycleListener;
import org.eclipse.wst.server.core.IServerListener;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.ServerEvent;
import org.jboss.ide.eclipse.as.core.server.IJBossServerRuntime;
import org.jboss.ide.eclipse.as.core.server.UnitedServerListener;

public class UnitedServerListenerManager
implements IServerLifecycleListener,
IServerListener,
IPublishListener {
    protected static UnitedServerListenerManager instance;
    protected ArrayList<UnitedServerListener> list = new ArrayList();

    public static UnitedServerListenerManager getDefault() {
        if (instance == null) {
            instance = new UnitedServerListenerManager();
        }
        return instance;
    }

    protected UnitedServerListenerManager() {
        ServerCore.addServerLifecycleListener((IServerLifecycleListener)this);
        IServer[] allServers = ServerCore.getServers();
        int i = 0;
        while (i < allServers.length) {
            if (this.isJBossServer(allServers[i])) {
                allServers[i].addServerListener((IServerListener)this);
                allServers[i].addPublishListener((IPublishListener)this);
            }
            ++i;
        }
    }

    private boolean isJBossServer(IServer server) {
        if (server == null) {
            return false;
        }
        IRuntime rt = server.getRuntime();
        if (rt == null) {
            return false;
        }
        IJBossServerRuntime jbsrt = (IJBossServerRuntime)rt.loadAdapter(IJBossServerRuntime.class, (IProgressMonitor)new NullProgressMonitor());
        return jbsrt != null;
    }

    public void addListener(UnitedServerListener listener) {
        if (!this.list.contains(listener)) {
            this.list.add(listener);
            IServer[] allServers = ServerCore.getServers();
            int i = 0;
            while (i < allServers.length) {
                if (this.isJBossServer(allServers[i])) {
                    listener.init(allServers[i]);
                }
                ++i;
            }
        }
    }

    public void removeListener(UnitedServerListener listener) {
        this.list.remove(listener);
        IServer[] allServers = ServerCore.getServers();
        int i = 0;
        while (i < allServers.length) {
            if (this.isJBossServer(allServers[i])) {
                listener.cleanUp(allServers[i]);
            }
            ++i;
        }
    }

    public void serverAdded(IServer server) {
        if (!this.isJBossServer(server)) {
            return;
        }
        server.addServerListener((IServerListener)this);
        server.addPublishListener((IPublishListener)this);
        Iterator<UnitedServerListener> i = this.list.iterator();
        while (i.hasNext()) {
            i.next().serverAdded(server);
        }
    }

    public void serverChanged(IServer server) {
        if (!this.isJBossServer(server)) {
            return;
        }
        Iterator<UnitedServerListener> i = this.list.iterator();
        while (i.hasNext()) {
            i.next().serverChanged(server);
        }
    }

    public void serverRemoved(IServer server) {
        if (!this.isJBossServer(server)) {
            return;
        }
        server.removeServerListener((IServerListener)this);
        server.removePublishListener((IPublishListener)this);
        Iterator<UnitedServerListener> i = this.list.iterator();
        while (i.hasNext()) {
            i.next().serverRemoved(server);
        }
    }

    public void serverChanged(ServerEvent event) {
        IServer server = event.getServer();
        if (!this.isJBossServer(server)) {
            return;
        }
        Iterator<UnitedServerListener> i = this.list.iterator();
        while (i.hasNext()) {
            i.next().serverChanged(event);
        }
    }

    public void publishStarted(IServer server) {
        if (!this.isJBossServer(server)) {
            return;
        }
        Iterator<UnitedServerListener> i = this.list.iterator();
        while (i.hasNext()) {
            i.next().publishStarted(server);
        }
    }

    public void publishFinished(IServer server, IStatus status) {
        if (!this.isJBossServer(server)) {
            return;
        }
        Iterator<UnitedServerListener> i = this.list.iterator();
        while (i.hasNext()) {
            i.next().publishFinished(server, status);
        }
    }
}

