/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.core.server.internal;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.server.core.IEnterpriseApplication;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IModuleType;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerPort;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.model.ServerDelegate;
import org.jboss.ide.eclipse.as.core.server.IDeployableServer;
import org.jboss.ide.eclipse.as.core.server.IJBossServerRuntime;
import org.jboss.ide.eclipse.as.core.server.internal.ServerAttributeHelper;
import org.jboss.ide.eclipse.as.core.util.ModuleUtil;
import org.jboss.ide.eclipse.as.wtp.core.modules.IJBTModule;

public class DeployableServer
extends ServerDelegate
implements IDeployableServer {
    protected void initialize() {
    }

    public void setDefaults(IProgressMonitor monitor) {
        IRuntime rt = this.getServer().getRuntime();
        if (rt != null) {
            this.getServerWorkingCopy().setName(org.jboss.ide.eclipse.as.core.util.ServerUtil.getDefaultServerName(rt));
        }
    }

    public void importRuntimeConfiguration(IRuntime runtime, IProgressMonitor monitor) throws CoreException {
    }

    public void saveConfiguration(IProgressMonitor monitor) throws CoreException {
    }

    public void configurationChanged() {
    }

    public IStatus canModifyModules(IModule[] add, IModule[] remove) {
        return Status.OK_STATUS;
    }

    public IModule[] getChildModules(IModule[] module) {
        IModule[] children = ModuleUtil.getChildModules(module);
        return children;
    }

    public IModule[] getRootModules(IModule module) throws CoreException {
        IStatus status = this.canModifyModules(new IModule[]{module}, null);
        if (status != null && !status.isOK()) {
            throw new CoreException(status);
        }
        IModule[] parents = this.doGetParentModules(module);
        if (parents.length > 0) {
            return parents;
        }
        return new IModule[]{module};
    }

    private IModule[] doGetParentModules(IModule module) {
        IModule[] supported = ServerUtil.getModules((IModuleType[])this.getServer().getServerType().getRuntimeType().getModuleTypes());
        ArrayList<IModule> list = new ArrayList<IModule>();
        int i = 0;
        while (i < supported.length) {
            int j;
            IModule[] childs;
            IEnterpriseApplication jeeMod = (IEnterpriseApplication)supported[i].loadAdapter(IEnterpriseApplication.class, null);
            IJBTModule jbtMod = (IJBTModule)supported[i].loadAdapter(IJBTModule.class, null);
            if (jeeMod != null) {
                childs = jeeMod.getModules();
                j = 0;
                while (j < childs.length) {
                    if (childs[j].equals(module)) {
                        list.add(supported[i]);
                    }
                    ++j;
                }
            } else if (jbtMod != null) {
                childs = jbtMod.getModules();
                j = 0;
                while (j < childs.length) {
                    if (childs[j].equals(module)) {
                        list.add(supported[i]);
                    }
                    ++j;
                }
            }
            ++i;
        }
        return list.toArray(new IModule[list.size()]);
    }

    public ServerPort[] getServerPorts() {
        return new ServerPort[0];
    }

    public void modifyModules(IModule[] add, IModule[] remove, IProgressMonitor monitor) throws CoreException {
    }

    public String getDeployFolder() {
        IJBossServerRuntime jbsrt = this.getRuntime();
        return org.jboss.ide.eclipse.as.core.util.ServerUtil.makeGlobal(jbsrt, (IPath)new Path(this.getAttribute("org.jboss.ide.eclipse.as.core.server.deployDirectory", ""))).toString();
    }

    public void setDeployFolder(String folder) {
        this.setAttribute("org.jboss.ide.eclipse.as.core.server.deployDirectory", org.jboss.ide.eclipse.as.core.util.ServerUtil.makeRelative(this.getRuntime(), (IPath)new Path(folder)).toString());
    }

    public String getTempDeployFolder() {
        IJBossServerRuntime jbsrt = this.getRuntime();
        return org.jboss.ide.eclipse.as.core.util.ServerUtil.makeGlobal(jbsrt, (IPath)new Path(this.getAttribute("org.jboss.ide.eclipse.as.core.server.tempDeployDirectory", ""))).toString();
    }

    public void setTempDeployFolder(String folder) {
        this.setAttribute("org.jboss.ide.eclipse.as.core.server.tempDeployDirectory", org.jboss.ide.eclipse.as.core.util.ServerUtil.makeRelative(this.getRuntime(), (IPath)new Path(folder)).toString());
    }

    public void setDeployLocationType(String type) {
        this.setAttribute("org.jboss.ide.eclipse.as.core.server.deployDirectoryType", type);
    }

    public String getDeployLocationType() {
        return this.getAttribute("org.jboss.ide.eclipse.as.core.server.deployDirectoryType", "custom");
    }

    public void setZipWTPDeployments(boolean val) {
        this.setAttribute("org.jboss.ide.eclipse.as.core.server.zipDeploymentsPreference", val);
    }

    public boolean zipsWTPDeployments() {
        return this.getAttribute("org.jboss.ide.eclipse.as.core.server.zipDeploymentsPreference", false);
    }

    public ServerAttributeHelper getAttributeHelper() {
        IServerWorkingCopy copy = this.getServerWorkingCopy();
        if (copy == null) {
            copy = this.getServer().createWorkingCopy();
        }
        return new ServerAttributeHelper(this.getServer(), copy);
    }

    public String getConfigDirectory() {
        return this.getDeployFolder();
    }

    public IJBossServerRuntime getRuntime() {
        return DeployableServer.getRuntime(this.getServer());
    }

    public static IJBossServerRuntime getRuntime(IServer server) {
        IJBossServerRuntime ajbsrt = null;
        if (server.getRuntime() != null) {
            ajbsrt = (IJBossServerRuntime)server.getRuntime().loadAdapter(IJBossServerRuntime.class, (IProgressMonitor)new NullProgressMonitor());
        }
        return ajbsrt;
    }
}

