/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.core.server.internal;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServerListener;
import org.eclipse.wst.server.core.ServerEvent;
import org.eclipse.wst.server.core.model.IModuleResourceDelta;
import org.eclipse.wst.server.core.model.ServerBehaviourDelegate;
import org.jboss.ide.eclipse.as.core.publishers.LocalPublishMethod;
import org.jboss.ide.eclipse.as.core.server.IJBossServerPublishMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeployableServerBehavior
extends ServerBehaviourDelegate {
    protected IJBossServerPublishMethod method;
    protected int serverStateVal;

    public void stop(boolean force) {
        this.setServerStopped();
    }

    public void setupLaunchConfiguration(ILaunchConfigurationWorkingCopy workingCopy, IProgressMonitor monitor) throws CoreException {
        workingCopy.setAttribute("org.jboss.ide.eclipse.as.core.server.stripped.DeployableLaunchConfiguration.Action", "_START_");
    }

    protected void publishStart(IProgressMonitor monitor) throws CoreException {
        if (this.method != null) {
            throw new CoreException((IStatus)new Status(4, "org.jboss.ide.eclipse.as.core", "Already publishing"));
        }
        this.method = this.createPublishMethod();
        this.method.publishStart(this, monitor);
    }

    protected void publishFinish(IProgressMonitor monitor) throws CoreException {
        if (this.method == null) {
            throw new CoreException((IStatus)new Status(4, "org.jboss.ide.eclipse.as.core", "Not publishing"));
        }
        int result = this.method.publishFinish(this, monitor);
        this.setServerPublishState(result);
        this.method = null;
    }

    protected void publishModule(int kind, int deltaKind, IModule[] module, IProgressMonitor monitor) throws CoreException {
        if (this.method == null) {
            throw new CoreException((IStatus)new Status(4, "org.jboss.ide.eclipse.as.core", "Not publishing"));
        }
        int result = this.method.publishModule(this, kind, deltaKind, module, monitor);
        this.setModulePublishState(module, result);
    }

    protected IJBossServerPublishMethod createPublishMethod() {
        return new LocalPublishMethod();
    }

    public IModuleResourceDelta[] getPublishedResourceDelta(IModule[] module) {
        return super.getPublishedResourceDelta(module);
    }

    public int getPublishType(int kind, int deltaKind, int modulePublishState) {
        if (1 == deltaKind) {
            return 2;
        }
        if (3 == deltaKind) {
            return 3;
        }
        if (kind == 2 || modulePublishState == 3 || kind == 4) {
            return 2;
        }
        if ((kind == 1 || modulePublishState == 2 || kind == 3) && 2 == deltaKind) {
            return 1;
        }
        return 0;
    }

    public List<IModule[]> getRemovedModules() {
        List moduleList = this.getAllModules();
        int size = moduleList.size();
        super.addRemovedModules(moduleList, null);
        int i = 0;
        while (i < size) {
            moduleList.remove(0);
            ++i;
        }
        return moduleList;
    }

    public boolean hasBeenPublished(IModule[] module) {
        return super.hasBeenPublished(module);
    }

    protected int getServerStateVal() {
        return this.serverStateVal;
    }

    public void setServerStarted() {
        this.serverStateVal = 2;
        this.setServerState(2);
    }

    public void setServerStarting() {
        this.serverStateVal = 1;
        this.setServerState(1);
    }

    public void setServerStopped() {
        this.serverStateVal = 4;
        this.setServerState(4);
    }

    public void setServerStopping() {
        this.serverStateVal = 3;
        this.setServerState(3);
    }

    protected void initialize(IProgressMonitor monitor) {
        this.serverStateVal = this.getServer().getServerState();
        this.getServer().addServerListener(new IServerListener(){

            public void serverChanged(ServerEvent event) {
                if (event.getState() != DeployableServerBehavior.this.serverStateVal && DeployableServerBehavior.this.serverStateVal == 1 && event.getState() == 4) {
                    DeployableServerBehavior.this.stop(true);
                }
            }
        });
    }
}

