/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.core.server.internal;

import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.server.core.EJBBean;
import org.eclipse.jst.server.core.JndiLaunchable;
import org.eclipse.jst.server.core.JndiObject;
import org.eclipse.jst.server.core.Servlet;
import org.eclipse.wst.server.core.IModuleArtifact;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.model.IURLProvider;
import org.eclipse.wst.server.core.model.LaunchableAdapterDelegate;
import org.eclipse.wst.server.core.model.ServerDelegate;
import org.eclipse.wst.server.core.util.HttpLaunchable;
import org.eclipse.wst.server.core.util.WebResource;
import org.jboss.ide.eclipse.as.core.server.internal.JBossServer;

public class JBossLaunchAdapter
extends LaunchableAdapterDelegate {
    private static final String JAVA_NAMING_PROVIDER_URL_PROPKEY = "java.naming.provider.url";
    private static final String JAVA_NAMING_FACTORY_INITIAL_PROPKEY = "java.naming.factory.initial";

    public Object getLaunchable(IServer server, IModuleArtifact moduleObject) {
        if (server != null) {
            ServerDelegate delegate = (ServerDelegate)server.loadAdapter(ServerDelegate.class, null);
            if (!(delegate instanceof JBossServer)) {
                return null;
            }
            if (moduleObject instanceof Servlet || moduleObject instanceof WebResource) {
                return this.prepareHttpLaunchable(moduleObject, delegate);
            }
            if (moduleObject instanceof EJBBean || moduleObject instanceof JndiObject) {
                return this.prepareJndiLaunchable(moduleObject, delegate);
            }
        }
        return null;
    }

    private Object prepareJndiLaunchable(IModuleArtifact moduleObject, ServerDelegate delegate) {
        JndiLaunchable launchable = null;
        JBossServer server = (JBossServer)delegate;
        IPath p = new Path(server.getConfigDirectory()).append("jndi.properties");
        Properties props = new Properties();
        try {
            props.load(new FileInputStream(p.toFile()));
        }
        catch (IOException iOException) {
            props.put(JAVA_NAMING_FACTORY_INITIAL_PROPKEY, "org.jnp.interfaces.NamingContextFactory");
            props.put(JAVA_NAMING_PROVIDER_URL_PROPKEY, "org.jboss.naming:org.jnp.interfaces");
        }
        if (moduleObject instanceof EJBBean) {
            EJBBean bean = (EJBBean)moduleObject;
            launchable = new JndiLaunchable(props, bean.getJndiName());
        }
        if (moduleObject instanceof JndiObject) {
            JndiObject jndi = (JndiObject)moduleObject;
            launchable = new JndiLaunchable(props, jndi.getJndiName());
        }
        return launchable;
    }

    private Object prepareHttpLaunchable(IModuleArtifact moduleObject, ServerDelegate delegate) {
        try {
            URL url = ((IURLProvider)delegate).getModuleRootURL(moduleObject.getModule());
            if (moduleObject instanceof Servlet) {
                Servlet servlet = (Servlet)moduleObject;
                if (servlet.getAlias() != null) {
                    String path = servlet.getAlias();
                    if (path.startsWith("/")) {
                        path = path.substring(1);
                    }
                    url = new URL(url, path);
                } else {
                    url = new URL(url, servlet.getName());
                }
            } else if (moduleObject instanceof WebResource) {
                WebResource resource = (WebResource)moduleObject;
                String path = resource.getPath().toString();
                if (path != null && path.startsWith("/") && path.length() > 0) {
                    path = path.substring(1);
                }
                if (path != null && path.length() > 0) {
                    url = new URL(url, path);
                }
            }
            return new HttpLaunchable(url);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }
}

