/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.core.server.internal;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jst.server.core.IWebModule;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.internal.Server;
import org.eclipse.wst.server.core.model.IURLProvider;
import org.jboss.ide.eclipse.as.core.JBossServerCorePlugin;
import org.jboss.ide.eclipse.as.core.Messages;
import org.jboss.ide.eclipse.as.core.extensions.descriptors.XPathModel;
import org.jboss.ide.eclipse.as.core.extensions.descriptors.XPathQuery;
import org.jboss.ide.eclipse.as.core.server.IDeployableServer;
import org.jboss.ide.eclipse.as.core.server.IJBossServerConstants;
import org.jboss.ide.eclipse.as.core.server.IJBossServerRuntime;
import org.jboss.ide.eclipse.as.core.server.internal.DeployableServer;
import org.jboss.ide.eclipse.as.core.util.ArgsUtil;
import org.jboss.ide.eclipse.as.core.util.ServerUtil;

public class JBossServer
extends DeployableServer
implements IJBossServerConstants,
IDeployableServer,
IURLProvider {
    public void setDefaults(IProgressMonitor monitor) {
        super.setDefaults(monitor);
        this.setAttribute("auto-publish-time", 1);
        this.setAttribute("id", String.valueOf(this.getAttribute("id", "")) + new Date().getTime());
    }

    public void saveConfiguration(IProgressMonitor monitor) throws CoreException {
        try {
            Server s = (Server)this.getServer();
            ILaunchConfiguration lc = s.getLaunchConfiguration(false, (IProgressMonitor)new NullProgressMonitor());
            if (lc != null) {
                IJBossServerRuntime runtime;
                String config;
                String startArgs;
                String originalArgs = startArgs = lc.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, null);
                if (!this.getServer().getHost().equals(this.getHost(true))) {
                    startArgs = ArgsUtil.setArg(startArgs, "-b", "--host", this.getServer().getHost());
                }
                if ((startArgs = ArgsUtil.setArg(startArgs, "-c", "--configuration", config = (runtime = (IJBossServerRuntime)this.getServer().getRuntime().loadAdapter(IJBossServerRuntime.class, null)).getJBossConfiguration())) != null && !startArgs.trim().equals(originalArgs)) {
                    ILaunchConfigurationWorkingCopy wc = lc.getWorkingCopy();
                    wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, startArgs);
                    wc.doSave();
                }
            }
        }
        catch (CoreException ce) {
            Status s = new Status(4, "org.jboss.ide.eclipse.as.core", NLS.bind((String)Messages.CannotSaveServersStartArgs, (Object)this.getServer().getName()), (Throwable)ce);
            JBossServerCorePlugin.getDefault().getLog().log((IStatus)s);
        }
    }

    public String getHost() {
        String host = this.getHost(true);
        return host == null ? this.getServer().getHost() : host;
    }

    public String getHost(boolean checkLaunchConfig) {
        String host = null;
        if (checkLaunchConfig) {
            try {
                String startArgs;
                String val;
                Server s = (Server)this.getServer();
                ILaunchConfiguration lc = s.getLaunchConfiguration(true, (IProgressMonitor)new NullProgressMonitor());
                if (lc != null && (val = ArgsUtil.getValue(startArgs = lc.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, null), "-b", "--host")) != null) {
                    host = val;
                }
            }
            catch (CoreException coreException) {}
        }
        return host;
    }

    public String getConfigDirectory() {
        return this.getConfigDirectory(true);
    }

    public String getConfigDirectory(boolean checkLaunchConfig) {
        if (!checkLaunchConfig) {
            return this.getRuntimeConfigDirectory();
        }
        String configDir = this.getLaunchConfigConfigurationDirectory();
        if (configDir == null) {
            return this.getRuntimeConfigDirectory();
        }
        File f = new File(configDir);
        if (!(f.exists() && f.canRead() && f.isDirectory())) {
            return this.getRuntimeConfigDirectory();
        }
        return new Path(configDir).toOSString();
    }

    public String getDeployFolder() {
        return JBossServer.getDeployFolder(this, this.getDeployLocationType());
    }

    public static String getDeployFolder(JBossServer jbs, String type) {
        IServer server = jbs.getServer();
        IJBossServerRuntime jbsrt = JBossServer.getRuntime(server);
        if (type.equals("custom")) {
            String val = jbs.getAttribute("org.jboss.ide.eclipse.as.core.server.deployDirectory", null);
            if (val != null) {
                Path val2 = new Path(val);
                return ServerUtil.makeGlobal(jbsrt, (IPath)val2).toString();
            }
            type = "metadata";
        }
        if (type.equals("metadata")) {
            return JBossServerCorePlugin.getServerStateLocation(server).append("deploy").makeAbsolute().toString();
        }
        if (type.equals("server")) {
            String loc = jbsrt.getConfigLocation();
            String config = jbsrt.getJBossConfiguration();
            IPath p = new Path(loc).append(config).append("deploy");
            return ServerUtil.makeGlobal(jbsrt, p).toString();
        }
        return null;
    }

    protected String getDeployFolder(boolean checkLaunchConfig) {
        return new Path(String.valueOf(this.getConfigDirectory(checkLaunchConfig)) + '/' + "deploy").toOSString();
    }

    public String getTempDeployFolder() {
        IJBossServerRuntime jbsrt = this.getRuntime();
        String type = this.getDeployLocationType();
        if (type.equals("custom")) {
            return ServerUtil.makeGlobal(jbsrt, (IPath)new Path(this.getAttribute("org.jboss.ide.eclipse.as.core.server.tempDeployDirectory", ""))).toString();
        }
        if (type.equals("metadata")) {
            return JBossServerCorePlugin.getServerStateLocation(this.getServer()).append("tempDeploy").makeAbsolute().toString();
        }
        if (type.equals("server")) {
            String loc = jbsrt.getConfigLocation();
            String config = jbsrt.getJBossConfiguration();
            IPath p = new Path(loc).append(config).append("tmp").append("jbosstoolsTemp");
            return ServerUtil.makeGlobal(jbsrt, p).toString();
        }
        return null;
    }

    protected String getLaunchConfigConfigurationDirectory() {
        try {
            Server s = (Server)this.getServer();
            ILaunchConfiguration lc = s.getLaunchConfiguration(true, (IProgressMonitor)new NullProgressMonitor());
            String startArgs = lc.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, null);
            Map<String, Object> map = ArgsUtil.getSystemProperties(startArgs);
            if (map.get("jboss.server.home.dir") != null) {
                return (String)map.get("jboss.server.home.dir");
            }
            if (map.get("jboss.server.base.dir") != null) {
                String name = map.get("jboss.server.name") != null ? (String)map.get("jboss.server.name") : "default";
                return String.valueOf((String)map.get("jboss.server.base.dir")) + '/' + name;
            }
            if (map.get("jboss.home.dir") != null) {
                return String.valueOf((String)map.get("jboss.home.dir")) + '/' + "server" + '/' + "default";
            }
        }
        catch (CoreException coreException) {}
        return null;
    }

    protected String getRuntimeConfigDirectory() {
        IJBossServerRuntime runtime = (IJBossServerRuntime)this.getServer().getRuntime().loadAdapter(IJBossServerRuntime.class, null);
        String p = String.valueOf(this.getServer().getRuntime().getLocation().toOSString()) + '/' + "server" + '/' + runtime.getJBossConfiguration();
        return new Path(p).toOSString();
    }

    public int getJNDIPort() {
        return this.findPort("org.jboss.ide.eclipse.as.core.server.jndiPort", "org.jboss.ide.eclipse.as.core.server.jndiPortAutoDetect", "org.jboss.ide.eclipse.as.core.server.jndiPortAutoDetect.XPath", JNDI_PORT_DEFAULT_XPATH, 1099);
    }

    public int getJBossWebPort() {
        return this.findPort("org.jboss.ide.eclipse.as.core.server.webPort", "org.jboss.ide.eclipse.as.core.server.webPortAutoDetect", "org.jboss.ide.eclipse.as.core.server.webPortAutoDetect.XPath", WEB_PORT_DEFAULT_XPATH, 8080);
    }

    protected int findPort(String attributeKey, String detectKey, String xpathKey, String defaultXPath, int defaultValue) {
        boolean detect = this.getAttribute(detectKey, true);
        String result = null;
        if (!detect) {
            result = this.getAttribute(attributeKey, null);
        } else {
            String xpath = this.getAttribute(xpathKey, defaultXPath);
            XPathQuery query = XPathModel.getDefault().getQuery(this.getServer(), (IPath)new Path(xpath));
            if (query != null) {
                result = query.getFirstResult();
            }
        }
        if (result != null) {
            try {
                return Integer.parseInt(result);
            }
            catch (NumberFormatException numberFormatException) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public URL getModuleRootURL(IModule module) {
        if (module == null || module.loadAdapter(IWebModule.class, null) == null) {
            return null;
        }
        IWebModule webModule = (IWebModule)module.loadAdapter(IWebModule.class, null);
        String host = this.getHost();
        String url = "http://" + host;
        int port = this.getJBossWebPort();
        if (port != 80) {
            url = String.valueOf(url) + ":" + port;
        }
        if (!(url = String.valueOf(url) + "/" + webModule.getContextRoot()).endsWith("/")) {
            url = String.valueOf(url) + "/";
        }
        try {
            return new URL(url);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public String getUsername() {
        return this.getAttribute("org.jboss.ide.eclipse.as.core.server.userName", "");
    }

    public void setUsername(String name) {
        this.setAttribute("org.jboss.ide.eclipse.as.core.server.userName", name);
    }

    public String getPassword() {
        return this.getAttribute("org.jboss.ide.eclipse.as.core.server.password", "");
    }

    public void setPassword(String pass) {
        this.setAttribute("org.jboss.ide.eclipse.as.core.server.password", pass);
    }
}

