/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.core.server.internal;

import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.wst.server.core.IRuntime;
import org.jboss.ide.eclipse.as.core.Messages;
import org.jboss.ide.eclipse.as.core.extensions.events.ServerLogger;
import org.jboss.ide.eclipse.as.core.extensions.jmx.JBossServerConnectionProvider;
import org.jboss.ide.eclipse.as.core.extensions.jmx.JMXClassLoaderRepository;
import org.jboss.ide.eclipse.as.core.server.IJBossServerRuntime;
import org.jboss.ide.eclipse.as.core.server.internal.DeployableServerBehavior;
import org.jboss.ide.eclipse.as.core.server.internal.PollThread;
import org.jboss.ide.eclipse.as.core.server.internal.launch.JBossServerStartupLaunchConfiguration;
import org.jboss.ide.eclipse.as.core.server.internal.launch.StopLaunchConfiguration;
import org.jboss.tools.jmx.core.IJMXRunnable;
import org.jboss.tools.jmx.core.JMXException;

public class JBossServerBehavior
extends DeployableServerBehavior {
    private PollThread pollThread = null;
    protected IProcess process;
    protected boolean nextStopRequiresForce = false;
    protected transient IDebugEventSetListener processListener;

    public void stop(boolean force) {
        int state = this.getServer().getServerState();
        if (force || this.process == null || this.process.isTerminated() || state == 4 || this.nextStopRequiresForce) {
            this.forceStop();
            return;
        }
        if (state == 1 || state == 3) {
            this.pollThread.cancel();
            this.forceStop();
            return;
        }
        this.serverStopping();
        new Thread(){

            public void run() {
                boolean success = StopLaunchConfiguration.stop(JBossServerBehavior.this.getServer());
                if (!success && JBossServerBehavior.this.process != null && !JBossServerBehavior.this.process.isTerminated()) {
                    JBossServerBehavior.this.setServerStarted();
                    JBossServerBehavior.this.pollThread.cancel(Messages.STOP_FAILED_MESSAGE);
                    JBossServerBehavior.this.nextStopRequiresForce = true;
                }
            }
        }.start();
    }

    public void forceStop() {
        if (this.process != null && !this.process.isTerminated()) {
            try {
                this.process.terminate();
                this.addForceStopEvent();
            }
            catch (DebugException e) {
                this.addForceStopFailedEvent(e);
            }
        }
        this.process = null;
        this.setServerStopped();
    }

    protected void addForceStopFailedEvent(DebugException e) {
        Status status = new Status(4, "org.jboss.ide.eclipse.as.core", 0x1030003, Messages.FORCE_TERMINATE_FAILED, (Throwable)e);
        ServerLogger.getDefault().log(this.getServer(), (IStatus)status);
    }

    protected void addForceStopEvent() {
        Status status = new Status(4, "org.jboss.ide.eclipse.as.core", 16973826, Messages.FORCE_TERMINATED, null);
        ServerLogger.getDefault().log(this.getServer(), (IStatus)status);
    }

    protected void addProcessTerminatedEvent() {
        Status status = new Status(1, "org.jboss.ide.eclipse.as.core", 0x1030001, Messages.TERMINATED, null);
        ServerLogger.getDefault().log(this.getServer(), (IStatus)status);
    }

    public void setupLaunchConfiguration(ILaunchConfigurationWorkingCopy workingCopy, IProgressMonitor monitor) throws CoreException {
        JBossServerStartupLaunchConfiguration.setupLaunchConfiguration(workingCopy, this.getServer());
    }

    public void setProcess(IProcess newProcess) {
        if (this.process != null) {
            return;
        }
        this.process = newProcess;
        if (this.processListener != null) {
            DebugPlugin.getDefault().removeDebugEventListener(this.processListener);
        }
        if (newProcess == null) {
            return;
        }
        this.processListener = new IDebugEventSetListener(){

            public void handleDebugEvents(DebugEvent[] events) {
                if (events != null) {
                    int size = events.length;
                    int i = 0;
                    while (i < size) {
                        if (JBossServerBehavior.this.process != null && JBossServerBehavior.this.process.equals(events[i].getSource()) && events[i].getKind() == 8) {
                            DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
                            JBossServerBehavior.this.forceStop();
                            JBossServerBehavior.this.addProcessTerminatedEvent();
                        }
                        ++i;
                    }
                }
            }
        };
        DebugPlugin.getDefault().addDebugEventListener(this.processListener);
    }

    public void setRunMode(String mode) {
        this.setMode(mode);
    }

    public void serverStarting() {
        this.nextStopRequiresForce = false;
        this.setServerStarting();
        this.pollServer(true);
    }

    public void serverStopping() {
        this.setServerStopping();
        this.pollServer(false);
    }

    public IProcess getProcess() {
        return this.process;
    }

    protected void pollServer(boolean expectedState) {
        if (this.pollThread != null) {
            this.pollThread.cancel();
        }
        this.pollThread = new PollThread(Messages.ServerPollerThreadName, expectedState, this);
        this.pollThread.start();
    }

    protected void publishStart(final IProgressMonitor monitor) throws CoreException {
        super.publishStart(monitor);
        if (this.shouldSuspendScanner()) {
            JMXClassLoaderRepository.getDefault().addConcerned(this.getServer(), (Object)this);
            IJMXRunnable r = new IJMXRunnable(){

                public void run(MBeanServerConnection connection) throws Exception {
                    JBossServerBehavior.this.suspendDeployment(connection, monitor);
                }
            };
            try {
                JBossServerConnectionProvider.run(this.getServer(), r);
            }
            catch (JMXException jmxe) {
                Status status = new Status(2, "org.jboss.ide.eclipse.as.core", 1107623936, Messages.JMXPauseScannerError, (Throwable)jmxe);
                ServerLogger.getDefault().log(this.getServer(), (IStatus)status);
            }
        }
    }

    protected void publishFinish(final IProgressMonitor monitor) throws CoreException {
        block6: {
            if (this.shouldSuspendScanner()) {
                IJMXRunnable r = new IJMXRunnable(){

                    public void run(MBeanServerConnection connection) throws Exception {
                        JBossServerBehavior.this.resumeDeployment(connection, monitor);
                    }
                };
                try {
                    try {
                        JBossServerConnectionProvider.run(this.getServer(), r);
                    }
                    catch (JMXException jmxe) {
                        Status status = new Status(2, "org.jboss.ide.eclipse.as.core", 1107689472, Messages.JMXResumeScannerError, (Throwable)jmxe);
                        ServerLogger.getDefault().log(this.getServer(), (IStatus)status);
                        JMXClassLoaderRepository.getDefault().removeConcerned(this.getServer(), (Object)this);
                        break block6;
                    }
                }
                catch (Throwable throwable) {
                    JMXClassLoaderRepository.getDefault().removeConcerned(this.getServer(), (Object)this);
                    throw throwable;
                }
                JMXClassLoaderRepository.getDefault().removeConcerned(this.getServer(), (Object)this);
            }
        }
        super.publishFinish(monitor);
    }

    protected boolean shouldSuspendScanner() {
        return this.getServer().getServerState() == 2;
    }

    protected void suspendDeployment(MBeanServerConnection connection, IProgressMonitor monitor) throws Exception {
        ObjectName name = new ObjectName("jboss.deployment:flavor=URL,type=DeploymentScanner");
        this.launchDeployCommand(connection, name, "stop", monitor);
    }

    protected void resumeDeployment(MBeanServerConnection connection, IProgressMonitor monitor) throws Exception {
        ObjectName name = new ObjectName("jboss.deployment:flavor=URL,type=DeploymentScanner");
        this.launchDeployCommand(connection, name, "start", monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void launchDeployCommand(final MBeanServerConnection connection, final ObjectName objectName, final String methodName, IProgressMonitor monitor) throws Exception {
        Object object;
        final Exception[] e = new Exception[1];
        final Object waitObject = new Object();
        final Boolean[] subtaskComplete = new Boolean[]{new Boolean(false)};
        Thread t = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Exception exception = null;
                try {
                    JBossServerBehavior.this.executeDeploymentCommand(connection, objectName, methodName);
                }
                catch (Exception ex) {
                    exception = ex;
                }
                Object object = waitObject;
                synchronized (object) {
                    e[0] = exception;
                    subtaskComplete[0] = new Boolean(true);
                    waitObject.notifyAll();
                }
            }
        };
        t.start();
        for (int count = 0; t.isAlive() && !monitor.isCanceled() && count <= 4000; count += 1000) {
            object = waitObject;
            synchronized (object) {
                if (subtaskComplete[0].booleanValue()) {
                    break;
                }
                waitObject.wait(1000L);
                continue;
            }
        }
        object = waitObject;
        synchronized (object) {
            if (!subtaskComplete[0].booleanValue()) {
                t.interrupt();
                Status status = new Status(2, "org.jboss.ide.eclipse.as.core", 1107755008, Messages.JMXScannerCanceled, null);
                ServerLogger.getDefault().log(this.getServer(), (IStatus)status);
            }
        }
    }

    protected void executeDeploymentCommand(MBeanServerConnection connection, ObjectName objectName, String methodName) throws Exception {
        connection.invoke(objectName, methodName, new Object[0], new String[0]);
    }

    public IStatus canStart(String launchMode) {
        return this.canChangeState(launchMode);
    }

    public IStatus canRestart(String launchMode) {
        return this.canChangeState(launchMode);
    }

    public IStatus canStop() {
        return this.canChangeState(null);
    }

    public IStatus canStop(String launchMode) {
        return this.canChangeState(launchMode);
    }

    protected IStatus canChangeState(String launchMode) {
        if (this.getServer() != null && this.getServer().getRuntime() != null && this.getRuntime().getVM() != null) {
            return Status.OK_STATUS;
        }
        return new Status(4, "org.jboss.ide.eclipse.as.core", "This server does not have a valid runtime environment");
    }

    private IJBossServerRuntime getRuntime() {
        IRuntime r = this.getServer().getRuntime();
        IJBossServerRuntime ajbsrt = null;
        if (r != null) {
            ajbsrt = (IJBossServerRuntime)r.loadAdapter(IJBossServerRuntime.class, (IProgressMonitor)new NullProgressMonitor());
        }
        return ajbsrt;
    }
}

