/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.core.server.internal;

import java.util.HashMap;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.internal.launching.environments.EnvironmentsManager;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.model.RuntimeDelegate;
import org.jboss.ide.eclipse.as.core.Messages;
import org.jboss.ide.eclipse.as.core.server.IJBossServerRuntime;
import org.jboss.ide.eclipse.as.core.util.IConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalJBossServerRuntime
extends RuntimeDelegate
implements IJBossServerRuntime {
    public void setDefaults(IProgressMonitor monitor) {
        this.getRuntimeWorkingCopy().setName(this.getNextRuntimeName());
        this.setAttribute("org.jboss.ide.eclipse.as.core.runtime.configurationName", "default");
        this.setExecutionEnvironment(LocalJBossServerRuntime.getDefaultExecutionEnvironment(this.getRuntime().getRuntimeType()));
        this.setVM(null);
    }

    private String getNextRuntimeName() {
        String version = this.getRuntime().getRuntimeType().getVersion();
        String base = null;
        base = this.getRuntime().getRuntimeType().getId().startsWith("org.jboss.ide.eclipse.as.runtime.eap.") ? String.valueOf(Messages.jboss) + " EAP " + version + " " + Messages.runtime : String.valueOf(Messages.jboss) + " " + version + " " + Messages.runtime;
        return LocalJBossServerRuntime.getNextRuntimeName(base);
    }

    public static String getNextRuntimeName(String base) {
        IRuntime rt = ServerCore.findRuntime((String)base);
        if (rt == null) {
            return base;
        }
        int i = 0;
        while (rt != null) {
            rt = ServerCore.findRuntime((String)(String.valueOf(base) + " " + ++i));
        }
        return String.valueOf(base) + " " + i;
    }

    public IStatus validate() {
        IStatus s = super.validate();
        if (!s.isOK()) {
            return s;
        }
        if (this.getJBossConfiguration().equals("")) {
            return new Status(4, "org.jboss.ide.eclipse.as.core", 0, NLS.bind((String)Messages.ServerRuntimeConfigNotFound, (Object)this.getRuntime().getName()), null);
        }
        return Status.OK_STATUS;
    }

    @Override
    public IVMInstall getVM() {
        if (this.getVMInstallTypeId() != null) {
            String id = this.getAttribute("PROPERTY_VM_ID", null);
            String type = this.getAttribute("PROPERTY_VM_TYPE_ID", null);
            IVMInstallType vmInstallType = JavaRuntime.getVMInstallType((String)type);
            IVMInstall[] vmInstalls = vmInstallType.getVMInstalls();
            int i = 0;
            while (i < vmInstalls.length) {
                if (id.equals(vmInstalls[i].getId())) {
                    return vmInstalls[i];
                }
                ++i;
            }
        }
        if (this.getExecutionEnvironment() != null) {
            IVMInstall[] installs = this.getExecutionEnvironment().getCompatibleVMs();
            if (this.getExecutionEnvironment().getDefaultVM() != null) {
                return this.getExecutionEnvironment().getDefaultVM();
            }
            if (installs != null && installs.length > 0 && installs[0] != null) {
                return installs[0];
            }
        }
        return this.getDefaultVMInstall();
    }

    @Override
    public void setVM(IVMInstall selectedVM) {
        if (selectedVM == null) {
            this.setAttribute("PROPERTY_VM_ID", null);
            this.setAttribute("PROPERTY_VM_TYPE_ID", null);
        } else {
            this.setAttribute("PROPERTY_VM_ID", selectedVM.getId());
            this.setAttribute("PROPERTY_VM_TYPE_ID", selectedVM.getVMInstallType().getId());
        }
    }

    @Override
    public String getJBossConfiguration() {
        return this.getAttribute("org.jboss.ide.eclipse.as.core.runtime.configurationName", "");
    }

    @Override
    public void setJBossConfiguration(String config) {
        this.setAttribute("org.jboss.ide.eclipse.as.core.runtime.configurationName", config);
    }

    @Override
    public String getDefaultRunArgs() {
        return "--configuration=" + this.getJBossConfiguration() + " ";
    }

    @Override
    public String getDefaultRunVMArgs() {
        IRuntimeType type;
        IConstants c = new IConstants(){};
        String name = this.getRuntime().getName();
        String ret = String.valueOf("-D") + "program.name" + "=" + "\"" + "JBossTools: " + name + "\"" + " ";
        if (Platform.getOS().equals("macosx")) {
            ret = String.valueOf(ret) + "-server" + " ";
        }
        ret = (type = this.getRuntime().getRuntimeType()) != null && ("org.jboss.ide.eclipse.as.runtime.50".equals(type.getId()) || "org.jboss.ide.eclipse.as.runtime.51".equals(type.getId()) || "org.jboss.ide.eclipse.as.runtime.60".equals(type.getId()) || "org.jboss.ide.eclipse.as.runtime.eap.50".equals(type.getId())) ? String.valueOf(ret) + "-Xms256m -Xmx768m -XX:MaxPermSize=256m " : String.valueOf(ret) + "-Xms256m -Xmx512m -XX:MaxPermSize=256m ";
        if (Platform.getOS().equals("linux")) {
            ret = String.valueOf(ret) + "-D" + "java.net.preferIPv4Stack" + "=" + true + " ";
        }
        ret = String.valueOf(ret) + "-D" + "sun.rmi.dgc.client.gcInterval" + "=" + 3600000 + " ";
        ret = String.valueOf(ret) + "-D" + "sun.rmi.dgc.server.gcInterval" + "=" + 3600000 + " ";
        ret = String.valueOf(ret) + "-D" + "java.endorsed.dirs" + "=" + "\"" + this.getRuntime().getLocation().append("lib").append("endorsed") + "\"" + " ";
        if (this.getRuntime().getLocation().append("bin").append("native").toFile().exists()) {
            ret = String.valueOf(ret) + "-D" + "java.library.path" + "=" + "\"" + this.getRuntime().getLocation().append("bin").append("native") + "\"" + " ";
        }
        return ret;
    }

    @Override
    public HashMap<String, String> getDefaultRunEnvVars() {
        HashMap<String, String> envVars = new HashMap<String, String>(1);
        envVars.put("Path", "native");
        return envVars;
    }

    @Override
    public boolean isUsingDefaultJRE() {
        return this.getVMInstallTypeId() == null;
    }

    protected String getVMInstallTypeId() {
        return this.getAttribute("PROPERTY_VM_TYPE_ID", null);
    }

    @Override
    public String getConfigLocation() {
        return this.getAttribute("org.jboss.ide.eclipse.as.core.runtime.configurationLocation", "server");
    }

    @Override
    public void setConfigLocation(String configLocation) {
        this.setAttribute("org.jboss.ide.eclipse.as.core.runtime.configurationLocation", configLocation);
    }

    @Override
    public IPath getConfigurationFullPath() {
        return this.getConfigLocationFullPath().append(this.getJBossConfiguration());
    }

    @Override
    public IPath getConfigLocationFullPath() {
        String cl = this.getConfigLocation();
        if (new Path(cl).isAbsolute()) {
            return new Path(cl);
        }
        return this.getRuntime().getLocation().append(cl);
    }

    protected IVMInstall getDefaultVMInstall() {
        return this.getExecutionEnvironment().getDefaultVM();
    }

    public static IVMInstall[] getValidJREs(IRuntimeType type) {
        return LocalJBossServerRuntime.getDefaultExecutionEnvironment(type) == null ? new IVMInstall[]{} : LocalJBossServerRuntime.getDefaultExecutionEnvironment(type).getCompatibleVMs();
    }

    @Override
    public IExecutionEnvironment getExecutionEnvironment() {
        String id = this.getAttribute("PROPERTY_EXEC_ENVIRONMENT", null);
        return id == null ? LocalJBossServerRuntime.getDefaultExecutionEnvironment(this.getRuntime().getRuntimeType()) : EnvironmentsManager.getDefault().getEnvironment(id);
    }

    public static IExecutionEnvironment getDefaultExecutionEnvironment(IRuntimeType rtType) {
        String typeId = rtType.getId();
        if (typeId.equals("org.jboss.ide.eclipse.as.runtime.eap.50") || typeId.equals("org.jboss.ide.eclipse.as.runtime.60")) {
            return EnvironmentsManager.getDefault().getEnvironment("JavaSE-1.6");
        }
        return EnvironmentsManager.getDefault().getEnvironment("J2SE-1.4");
    }

    @Override
    public void setExecutionEnvironment(IExecutionEnvironment environment) {
        this.setAttribute("PROPERTY_EXEC_ENVIRONMENT", environment.getId());
    }
}

