/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.core.server.internal;

import java.util.Date;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IServer;
import org.jboss.ide.eclipse.as.core.ExtensionManager;
import org.jboss.ide.eclipse.as.core.Messages;
import org.jboss.ide.eclipse.as.core.extensions.events.ServerLogger;
import org.jboss.ide.eclipse.as.core.server.IPollerFailureHandler;
import org.jboss.ide.eclipse.as.core.server.IServerStatePoller;
import org.jboss.ide.eclipse.as.core.server.internal.JBossServer;
import org.jboss.ide.eclipse.as.core.server.internal.JBossServerBehavior;
import org.jboss.ide.eclipse.as.core.server.internal.ServerAttributeHelper;
import org.jboss.ide.eclipse.as.core.server.internal.ServerStatePollerType;
import org.jboss.ide.eclipse.as.core.util.ServerConverter;

public class PollThread
extends Thread {
    public static final int POLLING_ROOT_CODE = 0x1010000;
    public static final int SUCCESS = 1;
    public static final int FAIL = 0;
    public static final int POLLING_FAIL_CODE = 0x1010000;
    public static final int STATE_MASK = 56;
    public static final int STATE_UNKNOWN = 0;
    public static final int STATE_STARTING = 8;
    public static final int STATE_STARTED = 16;
    public static final int STATE_STOPPING = 24;
    public static final int STATE_STOPPED = 32;
    public static final String SERVER_STARTING = "org.jboss.ide.eclipse.as.core.runtime.server.PollThread.server.starting";
    public static final String SERVER_STOPPING = "org.jboss.ide.eclipse.as.core.runtime.server.PollThread.server.stopping";
    private boolean expectedState;
    private boolean abort;
    private boolean stateStartedOrStopped;
    private IServerStatePoller poller;
    private String abortMessage;
    private JBossServerBehavior behavior;
    private String pollerId;

    public PollThread(String name, boolean expectedState, JBossServerBehavior behavior) {
        super(name);
        this.expectedState = expectedState;
        this.abort = false;
        this.abortMessage = null;
        this.behavior = behavior;
        this.poller = this.discoverPoller(behavior, expectedState);
    }

    protected IServerStatePoller discoverPoller(JBossServerBehavior behavior, boolean expectedState) {
        JBossServer s = ServerConverter.getJBossServer(behavior.getServer());
        ServerAttributeHelper helper = s.getAttributeHelper();
        String key = expectedState ? "org.jboss.ide.eclipse.as.core.server.attributes.startupPollerKey" : "org.jboss.ide.eclipse.as.core.server.attributes.shutdownPollerKey";
        String defaultPoller = expectedState ? "org.jboss.ide.eclipse.as.core.runtime.server.JMXPoller" : "org.jboss.ide.eclipse.as.core.runtime.server.processTerminatedPoller";
        this.pollerId = helper.getAttribute(key, defaultPoller);
        ServerStatePollerType type = ExtensionManager.getDefault().getPollerType(this.pollerId);
        if (type != null) {
            IServerStatePoller tempPoller = type.createPoller();
            tempPoller.setPollerType(type);
            return tempPoller;
        }
        return null;
    }

    public void cancel() {
        this.cancel(null);
    }

    public void cancel(String message) {
        this.abort = true;
        this.abortMessage = message;
        this.poller.cancel(0);
    }

    public int getTimeout() {
        if (this.expectedState) {
            return (this.getServer().getStartTimeout() - 2) * 1000;
        }
        return (this.getServer().getStopTimeout() - 2) * 1000;
    }

    public void run() {
        if (this.poller == null) {
            this.alertEventLogStarting();
            this.alertPollerNotFound();
            this.alertBehavior(!this.expectedState, false);
            return;
        }
        int maxWait = this.getTimeout();
        this.alertEventLogStarting();
        long startTime = new Date().getTime();
        boolean done = false;
        this.poller.beginPolling(this.getServer(), this.expectedState, this);
        while (!this.stateStartedOrStopped && !this.abort && !done && new Date().getTime() < startTime + (long)maxWait || maxWait < 0) {
            block17: {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
                try {
                    done = this.poller.isComplete();
                }
                catch (IServerStatePoller.PollingException e) {
                    this.poller.cancel(0);
                    this.poller.cleanup();
                    this.alertEventLogPollerException(e);
                    this.alertBehavior(!this.expectedState, false);
                    return;
                }
                catch (IServerStatePoller.RequiresInfoException rie) {
                    if (rie.getChecked()) break block17;
                    rie.setChecked();
                    String action = this.expectedState ? SERVER_STARTING : SERVER_STOPPING;
                    IPollerFailureHandler handler = ExtensionManager.getDefault().getFirstPollFailureHandler(this.poller, action, this.poller.getRequiredProperties());
                    handler.handle(this.poller, action, this.poller.getRequiredProperties());
                }
            }
            this.stateStartedOrStopped = this.checkServerState();
        }
        if (this.stateStartedOrStopped) {
            int state = this.behavior.getServer().getServerState();
            boolean success = false;
            success = this.expectedState ? state == 2 : state == 4;
            this.poller.cancel(success ? 2 : 3);
            this.poller.cleanup();
        } else if (this.abort) {
            this.poller.cleanup();
            this.alertEventLogAbort();
        } else {
            boolean currentState = !this.expectedState;
            boolean finalAlert = true;
            if (done) {
                try {
                    currentState = this.poller.getState();
                    this.poller.cleanup();
                    this.alertBehavior(currentState, finalAlert);
                }
                catch (IServerStatePoller.PollingException pe) {
                    this.poller.cancel(0);
                    this.poller.cleanup();
                    this.alertEventLogPollerException(pe);
                    this.alertBehavior(!this.expectedState, false);
                    return;
                }
                catch (IServerStatePoller.RequiresInfoException requiresInfoException) {}
            } else {
                this.poller.cancel(1);
                int behavior = this.poller.getTimeoutBehavior();
                this.poller.cleanup();
                this.alertEventLogTimeout();
                if (behavior != 1) {
                    currentState = this.expectedState == (behavior == 0);
                    finalAlert = false;
                    this.alertBehavior(currentState, finalAlert);
                }
            }
        }
    }

    protected boolean checkServerState() {
        int state = this.behavior.getServer().getServerState();
        if (state == 2) {
            return true;
        }
        return state == 4;
    }

    protected void alertBehavior(boolean currentState, boolean finalAlert) {
        if (currentState != this.expectedState) {
            this.behavior.forceStop();
            if (finalAlert) {
                this.alertEventLogFailure();
            }
        } else {
            if (currentState) {
                this.behavior.setServerStarted();
            } else {
                this.behavior.forceStop();
            }
            if (finalAlert) {
                this.alertEventLogSuccess(currentState);
            }
        }
    }

    protected IServer getServer() {
        return this.behavior.getServer();
    }

    protected void alertEventLogStarting() {
        String message = this.expectedState ? Messages.PollingStarting : Messages.PollingShuttingDown;
        int state = this.expectedState ? 8 : 24;
        Status status = new Status(1, "org.jboss.ide.eclipse.as.core", 0x1010000 | state, message, null);
        ServerLogger.getDefault().log(this.behavior.getServer(), (IStatus)status);
    }

    protected void alertEventLogPollerException(IServerStatePoller.PollingException e) {
        Status status = new Status(4, "org.jboss.ide.eclipse.as.core", 0x1010000, Messages.PollerFailure, (Throwable)e);
        ServerLogger.getDefault().log(this.behavior.getServer(), (IStatus)status);
    }

    protected void alertEventLogAbort() {
        Status status = new Status(2, "org.jboss.ide.eclipse.as.core", 0x1010000 | this.getStateMask(this.expectedState, false), NLS.bind((String)Messages.PollerAborted, (Object)this.abortMessage), null);
        ServerLogger.getDefault().log(this.behavior.getServer(), (IStatus)status);
    }

    protected void alertEventLogTimeout() {
        Status status = new Status(4, "org.jboss.ide.eclipse.as.core", 0x1010000 | this.getStateMask(this.expectedState, false), "", null);
        ServerLogger.getDefault().log(this.behavior.getServer(), (IStatus)status);
    }

    protected void alertEventLogFailure() {
        String startupFailed = Messages.PollingStartupFailed;
        String shutdownFailed = Messages.PollingShutdownFailed;
        Status status = new Status(4, "org.jboss.ide.eclipse.as.core", 0x1010000 | this.getStateMask(this.expectedState, false), this.expectedState ? startupFailed : shutdownFailed, null);
        ServerLogger.getDefault().log(this.behavior.getServer(), (IStatus)status);
    }

    protected void alertEventLogSuccess(boolean currentState) {
        String startupSuccess = Messages.PollingStartupSuccess;
        String shutdownSuccess = Messages.PollingShutdownSuccess;
        int state = this.getStateMask(this.expectedState, true);
        Status status = new Status(1, "org.jboss.ide.eclipse.as.core", 0x1010000 | state | 1, this.expectedState ? startupSuccess : shutdownSuccess, null);
        ServerLogger.getDefault().log(this.behavior.getServer(), (IStatus)status);
    }

    protected void alertPollerNotFound() {
        String startupPollerNotFound = NLS.bind((String)Messages.StartupPollerNotFound, (Object)this.pollerId);
        String shutdownPollerNotFound = NLS.bind((String)Messages.ShutdownPollerNotFound, (Object)this.pollerId);
        Status status = new Status(4, "org.jboss.ide.eclipse.as.core", 0x1010000 | this.getStateMask(this.expectedState, false), this.expectedState ? startupPollerNotFound : shutdownPollerNotFound, null);
        ServerLogger.getDefault().log(this.behavior.getServer(), (IStatus)status);
    }

    protected int getStateMask(boolean expected, boolean success) {
        if (expected && success) {
            return 16;
        }
        if (!expected && !success) {
            return 16;
        }
        return 32;
    }
}

