/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.core.server.internal;

import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.internal.Server;
import org.eclipse.wst.server.core.internal.ServerWorkingCopy;
import org.jboss.ide.eclipse.as.core.JBossServerCorePlugin;
import org.jboss.ide.eclipse.as.core.Messages;

public class ServerAttributeHelper {
    private ServerWorkingCopy wch;
    private IServer server;

    public static ServerAttributeHelper createHelper(IServer iserver) {
        IServerWorkingCopy copy;
        if (iserver instanceof Server && (copy = ((Server)iserver).createWorkingCopy()) != null) {
            return new ServerAttributeHelper(iserver, copy);
        }
        return null;
    }

    public ServerAttributeHelper(IServer server, IServerWorkingCopy copy) {
        this.wch = (ServerWorkingCopy)copy;
        this.server = server;
    }

    public IServer getServer() {
        return this.server;
    }

    public void setAttribute(String attributeName, int value) {
        this.wch.setAttribute(attributeName, value);
    }

    public void setAttribute(String attributeName, boolean value) {
        this.wch.setAttribute(attributeName, value);
    }

    public void setAttribute(String attributeName, String value) {
        this.wch.setAttribute(attributeName, value);
    }

    public void setAttribute(String attributeName, List value) {
        this.wch.setAttribute(attributeName, value);
    }

    public void setAttribute(String attributeName, Map value) {
        this.wch.setAttribute(attributeName, value);
    }

    public String getAttribute(String attributeName, String defaultValue) {
        return this.wch.getAttribute(attributeName, defaultValue);
    }

    public int getAttribute(String attributeName, int defaultValue) {
        return this.wch.getAttribute(attributeName, defaultValue);
    }

    public boolean getAttribute(String attributeName, boolean defaultValue) {
        return this.wch.getAttribute(attributeName, defaultValue);
    }

    public List getAttribute(String attributeName, List defaultValue) {
        return this.wch.getAttribute(attributeName, defaultValue);
    }

    public Map getAttribute(String attributeName, Map defaultValue) {
        return this.wch.getAttribute(attributeName, defaultValue);
    }

    public IServerWorkingCopy getWorkingCopy() {
        return this.wch;
    }

    public boolean isDirty() {
        return this.wch.isDirty();
    }

    public IServer save(boolean force, IProgressMonitor monitor) throws CoreException {
        return this.wch.save(force, monitor);
    }

    public IServer save() {
        try {
            return this.save(false, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception e) {
            Status s = new Status(4, "org.jboss.ide.eclipse.as.core", Messages.ServerSaveFailed, (Throwable)e);
            JBossServerCorePlugin.getDefault().getLog().log((IStatus)s);
            return null;
        }
    }
}

