/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.core.server.internal;

import java.io.File;
import java.util.ArrayList;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IModuleType;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerEvent;
import org.eclipse.wst.server.core.ServerUtil;
import org.jboss.ide.eclipse.as.core.JBossServerCorePlugin;
import org.jboss.ide.eclipse.as.core.Messages;
import org.jboss.ide.eclipse.as.core.extensions.events.ServerLogger;
import org.jboss.ide.eclipse.as.core.extensions.jmx.JBossServerConnectionProvider;
import org.jboss.ide.eclipse.as.core.publishers.PublishUtil;
import org.jboss.ide.eclipse.as.core.server.UnitedServerListener;
import org.jboss.ide.eclipse.as.core.server.internal.JBossServer;
import org.jboss.ide.eclipse.as.core.util.FileUtil;
import org.jboss.ide.eclipse.as.core.util.ServerConverter;
import org.jboss.tools.jmx.core.IJMXRunnable;
import org.jboss.tools.jmx.core.JMXException;

public class ServerListener
extends UnitedServerListener {
    private static ServerListener instance;

    public static ServerListener getDefault() {
        if (instance == null) {
            instance = new ServerListener();
        }
        return instance;
    }

    public void serverAdded(IServer server) {
        org.jboss.ide.eclipse.as.core.util.ServerUtil.createStandardFolders(server);
    }

    public void serverRemoved(IServer server) {
        File f = JBossServerCorePlugin.getServerStateLocation(server).toFile();
        FileUtil.safeDelete(f);
    }

    public void serverChanged(ServerEvent event) {
        IServer server = event.getServer();
        JBossServer jbs = (JBossServer)server.loadAdapter(JBossServer.class, (IProgressMonitor)new NullProgressMonitor());
        if (jbs != null) {
            this.doDeploymentAddition(event);
        }
    }

    protected void doDeploymentAddition(final ServerEvent event) {
        int eventKind = event.getKind();
        if ((eventKind & 0x10) != 0 && (eventKind & 1) != 0 && event.getServer().getServerState() == 2) {
            IJMXRunnable r = new IJMXRunnable(){

                public void run(MBeanServerConnection connection) throws Exception {
                    ServerListener.this.ensureDeployLocationAdded(event.getServer(), connection);
                }
            };
            try {
                JBossServerConnectionProvider.run(event.getServer(), r);
            }
            catch (JMXException jmxe) {
                IStatus s = jmxe.getStatus();
                Status newStatus = new Status(s.getSeverity(), s.getPlugin(), 33816577, Messages.AddingJMXDeploymentFailed, s.getException());
                ServerLogger.getDefault().log(event.getServer(), (IStatus)newStatus);
            }
        }
    }

    protected void ensureDeployLocationAdded(IServer server, MBeanServerConnection connection) throws Exception {
        int i;
        IModule[] modules2;
        JBossServer ds = ServerConverter.getJBossServer(server);
        ArrayList<String> folders = new ArrayList<String>();
        String insideServer = JBossServer.getDeployFolder(ds, "server");
        String metadata = JBossServer.getDeployFolder(ds, "metadata");
        String custom = JBossServer.getDeployFolder(ds, "custom");
        String serverHome = null;
        if (server != null && server.getRuntime() != null && server.getRuntime().getLocation() != null) {
            serverHome = server.getRuntime().getLocation().toString();
        }
        folders.add(insideServer);
        if (!folders.contains(metadata)) {
            folders.add(metadata);
        }
        if (!folders.contains(custom) && !custom.equals(serverHome)) {
            folders.add(custom);
        }
        if ((modules2 = ServerUtil.getModules((IModuleType[])server.getServerType().getRuntimeType().getModuleTypes())) != null) {
            int size = modules2.length;
            i = 0;
            while (i < size) {
                String tempFolder;
                IModule[] module = new IModule[]{modules2[i]};
                IStatus status = server.canModifyModules(module, null, null);
                if (status != null && status.getSeverity() != 4 && !folders.contains(tempFolder = PublishUtil.getDeployRootFolder(module, ds).toString())) {
                    folders.add(tempFolder);
                }
                ++i;
            }
        }
        folders.remove(insideServer);
        String[] folders2 = folders.toArray(new String[folders.size()]);
        i = 0;
        while (i < folders2.length) {
            String asURL = new File(folders2[i]).toURL().toString();
            ObjectName name = new ObjectName("jboss.deployment:flavor=URL,type=DeploymentScanner");
            connection.invoke(name, "addURL", new Object[]{asURL}, new String[]{String.class.getName()});
            ++i;
        }
    }
}

