/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.core.server.internal.launch;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.launching.AbstractJavaLaunchConfigurationDelegate;
import org.eclipse.jdt.launching.ExecutionArguments;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMRunner;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.VMRunnerConfiguration;
import org.eclipse.jst.server.core.ServerProfilerDelegate;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.ServerUtil;
import org.jboss.ide.eclipse.as.core.JBossServerCorePlugin;
import org.jboss.ide.eclipse.as.core.Messages;
import org.jboss.ide.eclipse.as.core.server.IJBossServerRuntime;
import org.jboss.ide.eclipse.as.core.server.internal.JBossServer;
import org.jboss.ide.eclipse.as.core.server.internal.JBossServerBehavior;
import org.jboss.ide.eclipse.as.core.util.ServerConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJBossLaunchConfigType
extends AbstractJavaLaunchConfigurationDelegate {
    public static final String SERVER_ID = "server-id";

    public boolean preLaunchCheck(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        return true;
    }

    protected void preLaunch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
    }

    protected void postLaunch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
    }

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        this.preLaunch(configuration, mode, launch, monitor);
        this.actualLaunch(configuration, mode, launch, monitor);
        this.postLaunch(configuration, mode, launch, monitor);
    }

    protected void actualLaunch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        IVMInstall vm = this.verifyVMInstall(configuration);
        IVMRunner runner = vm.getVMRunner(mode);
        if (runner == null && "profile".equals(mode)) {
            runner = vm.getVMRunner("run");
        }
        if (runner == null) {
            throw new CoreException((IStatus)new Status(4, "org.jboss.ide.eclipse.as.core", 0, Messages.runModeNotSupported, null));
        }
        File workingDir = this.verifyWorkingDirectory(configuration);
        String workingDirName = null;
        if (workingDir != null) {
            workingDirName = workingDir.getAbsolutePath();
        }
        String pgmArgs = this.getProgramArguments(configuration);
        String vmArgs = this.getVMArguments(configuration);
        ExecutionArguments execArgs = new ExecutionArguments(vmArgs, pgmArgs);
        Map vmAttributesMap = this.getVMSpecificAttributesMap(configuration);
        String[] classpath = this.getClasspath(configuration);
        String[] environment = this.getEnvironment(configuration);
        String mainType = this.getMainTypeName(configuration);
        VMRunnerConfiguration runConfig = new VMRunnerConfiguration(mainType, classpath);
        runConfig.setProgramArguments(execArgs.getProgramArgumentsArray());
        runConfig.setVMArguments(execArgs.getVMArgumentsArray());
        runConfig.setWorkingDirectory(workingDirName);
        runConfig.setVMSpecificAttributesMap(vmAttributesMap);
        runConfig.setEnvironment(environment);
        String[] bootpath = this.getBootpath(configuration);
        if (bootpath != null && bootpath.length > 0) {
            runConfig.setBootClassPath(bootpath);
        }
        this.setDefaultSourceLocator(launch, configuration);
        if ("profile".equals(mode)) {
            try {
                ServerProfilerDelegate.configureProfiling((ILaunch)launch, (IVMInstall)vm, (VMRunnerConfiguration)runConfig, (IProgressMonitor)monitor);
            }
            catch (CoreException ce) {
                IServer server = ServerUtil.getServer((ILaunchConfiguration)configuration);
                JBossServerBehavior jbsb = (JBossServerBehavior)((Object)server.getAdapter(JBossServerBehavior.class));
                jbsb.stop(true);
                throw ce;
            }
        }
        runner.run(runConfig, launch, monitor);
    }

    protected static JBossServer findJBossServer(String serverId) throws CoreException {
        if (serverId == null) {
            throw new CoreException((IStatus)new Status(4, "org.jboss.ide.eclipse.as.core", NLS.bind((String)Messages.ServerNotFound, (Object)serverId)));
        }
        IServer s = ServerCore.findServer((String)serverId);
        if (s == null) {
            throw new CoreException((IStatus)new Status(4, "org.jboss.ide.eclipse.as.core", NLS.bind((String)Messages.ServerNotFound, (Object)serverId)));
        }
        JBossServer jbs = ServerConverter.getJBossServer(s);
        if (jbs == null) {
            throw new CoreException((IStatus)new Status(4, "org.jboss.ide.eclipse.as.core", NLS.bind((String)Messages.ServerNotFound, (Object)serverId)));
        }
        return jbs;
    }

    protected static IJBossServerRuntime findJBossServerRuntime(IServer server) throws CoreException {
        IRuntime rt = server.getRuntime();
        IJBossServerRuntime jbrt = null;
        if (rt != null) {
            jbrt = (IJBossServerRuntime)rt.loadAdapter(IJBossServerRuntime.class, (IProgressMonitor)new NullProgressMonitor());
        }
        if (jbrt == null) {
            throw new CoreException((IStatus)new Status(4, "org.jboss.ide.eclipse.as.core", NLS.bind((String)Messages.ServerRuntimeNotFound, (Object)server.getName())));
        }
        return jbrt;
    }

    protected static void addCPEntry(ArrayList<IRuntimeClasspathEntry> list, JBossServer jbs, String relative) {
        AbstractJBossLaunchConfigType.addCPEntry(list, new Path(AbstractJBossLaunchConfigType.getServerHome(jbs)).append(relative));
    }

    protected static void addCPEntry(ArrayList<IRuntimeClasspathEntry> list, IPath path) {
        list.add(JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)path));
    }

    protected static void addJREEntry(ArrayList<IRuntimeClasspathEntry> cp, IVMInstall vmInstall) {
        if (vmInstall != null) {
            try {
                cp.add(JavaRuntime.newRuntimeContainerClasspathEntry((IPath)new Path(JavaRuntime.JRE_CONTAINER).append(vmInstall.getVMInstallType().getId()).append(vmInstall.getName()), (int)2));
            }
            catch (CoreException e) {
                Status s = new Status(4, "org.jboss.ide.eclipse.as.core", Messages.LaunchConfigJREError, (Throwable)e);
                JBossServerCorePlugin.getDefault().getLog().log((IStatus)s);
            }
        }
    }

    protected static void addToolsJar(ArrayList<IRuntimeClasspathEntry> cp, IVMInstall vmInstall) {
        File f = vmInstall.getInstallLocation();
        File c1 = new File(f, "lib");
        File c2 = new File(c1, "tools.jar");
        if (c2.exists()) {
            AbstractJBossLaunchConfigType.addCPEntry(cp, (IPath)new Path(c2.getAbsolutePath()));
        }
    }

    protected static ArrayList<String> convertClasspath(ArrayList<IRuntimeClasspathEntry> cp) {
        Iterator<IRuntimeClasspathEntry> cpi = cp.iterator();
        ArrayList<String> list = new ArrayList<String>();
        while (cpi.hasNext()) {
            IRuntimeClasspathEntry entry = cpi.next();
            try {
                list.add(entry.getMemento());
            }
            catch (Exception exception) {}
        }
        return list;
    }

    protected static void addDirectory(String serverHome, ArrayList<IRuntimeClasspathEntry> classpath, String dirName) {
        String libPath = String.valueOf(serverHome) + File.separator + dirName;
        File libDir = new File(libPath);
        File[] libs = libDir.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name != null && name.endsWith(".jar");
            }
        });
        if (libs == null) {
            return;
        }
        int i = 0;
        while (i < libs.length) {
            classpath.add(JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)new Path(String.valueOf(libPath) + File.separator + libs[i].getName())));
            ++i;
        }
    }

    public static String getServerHome(JBossServer jbs) {
        return jbs.getServer().getRuntime().getLocation().toOSString();
    }

    public IVMInstall getVMInstall(ILaunchConfiguration configuration) throws CoreException {
        String serverId = configuration.getAttribute(SERVER_ID, null);
        JBossServer jbs = AbstractJBossLaunchConfigType.findJBossServer(serverId);
        IJBossServerRuntime jbrt = AbstractJBossLaunchConfigType.findJBossServerRuntime(jbs.getServer());
        return jbrt.getVM();
    }
}

