/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.core.server.internal.launch;

import java.io.File;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.StandardClasspathProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.ServerUtil;
import org.jboss.ide.eclipse.as.core.Messages;
import org.jboss.ide.eclipse.as.core.server.IJBossServerRuntime;
import org.jboss.ide.eclipse.as.core.server.internal.JBossServer;
import org.jboss.ide.eclipse.as.core.server.internal.JBossServerBehavior;
import org.jboss.ide.eclipse.as.core.server.internal.launch.AbstractJBossLaunchConfigType;
import org.jboss.ide.eclipse.as.core.util.ArgsUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossServerStartupLaunchConfiguration
extends AbstractJBossLaunchConfigType {
    static final char[] INVALID_CHARS;
    static final String LAUNCH_TYPE = "org.jboss.ide.eclipse.as.core.server.startupConfiguration";
    static final String DEFAULTS_SET = "jboss.defaults.been.set";
    static final String START_JAR_LOC = "bin/run.jar";
    static final String START_MAIN_TYPE = "org.jboss.Main";
    private static final String DEFAULT_CP_PROVIDER_ID = "org.jboss.ide.eclipse.as.core.server.internal.launch.serverClasspathProvider";

    static {
        char[] cArray = new char[12];
        cArray[0] = 92;
        cArray[1] = 47;
        cArray[2] = 58;
        cArray[3] = 42;
        cArray[4] = 63;
        cArray[5] = 34;
        cArray[6] = 60;
        cArray[7] = 62;
        cArray[8] = 124;
        cArray[10] = 64;
        cArray[11] = 38;
        INVALID_CHARS = cArray;
    }

    public static ILaunchConfigurationWorkingCopy setupLaunchConfiguration(IServer server, String action) throws CoreException {
        ILaunchConfigurationWorkingCopy config = JBossServerStartupLaunchConfiguration.createLaunchConfiguration(server);
        JBossServerStartupLaunchConfiguration.setupLaunchConfiguration(config, server);
        return config;
    }

    public static void setupLaunchConfiguration(ILaunchConfigurationWorkingCopy workingCopy, IServer server) throws CoreException {
        JBossServer jbs;
        if (!workingCopy.getAttributes().containsKey(DEFAULTS_SET)) {
            JBossServerStartupLaunchConfiguration.forceDefaultsSet(workingCopy, server);
        }
        if ((jbs = JBossServerStartupLaunchConfiguration.findJBossServer(server.getId())) == null) {
            throw new CoreException((IStatus)new Status(4, "org.jboss.ide.eclipse.as.core", NLS.bind((String)Messages.CannotSetUpImproperServer, (Object)server.getName())));
        }
        String cpProvider = workingCopy.getAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH_PROVIDER, null);
        if (!DEFAULT_CP_PROVIDER_ID.equals(cpProvider)) {
            workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH_PROVIDER, DEFAULT_CP_PROVIDER_ID);
            workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH, JBossServerStartupLaunchConfiguration.getClasspath(jbs));
            workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, false);
        }
        JBossServerStartupLaunchConfiguration.updateMandatedFields(workingCopy, jbs);
    }

    protected static void updateMandatedFields(ILaunchConfigurationWorkingCopy wc, JBossServer jbs) throws CoreException {
        String host2;
        String serverHome = JBossServerStartupLaunchConfiguration.getServerHome(jbs);
        if (serverHome == null) {
            throw new CoreException((IStatus)new Status(4, "org.jboss.ide.eclipse.as.core", NLS.bind((String)Messages.CannotLocateServerHome, (Object)jbs.getServer().getName())));
        }
        IRuntime rt = jbs.getServer().getRuntime();
        IJBossServerRuntime jbrt = null;
        if (rt != null) {
            jbrt = (IJBossServerRuntime)rt.getAdapter(IJBossServerRuntime.class);
        }
        if (jbrt == null) {
            throw new CoreException((IStatus)new Status(4, "org.jboss.ide.eclipse.as.core", NLS.bind((String)Messages.ServerRuntimeNotFound, (Object)jbs.getServer().getName())));
        }
        String args = wc.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, "");
        String vmArgs = wc.getAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, "");
        String host = jbs.getServer().getHost();
        if (!host.equals(host2 = ArgsUtil.getValue(args, "-b", "--host"))) {
            args = ArgsUtil.setArg(args, "-b", "--host", host);
        }
        IJBossServerRuntime runtime = (IJBossServerRuntime)jbs.getServer().getRuntime().loadAdapter(IJBossServerRuntime.class, null);
        String config = runtime.getJBossConfiguration();
        args = ArgsUtil.setArg(args, "-c", "--configuration", config);
        try {
            if (!runtime.getConfigLocation().equals("server")) {
                args = ArgsUtil.setArg(args, null, "-Djboss.server.base.url", runtime.getConfigLocationFullPath().toFile().toURL().toString());
            }
        }
        catch (MalformedURLException malformedURLException) {}
        vmArgs = ArgsUtil.setArg(vmArgs, null, "-Djava.endorsed.dirs", runtime.getRuntime().getLocation().append("lib").append("endorsed").toOSString(), true);
        if (runtime.getRuntime().getLocation().append("bin").append("native").toFile().exists()) {
            String argVal = ArgsUtil.getValue(vmArgs, null, "-Djava.library.path");
            String libPath = runtime.getRuntime().getLocation().append("bin").append("native").toOSString();
            if (argVal != null) {
                if (argVal.startsWith("\"")) {
                    argVal = argVal.substring(1);
                }
                if (argVal.endsWith("\"")) {
                    argVal = argVal.substring(0, argVal.length() - 1);
                }
                if (argVal.startsWith(":")) {
                    argVal = argVal.substring(1);
                }
                String[] asArr = argVal.split(File.pathSeparator);
                asArr[0] = libPath;
                String implode = "";
                int i = 0;
                while (i < asArr.length) {
                    implode = String.valueOf(implode) + asArr[i] + File.pathSeparator;
                    ++i;
                }
                libPath = implode;
            }
            vmArgs = ArgsUtil.setArg(vmArgs, null, "-Djava.library.path", libPath, true);
        }
        List cp = wc.getAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH, new ArrayList());
        List<String> newCP = JBossServerStartupLaunchConfiguration.fixCP(cp, jbs);
        IVMInstall vmInstall = runtime.getVM();
        if (vmInstall != null) {
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_JRE_CONTAINER_PATH, JavaRuntime.newJREContainerPath((IVMInstall)vmInstall).toPortableString());
        }
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_WORKING_DIRECTORY, String.valueOf(serverHome) + '/' + "bin");
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, args.trim());
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, vmArgs.trim());
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH, newCP);
        wc.setAttribute("server-id", jbs.getServer().getId());
    }

    protected static List<String> fixCP(List<String> list, JBossServer jbs) {
        try {
            boolean found = false;
            String[] asString = list.toArray(new String[list.size()]);
            int i = 0;
            while (i < asString.length) {
                if (asString[i].contains("org.jboss.ide.eclipse.as.core.server.launch.runJarContainer")) {
                    found = true;
                    asString[i] = JBossServerStartupLaunchConfiguration.getRunJarRuntimeCPEntry(jbs).getMemento();
                }
                ++i;
            }
            ArrayList<String> result = new ArrayList<String>();
            result.addAll(Arrays.asList(asString));
            if (!found) {
                result.add(JBossServerStartupLaunchConfiguration.getRunJarRuntimeCPEntry(jbs).getMemento());
            }
            return result;
        }
        catch (CoreException coreException) {
            return list;
        }
    }

    protected static void forceDefaultsSet(ILaunchConfigurationWorkingCopy wc, IServer server) throws CoreException {
        JBossServer jbs = JBossServerStartupLaunchConfiguration.findJBossServer(server.getId());
        if (jbs == null) {
            throw new CoreException((IStatus)new Status(4, "org.jboss.ide.eclipse.as.core", NLS.bind((String)Messages.CannotSetUpImproperServer, (Object)server.getName())));
        }
        String serverHome = JBossServerStartupLaunchConfiguration.getServerHome(jbs);
        if (serverHome == null) {
            throw new CoreException((IStatus)new Status(4, "org.jboss.ide.eclipse.as.core", NLS.bind((String)Messages.CannotLocateServerHome, (Object)server.getName())));
        }
        IRuntime rt = jbs.getServer().getRuntime();
        IJBossServerRuntime jbrt = null;
        if (rt != null) {
            jbrt = (IJBossServerRuntime)rt.getAdapter(IJBossServerRuntime.class);
        }
        if (jbrt == null) {
            throw new CoreException((IStatus)new Status(4, "org.jboss.ide.eclipse.as.core", NLS.bind((String)Messages.ServerRuntimeNotFound, (Object)jbs.getServer().getName())));
        }
        IVMInstall vmInstall = jbrt.getVM();
        if (vmInstall != null) {
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_JRE_CONTAINER_PATH, JavaRuntime.newJREContainerPath((IVMInstall)vmInstall).toPortableString());
        }
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, JBossServerStartupLaunchConfiguration.getDefaultArgs(jbs));
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, jbrt.getDefaultRunVMArgs());
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, START_MAIN_TYPE);
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_WORKING_DIRECTORY, String.valueOf(serverHome) + '/' + "bin");
        wc.setAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, jbrt.getDefaultRunEnvVars());
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH, JBossServerStartupLaunchConfiguration.getClasspath(jbs));
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH_PROVIDER, DEFAULT_CP_PROVIDER_ID);
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, false);
        wc.setAttribute(DEFAULTS_SET, true);
    }

    protected static ArrayList<String> getClasspath(JBossServer jbs) throws CoreException {
        IJBossServerRuntime jbrt = JBossServerStartupLaunchConfiguration.findJBossServerRuntime(jbs.getServer());
        ArrayList<IRuntimeClasspathEntry> classpath = new ArrayList<IRuntimeClasspathEntry>();
        classpath.add(JBossServerStartupLaunchConfiguration.getRunJarRuntimeCPEntry(jbs));
        JBossServerStartupLaunchConfiguration.addJREEntry(classpath, jbrt.getVM());
        String version = jbs.getServer().getRuntime().getRuntimeType().getVersion();
        if (version.equals("org.jboss.ide.eclipse.as.runtime.40")) {
            JBossServerStartupLaunchConfiguration.addToolsJar(classpath, jbrt.getVM());
        }
        ArrayList<String> runtimeClassPaths = JBossServerStartupLaunchConfiguration.convertClasspath(classpath);
        return runtimeClassPaths;
    }

    protected static IRuntimeClasspathEntry getRunJarRuntimeCPEntry(JBossServer jbs) throws CoreException {
        IPath containerPath = new Path("org.jboss.ide.eclipse.as.core.server.launch.runJarContainer").append(jbs.getServer().getName());
        return JavaRuntime.newRuntimeContainerClasspathEntry((IPath)containerPath, (int)3);
    }

    protected static String getDefaultArgs(JBossServer jbs) throws CoreException {
        IJBossServerRuntime rt = JBossServerStartupLaunchConfiguration.findJBossServerRuntime(jbs.getServer());
        if (rt != null) {
            return String.valueOf(rt.getDefaultRunArgs()) + " " + "-b" + " " + jbs.getServer().getHost();
        }
        return null;
    }

    @Override
    public boolean preLaunchCheck(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        JBossServerBehavior jbsBehavior = JBossServerStartupLaunchConfiguration.getServerBehavior(configuration);
        if (!jbsBehavior.canStart(mode).isOK()) {
            throw new CoreException(jbsBehavior.canStart(mode));
        }
        return true;
    }

    @Override
    protected void preLaunch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        try {
            JBossServerBehavior jbsBehavior = JBossServerStartupLaunchConfiguration.getServerBehavior(configuration);
            jbsBehavior.setRunMode(mode);
            jbsBehavior.serverStarting();
        }
        catch (CoreException coreException) {}
    }

    @Override
    public void postLaunch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        try {
            IProcess[] processes = launch.getProcesses();
            JBossServerBehavior jbsBehavior = JBossServerStartupLaunchConfiguration.getServerBehavior(configuration);
            jbsBehavior.setProcess(processes[0]);
        }
        catch (CoreException coreException) {}
    }

    public static JBossServerBehavior getServerBehavior(ILaunchConfiguration configuration) throws CoreException {
        IServer server = ServerUtil.getServer((ILaunchConfiguration)configuration);
        JBossServerBehavior jbossServerBehavior = (JBossServerBehavior)((Object)server.getAdapter(JBossServerBehavior.class));
        return jbossServerBehavior;
    }

    protected static String getValidLaunchConfigurationName(String s) {
        if (s == null || s.length() == 0) {
            return "1";
        }
        int size = INVALID_CHARS.length;
        int i = 0;
        while (i < size) {
            s = s.replace(INVALID_CHARS[i], '_');
            ++i;
        }
        return s;
    }

    public static ILaunchConfigurationWorkingCopy createLaunchConfiguration(IServer server) throws CoreException {
        ILaunchConfigurationType launchConfigType = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType(LAUNCH_TYPE);
        if (launchConfigType == null) {
            return null;
        }
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfiguration[] launchConfigs = null;
        try {
            launchConfigs = launchManager.getLaunchConfigurations(launchConfigType);
        }
        catch (CoreException coreException) {}
        if (launchConfigs != null) {
            int size = launchConfigs.length;
            int i = 0;
            while (i < size) {
                try {
                    String serverId = launchConfigs[i].getAttribute("server-id", null);
                    if (server.getId().equals(serverId)) {
                        ILaunchConfigurationWorkingCopy wc = launchConfigs[i].getWorkingCopy();
                        return wc;
                    }
                }
                catch (CoreException coreException) {}
                ++i;
            }
        }
        String launchName = JBossServerStartupLaunchConfiguration.getValidLaunchConfigurationName(server.getName());
        launchName = launchManager.generateUniqueLaunchConfigurationNameFrom(launchName);
        ILaunchConfigurationWorkingCopy wc = launchConfigType.newInstance(null, launchName);
        wc.setAttribute("server-id", server.getId());
        return wc;
    }

    public static class JBossServerDefaultClasspathProvider
    extends StandardClasspathProvider {
        public IRuntimeClasspathEntry[] computeUnresolvedClasspath(ILaunchConfiguration configuration) throws CoreException {
            boolean useDefault = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, true);
            if (useDefault) {
                return this.defaultEntries(configuration);
            }
            return super.computeUnresolvedClasspath(configuration);
        }

        protected IRuntimeClasspathEntry[] defaultEntries(ILaunchConfiguration config) {
            try {
                String server = config.getAttribute("server-id", null);
                IServer s = ServerCore.findServer((String)server);
                IJBossServerRuntime ibjsrt = (IJBossServerRuntime)s.getRuntime().loadAdapter(IJBossServerRuntime.class, (IProgressMonitor)new NullProgressMonitor());
                JBossServer jbs = (JBossServer)s.loadAdapter(JBossServer.class, (IProgressMonitor)new NullProgressMonitor());
                IVMInstall install = ibjsrt.getVM();
                ArrayList<IRuntimeClasspathEntry> list = new ArrayList<IRuntimeClasspathEntry>();
                JBossServerStartupLaunchConfiguration.addJREEntry(list, install);
                list.add(JBossServerStartupLaunchConfiguration.getRunJarRuntimeCPEntry(jbs));
                return list.toArray(new IRuntimeClasspathEntry[list.size()]);
            }
            catch (CoreException coreException) {
                try {
                    return super.computeUnresolvedClasspath(config);
                }
                catch (CoreException coreException2) {
                    return new IRuntimeClasspathEntry[0];
                }
            }
        }
    }
}

