/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.core.server.internal.launch;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.wst.server.core.IServer;
import org.jboss.ide.eclipse.as.core.JBossServerCorePlugin;
import org.jboss.ide.eclipse.as.core.Messages;
import org.jboss.ide.eclipse.as.core.server.IJBossServerRuntime;
import org.jboss.ide.eclipse.as.core.server.internal.JBossServer;
import org.jboss.ide.eclipse.as.core.server.internal.launch.AbstractJBossLaunchConfigType;
import org.jboss.ide.eclipse.as.core.util.IJBossRuntimeConstants;

public class StopLaunchConfiguration
extends AbstractJBossLaunchConfigType {
    public static final String STOP_LAUNCH_TYPE = "org.jboss.ide.eclipse.as.core.server.stopLaunchConfiguration";
    public static final String STOP_MAIN_TYPE = "org.jboss.Shutdown";
    public static final String STOP_JAR_LOC = "bin" + File.separator + "shutdown.jar";

    public static boolean stop(IServer server) {
        try {
            ILaunchConfigurationWorkingCopy wc = StopLaunchConfiguration.createLaunchConfiguration(server);
            ILaunch launch = wc.launch("run", (IProgressMonitor)new NullProgressMonitor());
            IProcess stopProcess = launch.getProcesses()[0];
            while (!stopProcess.isTerminated()) {
                try {
                    Thread.yield();
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
            return stopProcess.getExitValue() == 0;
        }
        catch (CoreException ce) {
            Status s = new Status(4, "org.jboss.ide.eclipse.as.core", Messages.UnexpectedServerStopError, (Throwable)ce);
            JBossServerCorePlugin.getDefault().getLog().log((IStatus)s);
            return false;
        }
    }

    protected void preLaunch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) {
    }

    public static ILaunchConfigurationWorkingCopy createLaunchConfiguration(IServer server) throws CoreException {
        JBossServer jbs = StopLaunchConfiguration.findJBossServer(server.getId());
        IJBossServerRuntime jbrt = StopLaunchConfiguration.findJBossServerRuntime(server);
        String serverHome = StopLaunchConfiguration.getServerHome(jbs);
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType launchConfigType = launchManager.getLaunchConfigurationType(STOP_LAUNCH_TYPE);
        String launchName = StopLaunchConfiguration.class.getName();
        launchName = launchManager.generateUniqueLaunchConfigurationNameFrom(launchName);
        ILaunchConfigurationWorkingCopy wc = launchConfigType.newInstance(null, launchName);
        wc.setAttribute("server-id", server.getId());
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, StopLaunchConfiguration.getDefaultArgs(jbs));
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, STOP_MAIN_TYPE);
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_WORKING_DIRECTORY, String.valueOf(serverHome) + '/' + "bin");
        ArrayList<IRuntimeClasspathEntry> classpath = new ArrayList<IRuntimeClasspathEntry>();
        StopLaunchConfiguration.addCPEntry(classpath, jbs, STOP_JAR_LOC);
        StopLaunchConfiguration.addJREEntry(classpath, jbrt.getVM());
        ArrayList<String> runtimeClassPaths = StopLaunchConfiguration.convertClasspath(classpath);
        String cpKey = IJavaLaunchConfigurationConstants.ATTR_CLASSPATH;
        wc.setAttribute(cpKey, runtimeClassPaths);
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, false);
        return wc;
    }

    public static String getDefaultArgs(JBossServer jbs) throws CoreException {
        IJBossRuntimeConstants c = new IJBossRuntimeConstants(){};
        String args = String.valueOf("-S") + " ";
        args = String.valueOf(args) + "-s" + " " + jbs.getHost() + ":" + jbs.getJNDIPort() + " ";
        if (jbs.getUsername() != null && !jbs.getUsername().equals("")) {
            args = String.valueOf(args) + "-u" + " " + jbs.getUsername() + " ";
        }
        if (jbs.getPassword() != null && !jbs.getUsername().equals("")) {
            args = String.valueOf(args) + "-p" + " " + jbs.getPassword() + " ";
        }
        return args;
    }
}

