/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.core.server.internal.launch;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.wst.server.core.IServer;
import org.jboss.ide.eclipse.as.core.server.IJBossServerRuntime;
import org.jboss.ide.eclipse.as.core.server.internal.JBossServer;
import org.jboss.ide.eclipse.as.core.server.internal.launch.AbstractJBossLaunchConfigType;
import org.jboss.ide.eclipse.as.core.util.IJBossRuntimeConstants;

public class TwiddleLaunchConfiguration
extends AbstractJBossLaunchConfigType {
    public static final String TWIDDLE_LAUNCH_TYPE = "org.jboss.ide.eclipse.as.core.server.twiddleConfiguration";
    protected static final String TWIDDLE_MAIN_TYPE = "org.jboss.console.twiddle.Twiddle";
    protected static final String TWIDDLE_JAR_LOC = "bin" + File.separator + "twiddle.jar";

    public static ILaunchConfigurationWorkingCopy createLaunchConfiguration(IServer server) throws CoreException {
        return TwiddleLaunchConfiguration.createLaunchConfiguration(server, TwiddleLaunchConfiguration.getDefaultArgs(server));
    }

    public static ILaunchConfigurationWorkingCopy createLaunchConfiguration(IServer server, String args) throws CoreException {
        JBossServer jbs = TwiddleLaunchConfiguration.findJBossServer(server.getId());
        IJBossServerRuntime jbrt = TwiddleLaunchConfiguration.findJBossServerRuntime(server);
        String serverHome = TwiddleLaunchConfiguration.getServerHome(jbs);
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType launchConfigType = launchManager.getLaunchConfigurationType(TWIDDLE_LAUNCH_TYPE);
        String launchName = TwiddleLaunchConfiguration.class.getName();
        launchName = launchManager.generateUniqueLaunchConfigurationNameFrom(launchName);
        ILaunchConfigurationWorkingCopy wc = launchConfigType.newInstance(null, launchName);
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, args);
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, TWIDDLE_MAIN_TYPE);
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_WORKING_DIRECTORY, String.valueOf(serverHome) + '/' + "bin");
        wc.setAttribute("server-id", server.getId());
        ArrayList<IRuntimeClasspathEntry> classpath = new ArrayList<IRuntimeClasspathEntry>();
        TwiddleLaunchConfiguration.addCPEntry(classpath, jbs, TWIDDLE_JAR_LOC);
        TwiddleLaunchConfiguration.addDirectory(serverHome, classpath, "lib");
        TwiddleLaunchConfiguration.addDirectory(serverHome, classpath, "lib" + File.separator + "endorsed");
        TwiddleLaunchConfiguration.addDirectory(serverHome, classpath, "client");
        TwiddleLaunchConfiguration.addJREEntry(classpath, jbrt.getVM());
        ArrayList<String> runtimeClassPaths = TwiddleLaunchConfiguration.convertClasspath(classpath);
        String cpKey = IJavaLaunchConfigurationConstants.ATTR_CLASSPATH;
        wc.setAttribute(cpKey, runtimeClassPaths);
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, false);
        return wc;
    }

    public static String getDefaultArgs(IServer server) throws CoreException {
        IJBossRuntimeConstants c = new IJBossRuntimeConstants(){};
        JBossServer jbs = TwiddleLaunchConfiguration.findJBossServer(server.getId());
        String twiddleArgs = String.valueOf("-s") + " " + jbs.getHost() + ":" + jbs.getJNDIPort() + " " + "-a" + " " + "jmx/invoker/RMIAdaptor" + " ";
        if (jbs.getUsername() != null) {
            twiddleArgs = String.valueOf(twiddleArgs) + "-u" + " " + jbs.getUsername() + " ";
        }
        if (jbs.getPassword() != null) {
            twiddleArgs = String.valueOf(twiddleArgs) + "-p" + " " + jbs.getPassword() + " ";
        }
        return twiddleArgs;
    }
}

