/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.core.server.internal.launch;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.wst.server.core.IServer;
import org.jboss.ide.eclipse.as.core.JBossServerCorePlugin;
import org.jboss.ide.eclipse.as.core.Messages;
import org.jboss.ide.eclipse.as.core.server.internal.launch.TwiddleLaunchConfiguration;

public class TwiddleLauncher {
    private boolean canceled = false;
    private int delay = 500;

    public static ProcessData[] launchTwiddles(String[] twiddleArgs, IServer server, boolean addPrefix) throws CoreException {
        ArrayList<ProcessData> list = new ArrayList<ProcessData>();
        int i = 0;
        while (i < twiddleArgs.length) {
            String args2 = addPrefix ? String.valueOf(TwiddleLaunchConfiguration.getDefaultArgs(server)) + twiddleArgs[i] : twiddleArgs[i];
            ILaunchConfigurationWorkingCopy wc = TwiddleLaunchConfiguration.createLaunchConfiguration(server, args2);
            ILaunch launch = wc.launch("run", (IProgressMonitor)new NullProgressMonitor(), false, false);
            list.addAll(Arrays.asList(TwiddleLauncher.toProcessDatas(launch.getProcesses())));
            ++i;
        }
        ProcessData[] ret = new ProcessData[list.size()];
        list.toArray(ret);
        return ret;
    }

    protected static ProcessData[] toProcessDatas(IProcess[] processes) {
        ProcessData[] datas = new ProcessData[processes.length];
        int i = 0;
        while (i < processes.length) {
            datas[i] = new ProcessData(processes[i], "");
            datas[i].startListening();
            ++i;
        }
        return datas;
    }

    public void setCanceled() {
        this.canceled = true;
    }

    public ProcessData[] getTwiddleResults(IServer server, String args, boolean addPrefix) {
        ProcessData[] processes;
        try {
            processes = TwiddleLauncher.launchTwiddles(new String[]{args}, server, addPrefix);
        }
        catch (CoreException coreException) {
            return new ProcessData[0];
        }
        this.waitForThreadsToTerminate(processes);
        int i = 0;
        while (i < processes.length) {
            processes[i].stopListening();
            ++i;
        }
        return processes;
    }

    protected void waitForThreadsToTerminate(ProcessData[] processes) {
        boolean allTerminated = false;
        while (!allTerminated && !this.canceled) {
            allTerminated = true;
            int i = 0;
            while (i < processes.length) {
                if (!processes[i].getProcess().isTerminated()) {
                    allTerminated = false;
                }
                ++i;
            }
            if (allTerminated) continue;
            if (this.canceled) {
                try {
                    i = 0;
                    while (i < processes.length) {
                        processes[i].getProcess().terminate();
                        ++i;
                    }
                }
                catch (DebugException e) {
                    Status s = new Status(4, "org.jboss.ide.eclipse.as.core", Messages.TerminateTwiddleFailed, (Throwable)e);
                    JBossServerCorePlugin.getDefault().getLog().log((IStatus)s);
                }
            }
            try {
                Thread.sleep(this.delay);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public static class ProcessData
    implements IStreamListener {
        private String args;
        private String processType;
        private IProcess process;
        private IStreamMonitor outMonitor;
        private IStreamMonitor errMonitor;
        private String out;
        private String err;

        public ProcessData(IProcess process, String processType) {
            this(null, process, processType);
            try {
                this.args = process.getLaunch().getLaunchConfiguration().getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, null);
            }
            catch (CoreException coreException) {}
        }

        public ProcessData(String args, IProcess process, String processType) {
            this.args = args;
            this.process = process;
            this.processType = processType;
            this.outMonitor = process.getStreamsProxy().getOutputStreamMonitor();
            this.errMonitor = process.getStreamsProxy().getErrorStreamMonitor();
            this.out = "";
            this.err = "";
        }

        public void startListening() {
            this.outMonitor.addListener((IStreamListener)this);
            this.errMonitor.addListener((IStreamListener)this);
        }

        public void stopListening() {
            this.outMonitor.removeListener((IStreamListener)this);
            this.errMonitor.removeListener((IStreamListener)this);
        }

        public void resetStrings() {
            this.out = "";
            this.err = "";
        }

        public void destroy() {
            this.stopListening();
            this.resetStrings();
        }

        public void streamAppended(String text, IStreamMonitor monitor) {
            if (monitor == this.outMonitor) {
                this.out = String.valueOf(this.out) + text;
            } else if (monitor == this.errMonitor) {
                this.err = String.valueOf(this.err) + text;
            }
        }

        public String getArgs() {
            return this.args;
        }

        public String getErr() {
            return this.err;
        }

        public String getOut() {
            return this.out;
        }

        public String getProcesType() {
            return this.processType;
        }

        public IProcess getProcess() {
            return this.process;
        }
    }
}

