/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.core.server.xpl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.internal.Messages;
import org.eclipse.wst.server.core.internal.ProgressUtil;
import org.eclipse.wst.server.core.internal.ServerPlugin;
import org.eclipse.wst.server.core.model.IModuleFile;
import org.eclipse.wst.server.core.model.IModuleFolder;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.eclipse.wst.server.core.model.IModuleResourceDelta;
import org.jboss.ide.eclipse.as.core.publishers.PublishUtil;
import org.jboss.ide.eclipse.as.core.util.ServerConverter;

public final class PublishCopyUtil {
    private static final IStatus[] EMPTY_STATUS = new IStatus[0];
    private IPublishCopyCallbackHandler handler;

    public PublishCopyUtil(IPublishCopyCallbackHandler handler) {
        this.handler = handler;
    }

    public IStatus[] publishDelta(IModuleResourceDelta[] delta, IProgressMonitor monitor) throws CoreException {
        if (delta == null) {
            return EMPTY_STATUS;
        }
        monitor = ProgressUtil.getMonitorFor((IProgressMonitor)monitor);
        ArrayList status = new ArrayList(2);
        int size2 = delta.length;
        int i = 0;
        while (i < size2) {
            IStatus[] stat = this.publishDelta(delta[i], (IPath)new Path("/"), monitor);
            PublishCopyUtil.addArrayToList(status, stat);
            ++i;
        }
        IStatus[] stat = new IStatus[status.size()];
        status.toArray(stat);
        return stat;
    }

    public IStatus[] publishDelta(IModuleResourceDelta delta, IPath path, IProgressMonitor monitor) throws CoreException {
        IPath path2;
        IStatus[] stat;
        IPath path22;
        IStatus[] s;
        ArrayList<Object> status = new ArrayList<Object>(2);
        IModuleResource resource = delta.getModuleResource();
        int kind2 = delta.getKind();
        if (resource instanceof IModuleFile) {
            IModuleFile file = (IModuleFile)resource;
            try {
                IPath path23;
                if (kind2 == 3) {
                    path23 = path.append(file.getModuleRelativePath()).append(file.getName());
                    this.handler.deleteResource(path23, monitor);
                } else {
                    path23 = path.append(file.getModuleRelativePath()).append(file.getName());
                    this.handler.makeDirectoryIfRequired(path23.removeLastSegments(1), monitor);
                    this.handler.copyFile(file, path23, monitor);
                }
            }
            catch (CoreException ce) {
                status.add(ce.getStatus());
            }
            IStatus[] stat2 = new IStatus[status.size()];
            status.toArray(stat2);
            return stat2;
        }
        if (kind2 == 1 && (s = this.handler.makeDirectoryIfRequired(path22 = path.append(resource.getModuleRelativePath()).append(resource.getName()), monitor)).length > 0 && !s[0].isOK()) {
            return s;
        }
        IModuleResourceDelta[] childDeltas = delta.getAffectedChildren();
        int size = childDeltas.length;
        int i = 0;
        while (i < size) {
            stat = this.publishDelta(childDeltas[i], path, monitor);
            PublishCopyUtil.addArrayToList(status, stat);
            ++i;
        }
        if (kind2 == 3 && (stat = this.handler.deleteResource(path2 = path.append(resource.getModuleRelativePath()).append(resource.getName()), monitor)).length > 0 && !stat[0].isOK()) {
            status.add(new Status(4, "org.eclipse.wst.server.core", 0, NLS.bind((String)Messages.errorDeleting, (Object)path2), null));
        }
        IStatus[] stat3 = new IStatus[status.size()];
        status.toArray(stat3);
        return stat3;
    }

    public IStatus[] publishFull(IModuleResource[] resources, IProgressMonitor monitor) throws CoreException {
        this.handler.makeDirectoryIfRequired((IPath)new Path("/"), monitor);
        return this.publishFull(resources, (IPath)new Path("/"), monitor);
    }

    public IStatus[] publishFull(IModuleResource[] resources, IPath relative, IProgressMonitor monitor) throws CoreException {
        if (resources == null) {
            return EMPTY_STATUS;
        }
        monitor = ProgressUtil.getMonitorFor((IProgressMonitor)monitor);
        ArrayList status = new ArrayList(2);
        int size = resources.length;
        int i = 0;
        while (i < size) {
            IStatus[] stat = this.copy(resources[i], relative, monitor);
            PublishCopyUtil.addArrayToList(status, stat);
            ++i;
        }
        IStatus[] stat = new IStatus[status.size()];
        status.toArray(stat);
        return stat;
    }

    private IStatus[] copy(IModuleResource resource, IPath path, IProgressMonitor monitor) throws CoreException {
        String name = resource.getName();
        ArrayList<IStatus> status = new ArrayList<IStatus>(2);
        if (resource instanceof IModuleFolder) {
            IModuleFolder folder = (IModuleFolder)resource;
            IStatus[] stat = this.publishFull(folder.members(), path, monitor);
            PublishCopyUtil.addArrayToList(status, stat);
        } else {
            IModuleFile mf = (IModuleFile)resource;
            IStatus[] stats = this.handler.makeDirectoryIfRequired((path = path.append(mf.getModuleRelativePath()).append(name)).removeLastSegments(1), monitor);
            if (stats.length > 0 && !stats[0].isOK()) {
                PublishCopyUtil.addArrayToList(status, stats);
            }
            try {
                PublishCopyUtil.addArrayToList(status, this.handler.copyFile(mf, path, monitor));
            }
            catch (CoreException ce) {
                status.add(ce.getStatus());
            }
        }
        IStatus[] stat = new IStatus[status.size()];
        status.toArray(stat);
        return stat;
    }

    public static void addArrayToList(List list, IStatus[] a) {
        if (list == null || a == null || a.length == 0) {
            return;
        }
        int size = a.length;
        int i = 0;
        while (i < size) {
            list.add(a[i]);
            ++i;
        }
    }

    public static interface IPublishCopyCallbackHandler {
        public IStatus[] copyFile(IModuleFile var1, IPath var2, IProgressMonitor var3) throws CoreException;

        public IStatus[] deleteResource(IPath var1, IProgressMonitor var2) throws CoreException;

        public IStatus[] makeDirectoryIfRequired(IPath var1, IProgressMonitor var2) throws CoreException;
    }

    public static class LocalCopyCallback
    implements IPublishCopyCallbackHandler {
        private static final int BUFFER = 65536;
        private static byte[] buf = new byte[65536];
        private static final File tempDir = ServerPlugin.getInstance().getStateLocation().toFile();
        private static final String TEMPFILE_PREFIX = "tmp";
        private IServer server;
        private IPath deployRootFolder;
        private IPath tmpDeployRootFolder;

        public LocalCopyCallback(IServer server, IPath deployFolder, IPath temporaryFolder) {
            this.server = server;
            this.deployRootFolder = deployFolder;
            this.tmpDeployRootFolder = temporaryFolder;
        }

        public IStatus[] copyFile(IModuleFile mf, IPath relativePath, IProgressMonitor monitor) throws CoreException {
            File file = PublishUtil.getFile(mf);
            if (file != null) {
                FileInputStream in = null;
                try {
                    in = new FileInputStream(file);
                }
                catch (IOException e) {
                    return new IStatus[]{new Status(4, "org.eclipse.wst.server.core", 0, NLS.bind((String)Messages.errorReading, (Object)file.getAbsolutePath()), (Throwable)e)};
                }
                IStatus ret = this.copyFile(in, this.deployRootFolder.append(relativePath), file.lastModified(), mf);
                if (ret != null && ret.isOK()) {
                    return new IStatus[]{ret};
                }
            }
            return new IStatus[0];
        }

        /*
         * Loose catch block
         */
        private IStatus copyFile(InputStream in, String to) {
            FileOutputStream out = null;
            out = new FileOutputStream(to);
            int avail = in.read(buf);
            while (avail > 0) {
                ((OutputStream)out).write(buf, 0, avail);
                avail = in.read(buf);
            }
            IStatus iStatus = Status.OK_STATUS;
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (out != null) {
                    ((OutputStream)out).close();
                }
            }
            catch (Exception exception) {}
            return iStatus;
            catch (Exception e) {
                Status status;
                try {
                    status = new Status(4, "org.eclipse.wst.server.core", 0, NLS.bind((String)Messages.errorCopyingFile, (Object[])new String[]{to, e.getLocalizedMessage()}), (Throwable)e);
                }
                catch (Throwable throwable) {
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (Exception exception) {}
                    try {
                        if (out != null) {
                            ((OutputStream)out).close();
                        }
                    }
                    catch (Exception exception) {}
                    throw throwable;
                }
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (out != null) {
                        ((OutputStream)out).close();
                    }
                }
                catch (Exception exception) {}
                return status;
            }
        }

        private IStatus copyFile(InputStream in, IPath to, long ts, IModuleFile mf) throws CoreException {
            OutputStream out;
            block35: {
                out = null;
                File tempFile = null;
                try {
                    File file = to.toFile();
                    tempFile = File.createTempFile(TEMPFILE_PREFIX, "." + to.getFileExtension(), this.getTempFolder());
                    out = new FileOutputStream(tempFile);
                    int avail = in.read(buf);
                    while (avail > 0) {
                        out.write(buf, 0, avail);
                        avail = in.read(buf);
                    }
                    out.close();
                    out = null;
                    this.moveTempFile(tempFile, file);
                    if (ts != -1L && ts != 0L) {
                        file.setLastModified(ts);
                    }
                }
                catch (CoreException e) {
                    IStatus iStatus = e.getStatus();
                    if (tempFile != null && tempFile.exists()) {
                        tempFile.deleteOnExit();
                    }
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (Exception exception) {}
                    try {
                        if (out != null) {
                            out.close();
                        }
                    }
                    catch (Exception exception) {}
                    return iStatus;
                }
                catch (Exception e) {
                    Status status;
                    block34: {
                        try {
                            IPath path = mf.getModuleRelativePath().append(mf.getName());
                            status = new Status(4, "org.eclipse.wst.server.core", 0, NLS.bind((String)Messages.errorCopyingFile, (Object)path.toOSString(), (Object)e.getLocalizedMessage()), null);
                            if (tempFile == null || !tempFile.exists()) break block34;
                            tempFile.deleteOnExit();
                        }
                        catch (Throwable throwable) {
                            if (tempFile != null && tempFile.exists()) {
                                tempFile.deleteOnExit();
                            }
                            try {
                                if (in != null) {
                                    in.close();
                                }
                            }
                            catch (Exception exception) {}
                            try {
                                if (out != null) {
                                    out.close();
                                }
                            }
                            catch (Exception exception) {}
                            throw throwable;
                        }
                    }
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (Exception exception) {}
                    try {
                        if (out != null) {
                            out.close();
                        }
                    }
                    catch (Exception exception) {}
                    return status;
                }
                if (tempFile == null || !tempFile.exists()) break block35;
                tempFile.deleteOnExit();
            }
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception exception) {}
            return null;
        }

        private void moveTempFile(File tempFile, File file) throws CoreException {
            if (file.exists() && !this.safeDelete(file, 2)) {
                try {
                    FileInputStream in = new FileInputStream(tempFile);
                    IStatus status = this.copyFile(in, file.getPath());
                    if (!status.isOK()) {
                        MultiStatus status2 = new MultiStatus("org.eclipse.wst.server.core", 0, NLS.bind((String)Messages.errorDeleting, (Object)file.toString()), null);
                        status2.add(status);
                        throw new CoreException((IStatus)status2);
                    }
                    return;
                }
                catch (FileNotFoundException fileNotFoundException) {
                }
                finally {
                    tempFile.delete();
                }
            }
            if (!this.safeRename(tempFile, file, 10)) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.server.core", 0, NLS.bind((String)Messages.errorRename, (Object)tempFile.toString()), null));
            }
        }

        private boolean safeRename(File from, File to, int retrys) {
            File dir = to.getParentFile();
            if (dir != null && !dir.exists()) {
                dir.mkdirs();
            }
            int count = 0;
            while (count < retrys) {
                if (from.renameTo(to)) {
                    return true;
                }
                if (++count >= retrys) continue;
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {}
            }
            return false;
        }

        protected File getTempFolder() {
            File f = null;
            if (this.tmpDeployRootFolder != null) {
                f = this.tmpDeployRootFolder.toFile();
            } else if (this.server != null) {
                String path = ServerConverter.getDeployableServer(this.server).getTempDeployFolder();
                f = new File(path);
            } else {
                return tempDir;
            }
            if (!f.exists()) {
                f.mkdirs();
            }
            return f;
        }

        public IStatus[] deleteResource(IPath resource, IProgressMonitor monitor) {
            if ((resource = this.deployRootFolder.append(resource)).toFile().isDirectory()) {
                return this.deleteDirectory(resource.toFile(), monitor);
            }
            if (!resource.toFile().delete()) {
                Status s = new Status(4, "org.eclipse.wst.server.core", 0, NLS.bind((String)Messages.errorDeleting, (Object)resource.toFile().getAbsolutePath()), null);
                return new IStatus[]{s};
            }
            return new IStatus[0];
        }

        private IStatus[] deleteDirectory(File dir, IProgressMonitor monitor) {
            if (!dir.exists() || !dir.isDirectory()) {
                return new IStatus[]{new Status(4, "org.eclipse.wst.server.core", 0, NLS.bind((String)Messages.errorNotADirectory, (Object)dir.getAbsolutePath()), null)};
            }
            ArrayList<Status> status = new ArrayList<Status>(2);
            try {
                File[] files = dir.listFiles();
                int size = files.length;
                monitor = ProgressUtil.getMonitorFor((IProgressMonitor)monitor);
                monitor.beginTask(NLS.bind((String)Messages.deletingTask, (Object[])new String[]{dir.getAbsolutePath()}), size * 10);
                boolean deleteCurrent = true;
                int i = 0;
                while (i < size) {
                    File current = files[i];
                    if (current.isFile()) {
                        if (!current.delete()) {
                            status.add(new Status(4, "org.eclipse.wst.server.core", 0, NLS.bind((String)Messages.errorDeleting, (Object)files[i].getAbsolutePath()), null));
                            deleteCurrent = false;
                        }
                        monitor.worked(10);
                    } else if (current.isDirectory()) {
                        monitor.subTask(NLS.bind((String)Messages.deletingTask, (Object[])new String[]{current.getAbsolutePath()}));
                        IStatus[] stat = this.deleteDirectory(current, ProgressUtil.getSubMonitorFor((IProgressMonitor)monitor, (int)10));
                        if (stat != null && stat.length > 0) {
                            deleteCurrent = false;
                            PublishCopyUtil.addArrayToList(status, stat);
                        }
                    }
                    ++i;
                }
                if (deleteCurrent && !dir.delete()) {
                    status.add(new Status(4, "org.eclipse.wst.server.core", 0, NLS.bind((String)Messages.errorDeleting, (Object)dir.getAbsolutePath()), null));
                }
                monitor.done();
            }
            catch (Exception e) {
                status.add(new Status(4, "org.eclipse.wst.server.core", 0, e.getLocalizedMessage(), null));
            }
            IStatus[] stat = new IStatus[status.size()];
            status.toArray(stat);
            return stat;
        }

        private boolean safeDelete(File f, int retrys) {
            int count = 0;
            while (count < retrys) {
                if (!f.exists()) {
                    return true;
                }
                f.delete();
                if (!f.exists()) {
                    return true;
                }
                if (++count >= retrys) continue;
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {}
            }
            return false;
        }

        public IStatus[] makeDirectoryIfRequired(IPath relativeDir, IProgressMonitor monitor) {
            this.deployRootFolder.append(relativeDir).toFile().mkdirs();
            return new IStatus[]{Status.OK_STATUS};
        }
    }
}

