/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.core.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArgsUtil {
    public static final Integer NO_VALUE = new Integer(-1);
    public static final String EQ = "=";
    public static final String SPACE = " ";
    public static final String VMO = "-D";
    public static final String EMPTY = "";
    public static final String QUOTE = "\"";

    public static Map<String, Object> getSystemProperties(String argString) {
        String[] args = ArgsUtil.parse(argString);
        HashMap<String, Object> map = new HashMap<String, Object>();
        int i = 0;
        while (i < args.length) {
            if (args[i].startsWith(VMO)) {
                int eq = args[i].indexOf(EQ);
                if (eq != -1) {
                    map.put(args[i].substring(2, eq), args[i].substring(eq + 1));
                } else {
                    map.put(args[i], NO_VALUE);
                }
            }
            ++i;
        }
        return map;
    }

    public static String getValue(String allArgs, String shortOpt, String longOpt) {
        return ArgsUtil.getValue(ArgsUtil.parse(allArgs), shortOpt, longOpt);
    }

    public static String getValue(String[] args, String shortOpt, String longOpt) {
        int i = 0;
        while (i < args.length) {
            if (args[i].equals(shortOpt) && i + 1 < args.length) {
                return args[i + 1];
            }
            if (longOpt != null && args[i].startsWith(String.valueOf(longOpt) + EQ)) {
                return args[i].substring(args[i].indexOf(EQ) + 1);
            }
            ++i;
        }
        return null;
    }

    public static String[] parse(String s) {
        try {
            ArrayList<String> l = new ArrayList<String>();
            int length = s.length();
            int current = 0;
            boolean inQuotes = false;
            boolean done = false;
            String tmp = EMPTY;
            StringBuffer buf = new StringBuffer();
            while (!done) {
                switch (s.charAt(current)) {
                    case '\"': {
                        inQuotes = !inQuotes;
                        buf.append(s.charAt(current));
                        break;
                    }
                    case '\n': 
                    case ' ': {
                        if (!inQuotes) {
                            tmp = buf.toString();
                            l.add(tmp);
                            buf = new StringBuffer();
                            break;
                        }
                        buf.append(' ');
                        break;
                    }
                    default: {
                        buf.append(s.charAt(current));
                    }
                }
                if (++current != length) continue;
                done = true;
            }
            l.add(buf.toString());
            Object[] lArr = l.toArray();
            String[] retVal = new String[lArr.length];
            int i = 0;
            while (i < lArr.length) {
                retVal[i] = (String)lArr[i];
                ++i;
            }
            return retVal;
        }
        catch (Exception exception) {
            return new String[0];
        }
    }

    public static String setArg(String allArgs, String shortOpt, String longOpt, String value) {
        if (value.contains(SPACE)) {
            value = QUOTE + value + QUOTE;
        }
        return ArgsUtil.setArg(allArgs, shortOpt, longOpt, value, false);
    }

    public static String setArg(String allArgs, String shortOpt, String longOpt, String value, boolean addQuotes) {
        if (addQuotes) {
            value = QUOTE + value + QUOTE;
        }
        boolean found = false;
        String[] args = ArgsUtil.parse(allArgs);
        String retVal = EMPTY;
        int i = 0;
        while (i < args.length) {
            if (args[i].equals(shortOpt)) {
                args[i + 1] = value;
                retVal = String.valueOf(retVal) + args[i] + SPACE + args[++i] + SPACE;
                found = true;
            } else if (longOpt != null && args[i].startsWith(String.valueOf(longOpt) + EQ)) {
                args[i] = String.valueOf(longOpt) + EQ + value;
                retVal = String.valueOf(retVal) + args[i] + SPACE;
                found = true;
            } else {
                retVal = String.valueOf(retVal) + args[i] + SPACE;
            }
            ++i;
        }
        if (!found) {
            retVal = String.valueOf(retVal) + longOpt + EQ + value;
        }
        return retVal;
    }
}

