/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.core.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.internal.Server;
import org.jboss.ide.eclipse.as.core.util.ServerUtil;
import org.jboss.tools.jmx.core.IMemento;
import org.jboss.tools.jmx.core.util.XMLMemento;

public class DeploymentPreferenceLoader {
    public static final String DEPLOYMENT_PREFERENCES_KEY = "org.jboss.ide.eclipse.as.core.util.deploymentPreferenceKey";

    public static DeploymentPreferences loadPreferencesFromFile(IServer server) {
        File f = DeploymentPreferenceLoader.getFile(server);
        FileInputStream is = null;
        try {
            if (f.exists()) {
                is = new FileInputStream(f);
            }
        }
        catch (IOException iOException) {}
        return new DeploymentPreferences(is);
    }

    public static DeploymentPreferences loadPreferencesFromServer(IServer server) {
        String xml = ((Server)server).getAttribute(DEPLOYMENT_PREFERENCES_KEY, null);
        ByteArrayInputStream bis = null;
        if (xml != null) {
            bis = new ByteArrayInputStream(xml.getBytes());
        }
        return new DeploymentPreferences(bis);
    }

    public static void savePreferences(IServer server, DeploymentPreferences prefs) throws IOException {
        File f = DeploymentPreferenceLoader.getFile(server);
        prefs.getMemento().saveToFile(f.getAbsolutePath());
    }

    public static void savePreferences(OutputStream os, DeploymentPreferences prefs) {
        try {
            prefs.getMemento().save(os);
        }
        catch (IOException iOException) {}
    }

    protected static File getFile(IServer server) {
        IPath loc = ServerUtil.getServerStateLocation(server);
        return loc.append("deploymentPreferences.xml").toFile();
    }

    public static class DeploymentModulePrefs {
        private String id;
        private IMemento memento;
        private HashMap<String, String> properties;

        public DeploymentModulePrefs(String id, IMemento memento) {
            this.id = id;
            this.memento = memento;
            this.properties = new HashMap();
            IMemento[] children = memento.getChildren("property");
            int i = 0;
            while (i < children.length) {
                String key = children[i].getString("key");
                String val = children[i].getString("value");
                this.properties.put(key, val);
                ++i;
            }
        }

        public String getProperty(String key) {
            return this.properties.get(key);
        }

        public void setProperty(String key, String val) {
            this.properties.put(key, val);
            IMemento[] children = this.memento.getChildren("property");
            int i = 0;
            while (i < children.length) {
                if (key.equals(children[i].getString("key"))) {
                    children[i].putString("key", key);
                    children[i].putString("value", val);
                    return;
                }
                ++i;
            }
            IMemento child = this.memento.createChild("property");
            child.putString("key", key);
            child.putString("value", val);
        }
    }

    public static class DeploymentPreferences {
        private HashMap<String, DeploymentTypePrefs> children = new HashMap();
        private XMLMemento memento;

        public DeploymentPreferences(InputStream is) {
            if (is != null) {
                this.memento = XMLMemento.createReadRoot((InputStream)is);
                String[] deploymentTypes = this.memento.getChildNames();
                int i = 0;
                while (i < deploymentTypes.length) {
                    this.children.put(deploymentTypes[i], new DeploymentTypePrefs(deploymentTypes[i], this.memento.getChild(deploymentTypes[i])));
                    ++i;
                }
            } else {
                this.memento = XMLMemento.createWriteRoot((String)"deployment");
            }
        }

        public DeploymentTypePrefs getPreferences(String deploymentType) {
            return this.children.get(deploymentType);
        }

        public DeploymentTypePrefs getOrCreatePreferences(String deploymentType) {
            if (this.children.get(deploymentType) == null) {
                this.children.put(deploymentType, new DeploymentTypePrefs(deploymentType, this.memento.createChild(deploymentType)));
            }
            return this.children.get(deploymentType);
        }

        public String[] getDeploymentTypes() {
            Set<String> s = this.children.keySet();
            return s.toArray(new String[s.size()]);
        }

        protected XMLMemento getMemento() {
            return this.memento;
        }
    }

    public static class DeploymentTypePrefs {
        private String type;
        private HashMap<String, DeploymentModulePrefs> children;
        private IMemento memento;

        public DeploymentTypePrefs(String type, IMemento memento) {
            this.type = type;
            this.memento = memento;
            this.children = new HashMap();
            IMemento[] mementos = memento.getChildren("module");
            int i = 0;
            while (i < mementos.length) {
                String id = mementos[i].getString("id");
                this.children.put(id, new DeploymentModulePrefs(id, mementos[i]));
                ++i;
            }
        }

        public DeploymentModulePrefs getModulePrefs(IModule module) {
            return this.children.get(module.getId());
        }

        public DeploymentModulePrefs getOrCreateModulePrefs(IModule module) {
            if (this.children.get(module.getId()) == null) {
                IMemento childMemento = this.memento.createChild("module");
                childMemento.putString("id", module.getId());
                this.children.put(module.getId(), new DeploymentModulePrefs(module.getId(), childMemento));
            }
            return this.children.get(module.getId());
        }
    }
}

