/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.core.util;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Date;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.jboss.ide.eclipse.as.core.Messages;

public class FileUtil {
    public static void safeDelete(File file) {
        FileUtil.safeDelete(file, null);
    }

    public static void safeDelete(File file, IFileUtilListener listener) {
        block12: {
            block11: {
                if (file.isDirectory()) {
                    File[] children = file.listFiles();
                    if (children != null) {
                        int i = 0;
                        while (i < children.length) {
                            FileUtil.safeDelete(children[i], listener);
                            ++i;
                        }
                    }
                    if (file.exists()) {
                        try {
                            boolean tmp = file.delete();
                            if (listener != null) {
                                listener.folderDeleted(file, tmp, null);
                            }
                        }
                        catch (SecurityException sex) {
                            if (listener == null) break block11;
                            listener.folderDeleted(file, false, sex);
                        }
                    }
                }
            }
            if (file.exists()) {
                try {
                    boolean tmp = file.delete();
                    if (listener != null) {
                        listener.fileDeleted(file, tmp, null);
                    }
                }
                catch (SecurityException sex) {
                    if (listener == null) break block12;
                    listener.fileDeleted(file, false, sex);
                }
            }
        }
    }

    public static void completeDelete(File file) {
        FileUtil.completeDelete(file, null);
    }

    public static void completeDelete(File file, IFileUtilListener listener) {
        FileUtil.completeDelete(file, null, listener);
    }

    public static void completeDelete(File file, File archiveRoot, IFileUtilListener listener) {
        FileUtil.safeDelete(file, listener);
        while (!file.getParentFile().equals(archiveRoot) && file.getParentFile().listFiles().length == 0) {
            file = file.getParentFile();
            try {
                boolean tmp = file.delete();
                if (listener == null) continue;
                listener.folderDeleted(file, tmp, null);
            }
            catch (SecurityException sex) {
                if (listener == null) continue;
                listener.folderDeleted(file, false, sex);
            }
        }
    }

    public static boolean fileSafeCopy(File src, File dest) {
        return FileUtil.fileSafeCopy(src, dest, null);
    }

    public static boolean fileSafeCopy(File src, File dest, IFileUtilListener listener) {
        File parent = dest.getParentFile();
        parent.mkdirs();
        if (dest.exists()) {
            FileUtil.safeDelete(dest);
        }
        if (src.isDirectory()) {
            File[] subFiles = src.listFiles();
            boolean copied = true;
            dest.mkdirs();
            int i = 0;
            while (i < subFiles.length) {
                File newDest = new File(dest, subFiles[i].getName());
                copied = copied && FileUtil.fileSafeCopy(subFiles[i], newDest, listener);
                ++i;
            }
            return copied;
        }
        try {
            FileInputStream fis = new FileInputStream(src);
            FileOutputStream fos = new FileOutputStream(dest);
            byte[] buf = new byte[1024];
            int i = 0;
            while ((i = fis.read(buf)) != -1) {
                fos.write(buf, 0, i);
            }
            fis.close();
            fos.close();
            if (listener != null) {
                listener.fileCopied(src, dest, true, null);
            }
            return true;
        }
        catch (Exception e) {
            if (listener != null) {
                listener.fileCopied(src, dest, false, e);
            }
            return false;
        }
    }

    public static void touch(FileFilter filter, File root, boolean recurse) {
        File[] children;
        if (filter.accept(root)) {
            root.setLastModified(new Date().getTime());
        }
        if (recurse && root.isDirectory() && (children = root.listFiles()) != null) {
            int i = 0;
            while (i < children.length) {
                FileUtil.touch(filter, children[i], recurse);
                ++i;
            }
        }
    }

    public static class FileUtilListener
    implements IFileUtilListener {
        protected ArrayList<IStatus> errors = new ArrayList();

        public void fileCopied(File source, File dest, boolean result, Exception e) {
            if (!result) {
                this.errors.add((IStatus)new Status(4, "org.jboss.ide.eclipse.as.core", NLS.bind((String)Messages.CopyFileError, (Object)source.toString(), (Object)dest.toString()), (Throwable)e));
            }
        }

        public void fileDeleted(File file, boolean result, Exception e) {
            if (!result) {
                this.errors.add((IStatus)new Status(4, "org.jboss.ide.eclipse.as.core", NLS.bind((String)Messages.DeleteFolderError, (Object)file.toString(), (Object)e)));
            }
        }

        public void folderDeleted(File file, boolean result, Exception e) {
            if (!result) {
                this.errors.add((IStatus)new Status(4, "org.jboss.ide.eclipse.as.core", NLS.bind((String)Messages.DeleteFolderError, (Object)file.toString()), (Throwable)e));
            }
        }

        public IStatus[] getStatuses() {
            return this.errors.toArray(new IStatus[this.errors.size()]);
        }
    }

    public static interface IFileUtilListener {
        public void fileDeleted(File var1, boolean var2, Exception var3);

        public void folderDeleted(File var1, boolean var2, Exception var3);

        public void fileCopied(File var1, File var2, boolean var3, Exception var4);
    }
}

