/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.core.util;

import java.io.File;
import org.eclipse.osgi.util.NLS;
import org.jboss.ide.eclipse.as.core.Messages;

public class JBossServerType {
    private static final String SYSTEM_JAR_NAME = "twiddle.jar";
    private String type;
    private String jbossSystemJarPath;
    private String[] versions = new String[0];
    public static final JBossServerType AS = new JBossServerType("AS", "bin" + File.separatorChar + "twiddle.jar", new String[]{"5.0", "4.2", "4.0", "3.2"});
    public static final JBossServerType EAP = new JBossServerType("EAP", "jboss-as" + File.separatorChar + "bin" + File.separatorChar + "twiddle.jar", new String[]{"4.2", "4.3"});
    public static final JBossServerType SOAP = new JBossServerType("SOA-P", "jboss-as" + File.separatorChar + "bin" + File.separatorChar + "twiddle.jar", new String[]{"4.3"});
    public static final JBossServerType UNKNOWN = new JBossServerType("UNKNOWN", "", new String[]{"5.0", "4.3", "4.2", "4.0", "3.2"});
    public static final JBossServerType[] KNOWN_TYPES = new JBossServerType[]{AS, EAP, SOAP};

    private JBossServerType(String type, String jbossSystemJarPath, String[] versions) {
        this.type = type;
        this.jbossSystemJarPath = jbossSystemJarPath;
        this.versions = versions;
    }

    public String toString() {
        return this.type;
    }

    public static JBossServerType getType(String name) {
        if (JBossServerType.AS.type.equals(name)) {
            return AS;
        }
        if (JBossServerType.EAP.type.equals(name)) {
            return EAP;
        }
        if (JBossServerType.SOAP.type.equals(name)) {
            return SOAP;
        }
        throw new IllegalArgumentException(NLS.bind((String)Messages.ServerTypeDiscovererFail, (Object)name));
    }

    public String[] getVersions() {
        return this.versions;
    }

    public String getType() {
        return this.type;
    }

    public String getSystemJarPath() {
        return this.jbossSystemJarPath;
    }
}

