/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.core.util;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jboss.ide.eclipse.as.core.util.JBossServerType;

public class ServerBeanLoader {
    public static final String SOAP_JBPM_JPDL_PATH = "jbpm-jpdl";

    public JBossServerType getServerType(File location) {
        File asSystemJar = new File(location, JBossServerType.AS.getSystemJarPath());
        if (asSystemJar.exists() && asSystemJar.isFile()) {
            return JBossServerType.AS;
        }
        File eapSystemJar = new File(location, JBossServerType.EAP.getSystemJarPath());
        File jbpmJpdlFolder = new File(location, SOAP_JBPM_JPDL_PATH);
        if (eapSystemJar.exists() && eapSystemJar.isFile()) {
            if (jbpmJpdlFolder.exists() && jbpmJpdlFolder.isDirectory()) {
                return JBossServerType.SOAP;
            }
            return JBossServerType.EAP;
        }
        return JBossServerType.UNKNOWN;
    }

    public String getName(File location) {
        return location.getName();
    }

    public String getFullServerVersion(File systemJarFile) {
        String version = null;
        if (systemJarFile.canRead()) {
            try {
                ZipFile jar = new ZipFile(systemJarFile);
                ZipEntry manifest = jar.getEntry("META-INF/MANIFEST.MF");
                Properties props = new Properties();
                props.load(jar.getInputStream(manifest));
                version = (String)props.get("Specification-Version");
            }
            catch (IOException iOException) {}
        }
        return version;
    }

    public String getServerVersion(String version) {
        String pattern;
        String currentVersion;
        if (version == null) {
            return "";
        }
        String[] versions = JBossServerType.UNKNOWN.getVersions();
        String adapterVersion = "";
        String[] stringArray = versions;
        int n = versions.length;
        int n2 = 0;
        while (n2 < n) {
            currentVersion = stringArray[n2];
            pattern = String.valueOf(currentVersion.replace(".", "\\.")) + ".*";
            if (version.matches(pattern)) {
                adapterVersion = currentVersion;
                break;
            }
            ++n2;
        }
        if ("".equals(adapterVersion)) {
            stringArray = versions;
            n = versions.length;
            n2 = 0;
            while (n2 < n) {
                currentVersion = stringArray[n2];
                pattern = String.valueOf(currentVersion.substring(0, 2).replace(".", "\\.")) + ".*";
                if (version.matches(pattern)) {
                    adapterVersion = currentVersion;
                    break;
                }
                ++n2;
            }
        }
        return adapterVersion;
    }

    public String getAdapterVersion(String version) {
        String pattern;
        String currentVersion;
        String[] versions = JBossServerType.UNKNOWN.getVersions();
        String adapterVersion = "";
        String[] stringArray = versions;
        int n = versions.length;
        int n2 = 0;
        while (n2 < n) {
            currentVersion = stringArray[n2];
            pattern = String.valueOf(currentVersion.replace(".", "\\.")) + ".*";
            if (version.matches(pattern)) {
                adapterVersion = currentVersion;
                break;
            }
            ++n2;
        }
        if ("".equals(adapterVersion)) {
            stringArray = versions;
            n = versions.length;
            n2 = 0;
            while (n2 < n) {
                currentVersion = stringArray[n2];
                pattern = String.valueOf(currentVersion.substring(0, 2).replace(".", "\\.")) + ".*";
                if (version.matches(pattern)) {
                    adapterVersion = currentVersion;
                    break;
                }
                ++n2;
            }
        }
        return adapterVersion;
    }
}

