/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.core.util;

import java.io.File;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;
import org.jboss.ide.eclipse.as.core.JBossServerCorePlugin;
import org.jboss.ide.eclipse.as.core.Messages;
import org.jboss.ide.eclipse.as.core.server.IJBossServerRuntime;
import org.jboss.ide.eclipse.as.core.server.internal.JBossServer;

public class ServerUtil {
    public static IPath getServerStateLocation(IServer server) {
        return server == null ? JBossServerCorePlugin.getDefault().getStateLocation() : ServerUtil.getServerStateLocation(server.getId());
    }

    public static IPath getServerStateLocation(String serverID) {
        return serverID == null ? JBossServerCorePlugin.getDefault().getStateLocation() : JBossServerCorePlugin.getDefault().getStateLocation().append(serverID.replace(' ', '_'));
    }

    public static IPath makeRelative(IJBossServerRuntime rt, IPath p) {
        if (p.isAbsolute() && rt != null && rt.getRuntime().getLocation().isPrefixOf(p)) {
            int size = rt.getRuntime().getLocation().toOSString().length();
            return new Path(p.toOSString().substring(size)).makeRelative();
        }
        return p;
    }

    public static IPath makeGlobal(IJBossServerRuntime rt, IPath p) {
        if (!p.isAbsolute() && rt != null) {
            return rt.getRuntime().getLocation().append(p).makeAbsolute();
        }
        return p;
    }

    public static void createStandardFolders(IServer server) {
        File location = JBossServerCorePlugin.getServerStateLocation(server).toFile();
        location.mkdirs();
        JBossServer ds = (JBossServer)server.loadAdapter(JBossServer.class, null);
        if (ds != null) {
            File d1 = new File(location, "deploy");
            File d2 = new File(location, "tempDeploy");
            d1.mkdirs();
            d2.mkdirs();
            if (!new File(ds.getDeployFolder()).equals(d1)) {
                new File(ds.getDeployFolder()).mkdirs();
            }
            if (!new File(ds.getTempDeployFolder()).equals(d2)) {
                new File(ds.getTempDeployFolder()).mkdirs();
            }
            IRuntime rt = server.getRuntime();
            IJBossServerRuntime jbsrt = (IJBossServerRuntime)rt.loadAdapter(IJBossServerRuntime.class, (IProgressMonitor)new NullProgressMonitor());
            String config = jbsrt.getJBossConfiguration();
            IPath newTemp = new Path("server").append(config).append("tmp").append("jbosstoolsTemp").makeRelative();
            IPath newTempAsGlobal = ServerUtil.makeGlobal(jbsrt, newTemp);
            newTempAsGlobal.toFile().mkdirs();
        }
    }

    public static IServer findServer(String name) {
        IServer[] servers = ServerCore.getServers();
        int i = 0;
        while (i < servers.length) {
            if (name.trim().equals(servers[i].getName())) {
                return servers[i];
            }
            ++i;
        }
        return null;
    }

    public static String getDefaultServerName(IRuntime rt) {
        String runtimeName = rt.getName();
        String base = null;
        base = runtimeName == null || runtimeName.equals("") ? NLS.bind((String)Messages.serverVersionName, (Object)rt.getRuntimeType().getVersion()) : NLS.bind((String)Messages.serverName, (Object)runtimeName);
        if (ServerUtil.findServer(base) == null) {
            return base;
        }
        int i = 1;
        while (ServerUtil.findServer(NLS.bind((String)Messages.serverCountName, (Object)base, (Object)i)) != null) {
            ++i;
        }
        return NLS.bind((String)Messages.serverCountName, (Object)base, (Object)i);
    }
}

