/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.classpath.core;

import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.jboss.ide.eclipse.as.classpath.core.Messages;

public class DirectoryLibraryContainerInitializer
extends ClasspathContainerInitializer {
    public static final String CONTAINER_ID = "org.jboss.ide.eclipse.as.classpath.core.DirectoryLibraryContainer";

    public void initialize(IPath containerPath, IJavaProject project) throws CoreException {
        int size = containerPath.segmentCount();
        if (size > 0 && containerPath.segment(0).equals(this.getClasspathContainerID())) {
            IClasspathContainer container = this.createClasspathContainer(project, containerPath.removeFirstSegments(1));
            JavaCore.setClasspathContainer((IPath)containerPath, (IJavaProject[])new IJavaProject[]{project}, (IClasspathContainer[])new IClasspathContainer[]{container}, null);
        }
    }

    private IClasspathContainer createClasspathContainer(IJavaProject project, IPath containerPath) {
        return new DirectoryLibraryContainer(project, containerPath);
    }

    private String getClasspathContainerID() {
        return CONTAINER_ID;
    }

    static class DirectoryLibraryContainer
    implements IClasspathContainer {
        private final IResource file;
        final IClasspathEntry[] entries;
        private final IPath containerPath;
        private final IJavaProject project;

        public DirectoryLibraryContainer(IJavaProject project, IPath containerPath) {
            this.project = project;
            this.containerPath = containerPath;
            this.file = project.getProject().getWorkspace().getRoot().getFolder(containerPath);
            final ArrayList libraries = new ArrayList();
            try {
                if (this.file != null && this.file.exists()) {
                    this.file.accept(new IResourceProxyVisitor(){

                        public boolean visit(IResourceProxy proxy) {
                            switch (proxy.getType()) {
                                case 1: {
                                    if (proxy.getName().endsWith(".jar") || proxy.getName().endsWith(".zip")) {
                                        libraries.add(JavaCore.newLibraryEntry((IPath)proxy.requestFullPath(), null, null));
                                    }
                                    return false;
                                }
                                case 2: {
                                    return true;
                                }
                            }
                            return true;
                        }
                    }, 0);
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            this.entries = libraries.toArray(new IClasspathEntry[0]);
        }

        public IClasspathEntry[] getClasspathEntries() {
            return this.entries;
        }

        public String getDescription() {
            return this.file == null ? Messages.DirectoryLibraryContainerInitializer_libraries_found_no_dir : MessageFormat.format(Messages.DirectoryLibraryContainerInitializer_libraries_found_in_dir, this.file.getProjectRelativePath().toString());
        }

        public int getKind() {
            return 1;
        }

        public IPath getPath() {
            return this.file.getProjectRelativePath();
        }
    }
}

