/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.classpath.core.ejb3;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;
import org.jboss.ide.eclipse.as.classpath.core.ClasspathConstants;
import org.jboss.ide.eclipse.as.classpath.core.Messages;
import org.jboss.ide.eclipse.as.core.server.internal.JBossServer;

public class EJB3ClasspathContainer
implements IClasspathContainer,
ClasspathConstants {
    public static final String CONTAINER_ID = "org.jboss.ide.eclipse.as.classpath.core.ejb3.classpathContainer";
    public static final String DESCRIPTION = Messages.EJB3ClasspathContainer_ejb3_description;
    public static final QualifiedName JBOSS_EJB3_CONFIGURATION = new QualifiedName("org.jboss.ide.eclipse.ejb3.wizards.core.classpath", "jboss-ejb3-configuration");
    protected IJavaProject javaProject;
    protected JBossServer jbossServer;
    protected IPath path;
    protected IPath configPath = new Path("");
    protected IPath homePath = null;

    public EJB3ClasspathContainer(IPath path, IJavaProject project) {
        this.path = path;
        this.javaProject = project;
        try {
            String configName = path.segment(1);
            IServer[] servers = ServerCore.getServers();
            if (configName == null && (configName = project.getProject().getPersistentProperty(JBOSS_EJB3_CONFIGURATION)) != null) {
                project.getProject().setPersistentProperty(JBOSS_EJB3_CONFIGURATION, null);
            }
            int i = 0;
            while (i < servers.length) {
                if (servers[i].getName().equals(configName)) {
                    this.jbossServer = (JBossServer)servers[i].loadAdapter(JBossServer.class, (IProgressMonitor)new NullProgressMonitor());
                    try {
                        this.homePath = this.jbossServer.getServer().getRuntime().getLocation();
                        this.configPath = new Path(this.jbossServer.getConfigDirectory());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    break;
                }
                ++i;
            }
        }
        catch (CoreException coreException) {}
    }

    public String getDescription() {
        return Messages.EJB3ClasspathContainer_ejb30_description;
    }

    public JBossServer getJBossServer() {
        return this.jbossServer;
    }

    public void setJBossServer(JBossServer jbossServer) {
        this.jbossServer = jbossServer;
    }

    public int getKind() {
        return 1;
    }

    public IPath getPath() {
        return this.path;
    }

    public IClasspathEntry[] getClasspathEntries() {
        ArrayList entries = new ArrayList();
        String id = this.jbossServer.getServer().getServerType().getRuntimeType().getId();
        if (id.equals("org.jboss.ide.eclipse.as.runtime.40")) {
            return this.get40Jars();
        }
        if (id.equals("org.jboss.ide.eclipse.as.runtime.42")) {
            return this.get42Jars();
        }
        return entries.toArray(new IClasspathEntry[entries.size()]);
    }

    public IClasspathEntry[] get40Jars() {
        ArrayList<IClasspathEntry> list = new ArrayList<IClasspathEntry>();
        IPath deploy = this.configPath.append("deploy");
        IPath deployer = deploy.append("ejb3.deployer");
        IPath aopDeployer = deploy.append("jboss-aop-jdk50.deployer");
        list.add(this.getEntry(deployer.append("jboss-ejb3x.jar")));
        list.add(this.getEntry(deployer.append("jboss-ejb3.jar")));
        list.add(this.getEntry(deployer.append("jboss-annotations-ejb3.jar")));
        list.add(this.getEntry(aopDeployer.append("jboss-aop-jdk50.jar")));
        list.add(this.getEntry(aopDeployer.append("jboss-aspect-library-jdk50.jar")));
        list.add(this.getEntry(this.homePath.append("client").append("hibernate-client.jar")));
        return list.toArray(new IClasspathEntry[list.size()]);
    }

    public IClasspathEntry[] get42Jars() {
        ArrayList<IClasspathEntry> list = new ArrayList<IClasspathEntry>();
        IPath deploy = this.configPath.append("deploy");
        IPath deployer = deploy.append("ejb3.deployer");
        IPath aopDeployer = deploy.append("jboss-aop-jdk50.deployer");
        IPath client = this.homePath.append("client");
        list.add(this.getEntry(this.configPath.append("lib").append("jboss-ejb3x.jar")));
        list.add(this.getEntry(deployer.append("jboss-ejb3.jar")));
        list.add(this.getEntry(deployer.append("jboss-annotations-ejb3.jar")));
        list.add(this.getEntry(aopDeployer.append("jboss-aop-jdk50.jar")));
        list.add(this.getEntry(aopDeployer.append("jboss-aspect-library-jdk50.jar")));
        list.add(this.getEntry(this.homePath.append("client").append("hibernate-client.jar")));
        list.add(this.getEntry(client.append("ejb3-persistence.jar")));
        return list.toArray(new IClasspathEntry[list.size()]);
    }

    protected IClasspathEntry getEntry(IPath path) {
        return JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)path).getClasspathEntry();
    }
}

