/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.classpath.core.runtime;

import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jst.server.core.RuntimeClasspathProviderDelegate;
import org.eclipse.wst.server.core.IRuntime;
import org.jboss.ide.eclipse.as.classpath.core.ClasspathConstants;
import org.jboss.ide.eclipse.as.classpath.core.ClasspathCorePlugin;
import org.jboss.ide.eclipse.as.classpath.core.Messages;
import org.jboss.ide.eclipse.as.core.server.IJBossServerRuntime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientAllRuntimeClasspathProvider
extends RuntimeClasspathProviderDelegate
implements ClasspathConstants {
    public IClasspathEntry[] resolveClasspathContainer(IProject project, IRuntime runtime) {
        if (runtime == null) {
            return new IClasspathEntry[0];
        }
        IJBossServerRuntime jbsrt = (IJBossServerRuntime)runtime.loadAdapter(IJBossServerRuntime.class, (IProgressMonitor)new NullProgressMonitor());
        if (jbsrt == null) {
            Status status = new Status(2, "org.jboss.ide.eclipse.as.classpath.core", MessageFormat.format(Messages.ClientAllRuntimeClasspathProvider_wrong_runtime_type, runtime.getName()));
            ClasspathCorePlugin.getDefault().getLog().log((IStatus)status);
            return new IClasspathEntry[0];
        }
        IPath loc = runtime.getLocation();
        IPath configPath = jbsrt.getConfigurationFullPath();
        String rtID = runtime.getRuntimeType().getId();
        if ("org.jboss.ide.eclipse.as.runtime.32".equals(rtID)) {
            return this.get32(loc, configPath);
        }
        if ("org.jboss.ide.eclipse.as.runtime.40".equals(rtID)) {
            return this.get40(loc, configPath);
        }
        if ("org.jboss.ide.eclipse.as.runtime.42".equals(rtID)) {
            return this.get42(loc, configPath);
        }
        if ("org.jboss.ide.eclipse.as.runtime.50".equals(rtID)) {
            return this.get50(loc, configPath);
        }
        if ("org.jboss.ide.eclipse.as.runtime.eap.43".equals(rtID)) {
            return this.getEAP43(loc, configPath);
        }
        if ("org.jboss.ide.eclipse.as.runtime.51".equals(rtID)) {
            return this.get50(loc, configPath);
        }
        if ("org.jboss.ide.eclipse.as.runtime.60".equals(rtID)) {
            return this.get50(loc, configPath);
        }
        if ("org.jboss.ide.eclipse.as.runtime.eap.50".equals(rtID)) {
            return this.get50(loc, configPath);
        }
        return null;
    }

    protected IClasspathEntry[] get32(IPath location, IPath configPath) {
        ArrayList<IClasspathEntry> list = new ArrayList<IClasspathEntry>();
        this.addEntries(location.append("client"), list);
        this.addEntries(location.append("lib"), list);
        this.addEntries(configPath.append("lib"), list);
        return list.toArray(new IClasspathEntry[list.size()]);
    }

    protected IClasspathEntry[] get40(IPath location, IPath configPath) {
        ArrayList<IClasspathEntry> list = new ArrayList<IClasspathEntry>();
        IPath deployPath = configPath.append("deploy");
        this.addEntries(location.append("client"), list);
        this.addEntries(location.append("lib"), list);
        this.addEntries(configPath.append("lib"), list);
        this.addEntries(deployPath.append("jboss-web.deployer").append("jsf-libs"), list);
        this.addEntries(deployPath.append("jboss-aop-jdk50.deployer"), list);
        this.addEntries(deployPath.append("ejb3.deployer"), list);
        return list.toArray(new IClasspathEntry[list.size()]);
    }

    protected IClasspathEntry[] get42(IPath location, IPath configPath) {
        return this.get40(location, configPath);
    }

    protected IClasspathEntry[] getEAP43(IPath location, IPath configPath) {
        return this.get40(location, configPath);
    }

    protected IClasspathEntry[] get50(IPath location, IPath configPath) {
        ArrayList<IClasspathEntry> list = new ArrayList<IClasspathEntry>();
        IPath deployerPath = configPath.append("deployers");
        IPath deployPath = configPath.append("deploy");
        this.addEntries(location.append("client"), list);
        this.addEntries(location.append("lib"), list);
        this.addEntries(location.append("common").append("lib"), list);
        this.addEntries(configPath.append("lib"), list);
        this.addEntries(deployPath.append("jbossweb.sar").append("jsf-libs"), list);
        this.addEntries(deployPath.append("jbossweb.sar").append("jboss-web-service.jar"), list);
        this.addEntries(deployPath.append("jbossweb.sar").append("jstl.jar"), list);
        this.addEntries(deployerPath.append("jboss-aop-jboss5.deployer"), list);
        this.addEntries(deployerPath.append("ejb3.deployer"), list);
        this.addEntries(deployerPath.append("webbeans.deployer").append("jsr299-api.jar"), list);
        return list.toArray(new IClasspathEntry[list.size()]);
    }

    protected IClasspathEntry getEntry(IPath path) {
        return JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)path).getClasspathEntry();
    }

    protected void addEntries(IPath folder, ArrayList<IClasspathEntry> list) {
        if (folder.toFile().exists()) {
            File f = folder.toFile();
            if (f.isDirectory()) {
                String[] files = f.list();
                int i = 0;
                while (i < files.length) {
                    if (files[i].endsWith(".jar") && ClientAllFilter.accepts(folder.append(files[i]))) {
                        list.add(this.getEntry(folder.append(files[i])));
                    }
                    ++i;
                }
            } else {
                list.add(this.getEntry(folder));
            }
        }
    }

    public static class ClientAllFilter {
        public static boolean accepts(IPath path) {
            if (!path.lastSegment().endsWith(".jar")) {
                return false;
            }
            return !path.lastSegment().toLowerCase().endsWith("jaxb-xjc.jar");
        }
    }
}

