/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.classpath.core.runtime;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.common.project.facet.core.IClasspathProvider;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponent;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.ServerCore;
import org.jboss.ide.eclipse.as.classpath.core.Messages;
import org.jboss.ide.eclipse.as.classpath.core.runtime.ClientAllRuntimeClasspathProvider;
import org.jboss.ide.eclipse.as.classpath.core.runtime.WebtoolsProjectJBossClasspathContainerInitializer;

public class ProjectRuntimeClasspathProvider
implements IClasspathProvider {
    public static final String CONTAINER_ID = "org.jboss.ide.eclipse.as.classpath.core.runtime.ProjectInitializer";
    private IRuntimeComponent rc;

    public ProjectRuntimeClasspathProvider() {
    }

    public ProjectRuntimeClasspathProvider(IRuntimeComponent rc) {
        this.rc = rc;
    }

    public List getClasspathEntries(IProjectFacetVersion fv) {
        Path path = null;
        if (fv.getProjectFacet().getId().equals("jst.java")) {
            path = new Path(CONTAINER_ID);
            path = path.append(this.rc.getProperty("id"));
            path = path.append(fv.getProjectFacet().getId());
            path = path.append(fv.getVersionString());
            IClasspathEntry[] entries = new WebtoolsProjectJBossClasspathContainerInitializer.WebtoolsProjectJBossClasspathContainer((IPath)path).getClasspathEntries();
            return Arrays.asList(entries);
        }
        if (this.isPrimaryFacet(fv.getProjectFacet()) || this.isSecondaryFacet(fv.getProjectFacet())) {
            String id = this.rc.getProperty("id");
            IPath containerPath = new Path("org.eclipse.jst.server.core.container").append("org.jboss.ide.eclipse.as.core.server.runtime.runtimeTarget");
            path = containerPath.append(id);
        }
        if (path != null) {
            IClasspathEntry cpentry = JavaCore.newContainerEntry((IPath)path);
            return Collections.singletonList(cpentry);
        }
        return Collections.emptyList();
    }

    protected boolean isPrimaryFacet(IProjectFacet facet) {
        WebtoolsProjectJBossClasspathContainerInitializer del = new WebtoolsProjectJBossClasspathContainerInitializer();
        return facet.equals(WebtoolsProjectJBossClasspathContainerInitializer.WEB_FACET) || facet.equals(WebtoolsProjectJBossClasspathContainerInitializer.EJB_FACET) || facet.equals(WebtoolsProjectJBossClasspathContainerInitializer.EAR_FACET) || facet.equals(WebtoolsProjectJBossClasspathContainerInitializer.CONNECTOR_FACET) || facet.equals(WebtoolsProjectJBossClasspathContainerInitializer.APP_CLIENT_FACET);
    }

    protected boolean isSecondaryFacet(IProjectFacet facet) {
        WebtoolsProjectJBossClasspathContainerInitializer del = new WebtoolsProjectJBossClasspathContainerInitializer();
        return facet.equals(WebtoolsProjectJBossClasspathContainerInitializer.JSF_FACET) || facet.equals(WebtoolsProjectJBossClasspathContainerInitializer.JPA_FACET);
    }

    public static final class Factory
    implements IAdapterFactory {
        private static final Class[] ADAPTER_TYPES = new Class[]{IClasspathProvider.class};

        public Object getAdapter(Object adaptable, Class adapterType) {
            IRuntimeComponent rc = (IRuntimeComponent)adaptable;
            return new ProjectRuntimeClasspathProvider(rc);
        }

        public Class[] getAdapterList() {
            return ADAPTER_TYPES;
        }
    }

    public static class RuntimeClasspathContainer
    implements IClasspathContainer {
        private IPath path;
        private IRuntime rt;

        public RuntimeClasspathContainer(IPath path) throws CoreException {
            this.path = path;
            this.rt = ServerCore.findRuntime((String)path.segment(1));
            if (this.rt == null) {
                throw new CoreException((IStatus)new Status(4, "org.jboss.ide.eclipse.as.classpath.core", MessageFormat.format(Messages.ProjectRuntimeClasspathProvider_runtime_does_not_exist, path.segment(1))));
            }
        }

        public IClasspathEntry[] getClasspathEntries() {
            return new ClientAllRuntimeClasspathProvider().resolveClasspathContainer(null, this.rt);
        }

        public String getDescription() {
            return MessageFormat.format(Messages.ProjectRuntimeClasspathProvider_all_jboss_libraries_description, this.rt == null ? "null" : this.rt.getName());
        }

        public int getKind() {
            return 1;
        }

        public IPath getPath() {
            return this.path;
        }
    }

    public static class RuntimeClasspathContainerInitializer
    extends ClasspathContainerInitializer {
        public void initialize(IPath containerPath, IJavaProject project) throws CoreException {
            RuntimeClasspathContainer container = new RuntimeClasspathContainer(containerPath);
            JavaCore.setClasspathContainer((IPath)containerPath, (IJavaProject[])new IJavaProject[]{project}, (IClasspathContainer[])new IClasspathContainer[]{container}, null);
        }
    }
}

