/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.classpath.core.runtime;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.ServerCore;
import org.jboss.ide.eclipse.as.classpath.core.ClasspathConstants;
import org.jboss.ide.eclipse.as.classpath.core.Messages;
import org.jboss.ide.eclipse.as.core.server.IJBossServerRuntime;

public class WebtoolsProjectJBossClasspathContainerInitializer
extends ClasspathContainerInitializer
implements ClasspathConstants {
    public static final IProjectFacet JST_JAVA_FACET = ProjectFacetsManager.getProjectFacet((String)"jst.java");
    public static final IProjectFacet WEB_FACET = ProjectFacetsManager.getProjectFacet((String)"jst.web");
    public static final IProjectFacet EJB_FACET = ProjectFacetsManager.getProjectFacet((String)"jst.ejb");
    public static final IProjectFacet EAR_FACET = ProjectFacetsManager.getProjectFacet((String)"jst.ear");
    public static final IProjectFacet UTILITY_FACET = ProjectFacetsManager.getProjectFacet((String)"jst.utility");
    public static final IProjectFacet CONNECTOR_FACET = ProjectFacetsManager.getProjectFacet((String)"jst.connector");
    public static final IProjectFacet APP_CLIENT_FACET = ProjectFacetsManager.getProjectFacet((String)"jst.appclient");
    public static final IProjectFacet JSF_FACET = ProjectFacetsManager.getProjectFacet((String)"jst.jsf");
    public static final IProjectFacet JPA_FACET = ProjectFacetsManager.getProjectFacet((String)"jpt.jpa");

    public void initialize(IPath containerPath, IJavaProject project) throws CoreException {
        WebtoolsProjectJBossClasspathContainer container = new WebtoolsProjectJBossClasspathContainer(containerPath);
        JavaCore.setClasspathContainer((IPath)containerPath, (IJavaProject[])new IJavaProject[]{project}, (IClasspathContainer[])new IClasspathContainer[]{container}, null);
    }

    public IClasspathEntry[] getEntries(IPath path) {
        return new WebtoolsProjectJBossClasspathContainer(path).getClasspathEntries();
    }

    public static class WebtoolsProjectJBossClasspathContainer
    implements IClasspathContainer {
        private IPath path;
        private IClasspathEntry[] entries = null;

        public WebtoolsProjectJBossClasspathContainer(IPath path) {
            this.path = path;
        }

        public String getDescription() {
            if (this.path.segmentCount() < 4) {
                return Messages.WebtoolsProjectJBossClasspathContainerInitializer_jboss_runtimes;
            }
            String pathSegments = String.valueOf(this.path.segment(2)) + " : " + this.path.segment(3);
            return MessageFormat.format(Messages.WebtoolsProjectJBossClasspathContainerInitializer_jboss_runtimes_path, pathSegments);
        }

        public int getKind() {
            return 1;
        }

        public IPath getPath() {
            return this.path;
        }

        public IClasspathEntry[] getClasspathEntries() {
            if (this.entries == null) {
                this.loadClasspathEntries();
                if (this.entries == null) {
                    return new IClasspathEntry[0];
                }
            }
            return this.entries;
        }

        private void loadClasspathEntries() {
            if (this.path.segmentCount() < 4) {
                return;
            }
            String runtimeId = this.path.segment(1);
            String facetId = this.path.segment(2);
            String facetVersion = this.path.segment(3);
            if (runtimeId == null) {
                return;
            }
            IRuntime runtime = ServerCore.findRuntime((String)runtimeId);
            if (runtime == null) {
                return;
            }
            IJBossServerRuntime jbRuntime = (IJBossServerRuntime)runtime.loadAdapter(IJBossServerRuntime.class, null);
            if (jbRuntime != null) {
                String serverHome = runtime.getLocation().toOSString();
                String configName = jbRuntime.getJBossConfiguration();
                String jbossVersion = jbRuntime.getRuntime().getRuntimeType().getVersion();
                this.entries = this.loadClasspathEntries2(runtimeId, facetId, facetVersion, serverHome, configName, jbossVersion, jbRuntime);
            }
        }

        protected IClasspathEntry[] loadClasspathEntries2(String runtimeId, String facetId, String facetVersion, String serverHome, String configName, String jbVersion, IJBossServerRuntime jbsRuntime) {
            if (facetId.equals(JST_JAVA_FACET.getId())) {
                return this.loadJREClasspathEntries(jbsRuntime);
            }
            if ("5.0".equals(jbVersion)) {
                return this.loadClasspathEntriesDefault(facetId, facetVersion, serverHome, configName);
            }
            if ("4.2".equals(jbVersion)) {
                return this.loadClasspathEntries42(facetId, facetVersion, serverHome, configName);
            }
            if ("4.0".equals(jbVersion)) {
                return this.loadClasspathEntries40(facetId, facetVersion, serverHome, configName);
            }
            if ("3.2".equals(jbVersion)) {
                return this.loadClasspathEntries32(facetId, facetVersion, serverHome, configName);
            }
            return this.loadClasspathEntriesDefault(facetId, facetVersion, serverHome, configName);
        }

        protected boolean isEjb30(String facetId, String facetVersion) {
            return facetId.equals(EJB_FACET.getId()) && facetVersion.equals("3.0");
        }

        protected IClasspathEntry getEntry(IPath path) {
            return JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)path).getClasspathEntry();
        }

        protected IClasspathEntry[] getEntries(IPath folder) {
            String[] files = folder.toFile().list();
            ArrayList<IClasspathEntry> list = new ArrayList<IClasspathEntry>();
            int i = 0;
            while (i < files.length) {
                if (files[i].endsWith(".jar")) {
                    list.add(this.getEntry(folder.append(files[i])));
                }
                ++i;
            }
            return list.toArray(new IClasspathEntry[list.size()]);
        }

        protected IClasspathEntry[] loadJREClasspathEntries(IJBossServerRuntime jbsRuntime) {
            IVMInstall vmInstall = jbsRuntime.getVM();
            if (vmInstall != null) {
                String name = vmInstall.getName();
                String typeId = vmInstall.getVMInstallType().getId();
                return new IClasspathEntry[]{JavaCore.newContainerEntry((IPath)new Path(JavaRuntime.JRE_CONTAINER).append(typeId).append(name))};
            }
            return null;
        }

        protected IClasspathEntry[] loadClasspathEntries42(String facetId, String facetVersion, String serverHome, String configName) {
            Path homePath = new Path(serverHome);
            IPath configPath = homePath.append("server").append(configName);
            ArrayList<IClasspathEntry> list = new ArrayList<IClasspathEntry>();
            if (facetId.equals(WEB_FACET.getId())) {
                IPath jsfDir = configPath.append("deploy").append("jboss-web.deployer").append("jsf-libs");
                list.add(this.getEntry(configPath.append("lib").append("jsp-api.jar")));
                list.add(this.getEntry(homePath.append("client").append("servlet-api.jar")));
                list.add(this.getEntry(jsfDir.append("jsf-api.jar")));
                list.add(this.getEntry(jsfDir.append("jsf-impl.jar")));
            } else if (facetId.equals(EJB_FACET.getId()) && !this.isEjb30(facetId, facetVersion)) {
                list.add(this.getEntry(homePath.append("client").append("jboss-j2ee.jar")));
            } else if (this.isEjb30(facetId, facetVersion)) {
                IPath deploy = configPath.append("deploy");
                IPath deployer = deploy.append("ejb3.deployer");
                IPath aopDeployer = deploy.append("jboss-aop-jdk50.deployer");
                IPath client = homePath.append("client");
                list.add(this.getEntry(configPath.append("lib").append("jboss-ejb3x.jar")));
                list.add(this.getEntry(deployer.append("jboss-ejb3.jar")));
                list.add(this.getEntry(deployer.append("jboss-annotations-ejb3.jar")));
                list.add(this.getEntry(aopDeployer.append("jboss-aop-jdk50.deployer")));
                list.add(this.getEntry(aopDeployer.append("jboss-aspect-library-jdk50.jar")));
                list.add(this.getEntry(homePath.append("client").append("hibernate-client.jar")));
                list.add(this.getEntry(client.append("ejb3-persistence.jar")));
            } else if (facetId.equals(EAR_FACET.getId())) {
                list.add(this.getEntry(homePath.append("client").append("jboss-j2ee.jar")));
            } else if (facetId.equals(APP_CLIENT_FACET.getId())) {
                list.add(this.getEntry(homePath.append("client").append("jbossall-client.jar")));
            }
            return list.toArray(new IClasspathEntry[list.size()]);
        }

        protected IClasspathEntry[] loadClasspathEntries40(String facetId, String facetVersion, String serverHome, String configName) {
            Path homePath = new Path(serverHome);
            IPath configPath = homePath.append("server").append(configName);
            ArrayList<IClasspathEntry> list = new ArrayList<IClasspathEntry>();
            if (facetId.equals(WEB_FACET.getId())) {
                IPath jsfDir = configPath.append("deploy").append("jbossweb-tomcat55.sar").append("jsf-libs");
                list.add(this.getEntry(configPath.append("lib").append("javax.servlet.jsp.jar")));
                list.add(this.getEntry(homePath.append("client").append("javax.servlet.jar")));
                list.addAll(Arrays.asList(this.getEntries(jsfDir)));
            } else if (facetId.equals(EJB_FACET.getId()) && !this.isEjb30(facetId, facetVersion)) {
                list.add(this.getEntry(homePath.append("client").append("jboss-j2ee.jar")));
            } else if (this.isEjb30(facetId, facetVersion)) {
                IPath deploy = configPath.append("deploy");
                IPath deployer = deploy.append("ejb3.deployer");
                IPath aopDeployer = deploy.append("jboss-aop-jdk50.deployer");
                list.add(this.getEntry(deployer.append("jboss-ejb3x.jar")));
                list.add(this.getEntry(deployer.append("jboss-ejb3.jar")));
                list.add(this.getEntry(deployer.append("jboss-annotations-ejb3.jar")));
                list.add(this.getEntry(aopDeployer.append("jboss-aop-jdk50.jar")));
                list.add(this.getEntry(aopDeployer.append("jboss-aspect-library-jdk50.jar")));
                list.add(this.getEntry(homePath.append("client").append("hibernate-client.jar")));
            } else if (facetId.equals(EAR_FACET.getId())) {
                list.add(this.getEntry(homePath.append("client").append("jboss-j2ee.jar")));
            } else if (facetId.equals(APP_CLIENT_FACET.getId())) {
                list.add(JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)homePath.append("client").append("jbossall-client.jar")).getClasspathEntry());
            }
            return list.toArray(new IClasspathEntry[list.size()]);
        }

        protected IClasspathEntry[] loadClasspathEntries32(String facetId, String facetVersion, String serverHome, String configName) {
            Path homePath = new Path(serverHome);
            IPath configPath = homePath.append("server").append(configName);
            ArrayList<IClasspathEntry> list = new ArrayList<IClasspathEntry>();
            if (facetId.equals(WEB_FACET.getId())) {
                IPath p = configPath.append("deploy").append("jbossweb-tomcat50.sar");
                list.add(this.getEntry(p.append("jsp-api.jar")));
                list.add(this.getEntry(p.append("servlet-api.jar")));
            } else if (facetId.equals(EJB_FACET.getId()) && !this.isEjb30(facetId, facetVersion) || facetId.equals(EAR_FACET.getId())) {
                list.add(this.getEntry(homePath.append("client").append("jboss-j2ee.jar")));
            } else if (facetId.equals(APP_CLIENT_FACET.getId())) {
                list.add(this.getEntry(homePath.append("client").append("jbossall-client.jar")));
            }
            return list.toArray(new IClasspathEntry[list.size()]);
        }

        protected IClasspathEntry[] loadClasspathEntriesDefault(String facetId, String facetVersion, String serverHome, String configName) {
            return new IClasspathEntry[0];
        }

        protected IClasspathEntry[] pathsAsEntries(IPath[] paths) {
            IClasspathEntry[] entries = new IClasspathEntry[paths.length];
            int i = 0;
            while (i < paths.length) {
                entries[i] = this.getEntry(paths[i]);
                ++i;
            }
            return entries;
        }
    }
}

