/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.ssh.server;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.internal.Server;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.eclipse.wst.server.core.model.IModuleResourceDelta;
import org.jboss.ide.eclipse.archives.core.model.IArchive;
import org.jboss.ide.eclipse.archives.webtools.Messages;
import org.jboss.ide.eclipse.archives.webtools.modules.PackageModuleFactory;
import org.jboss.ide.eclipse.as.core.publishers.PublishUtil;
import org.jboss.ide.eclipse.as.core.server.IDeployableServer;
import org.jboss.ide.eclipse.as.core.server.IJBossServerPublishMethod;
import org.jboss.ide.eclipse.as.core.server.IJBossServerPublisher;
import org.jboss.ide.eclipse.as.core.server.xpl.PublishCopyUtil;
import org.jboss.ide.eclipse.as.core.util.ServerConverter;
import org.jboss.ide.eclipse.as.ssh.server.SSHPublisher;
import org.jboss.ide.eclipse.as.ssh.server.SSHServerBehaviourDelegate;
import org.jboss.ide.eclipse.as.ssh.server.SSHZippedJSTPublisher;

public class SSHPackagesPublisher
implements IJBossServerPublisher {
    protected IDeployableServer server;
    protected IModuleResourceDelta[] delta;
    protected ArrayList<IStatus> statuses = new ArrayList();
    protected SSHServerBehaviourDelegate.SSHPublishMethod method;

    public int getPublishState() {
        return 1;
    }

    public boolean accepts(String method, IServer server, IModule[] module) {
        return "ssh".equals(method) && module != null && module.length > 0 && "jboss.package".equals(module[0].getModuleType().getId());
    }

    public IStatus publishModule(IJBossServerPublishMethod method, IServer server, IModule[] module, int publishType, IModuleResourceDelta[] delta, IProgressMonitor monitor) throws CoreException {
        this.method = (SSHServerBehaviourDelegate.SSHPublishMethod)method;
        this.server = ServerConverter.getDeployableServer((IServer)server);
        this.delta = delta;
        IModule module2 = module[0];
        try {
            if (publishType == 3) {
                this.statuses.addAll(Arrays.asList(this.removeModule(module2, monitor)));
            } else if (publishType == 2) {
                this.statuses.addAll(Arrays.asList(this.publishModule(module2, false, monitor)));
            } else if (publishType == 1) {
                this.statuses.addAll(Arrays.asList(this.publishModule(module2, true, monitor)));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Status status = new Status(4, "org.jboss.ide.eclipse.archives.webtools", NLS.bind((String)Messages.ErrorDuringPublish, (Object)module2.getName()), (Throwable)e);
            return status;
        }
        if (this.statuses.size() > 0) {
            MultiStatus ms = new MultiStatus("org.jboss.ide.eclipse.archives.webtools", 4, NLS.bind((String)Messages.ErrorDuringPublish, (Object)module2.getName()), null);
            int i = 0;
            while (i < this.statuses.size()) {
                ms.add(this.statuses.get(i));
                ++i;
            }
            return ms;
        }
        Status ret = new Status(0, "org.jboss.ide.eclipse.archives.webtools", NLS.bind((String)Messages.PublishSuccessful, (Object)module2.getName()));
        return ret;
    }

    protected IStatus[] removeModule(IModule module, IProgressMonitor monitor) {
        IArchive pack = this.getPackage(module);
        if (pack != null) {
            IPath sourcePath = pack.getArchiveFilePath();
            String deployFolder = this.getRemoteDeployFolder(this.server.getServer());
            String deployFile = new Path(deployFolder).append(sourcePath.lastSegment()).toString();
            try {
                SSHZippedJSTPublisher.launchRemoveCommand(this.method.getSession(), deployFile, monitor);
            }
            catch (CoreException ce) {
                return new IStatus[]{ce.getStatus()};
            }
        }
        return new IStatus[0];
    }

    protected IStatus[] publishModule(IModule module, boolean incremental, IProgressMonitor monitor) {
        IArchive pack = this.getPackage(module);
        IPath sourcePath = pack.getArchiveFilePath();
        String remoteContainer = this.getRemoteDeployFolder(this.server.getServer());
        IPath remoteRoot = new Path(remoteContainer).append(sourcePath.lastSegment());
        try {
            if (pack.isExploded()) {
                if (incremental) {
                    SSHPublisher.SSHCopyCallback callback = new SSHPublisher.SSHCopyCallback(remoteRoot, this.method);
                    PublishCopyUtil util = new PublishCopyUtil((PublishCopyUtil.IPublishCopyCallbackHandler)callback);
                    return util.publishDelta(this.delta, monitor);
                }
                SSHZippedJSTPublisher.launchCommand(this.method.getSession(), "rm -rf " + remoteRoot.toString(), monitor);
                IModuleResource[] members = PublishUtil.getResources((IModule)module);
                SSHPublisher.SSHCopyCallback callback = new SSHPublisher.SSHCopyCallback(remoteRoot, this.method);
                PublishCopyUtil util = new PublishCopyUtil((PublishCopyUtil.IPublishCopyCallbackHandler)callback);
                return util.publishFull(members, monitor);
            }
            SSHZippedJSTPublisher.launchCommand(this.method.getSession(), "rm -rf " + remoteRoot.toString(), monitor);
            SSHZippedJSTPublisher.launchCopyCommand(this.method.getSession(), sourcePath.toOSString(), remoteRoot.toString(), monitor);
        }
        catch (CoreException ce) {
            return new IStatus[]{ce.getStatus()};
        }
        return new IStatus[0];
    }

    protected IArchive getPackage(IModule module) {
        PackageModuleFactory.PackagedModuleDelegate delegate = (PackageModuleFactory.PackagedModuleDelegate)module.loadAdapter(PackageModuleFactory.PackagedModuleDelegate.class, (IProgressMonitor)new NullProgressMonitor());
        return delegate == null ? null : delegate.getPackage();
    }

    protected String getRemoteDeployFolder(IServer server) {
        return ((Server)server).getAttribute("org.jboss.ide.eclipse.as.ssh.server.deployDirectory", null);
    }
}

