/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.ssh.server;

import com.jcraft.jsch.Session;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.componentcore.ModuleCoreNature;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.internal.Server;
import org.eclipse.wst.server.core.model.IModuleFile;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.eclipse.wst.server.core.model.IModuleResourceDelta;
import org.jboss.ide.eclipse.as.core.JBossServerCorePlugin;
import org.jboss.ide.eclipse.as.core.Messages;
import org.jboss.ide.eclipse.as.core.publishers.PublishUtil;
import org.jboss.ide.eclipse.as.core.server.IDeployableServer;
import org.jboss.ide.eclipse.as.core.server.IJBossServerPublishMethod;
import org.jboss.ide.eclipse.as.core.server.IJBossServerPublisher;
import org.jboss.ide.eclipse.as.core.server.xpl.PublishCopyUtil;
import org.jboss.ide.eclipse.as.core.util.ServerConverter;
import org.jboss.ide.eclipse.as.ssh.server.SSHPublishUtil;
import org.jboss.ide.eclipse.as.ssh.server.SSHServerBehaviourDelegate;
import org.jboss.ide.eclipse.as.ssh.server.SSHZippedJSTPublisher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SSHPublisher
implements IJBossServerPublisher {
    protected IModuleResourceDelta[] delta;
    protected IDeployableServer server;
    protected int publishState = 1;
    protected SSHServerBehaviourDelegate.SSHPublishMethod publishMethod;

    public boolean accepts(String method, IServer server, IModule[] module) {
        if (!method.equals("ssh")) {
            return false;
        }
        if (module == null) {
            return true;
        }
        IDeployableServer ds = ServerConverter.getDeployableServer((IServer)server);
        boolean shouldAccept = ds != null && ModuleCoreNature.isFlexibleProject((IProject)module[0].getProject()) && !SSHPublishUtil.getZipsSSHDeployments(server);
        return shouldAccept;
    }

    public int getPublishState() {
        return this.publishState;
    }

    public IStatus publishModule(IJBossServerPublishMethod method, IServer server, IModule[] module, int publishType, IModuleResourceDelta[] delta, IProgressMonitor monitor) throws CoreException {
        IStatus status = null;
        this.server = ServerConverter.getDeployableServer((IServer)server);
        this.delta = delta;
        this.publishMethod = (SSHServerBehaviourDelegate.SSHPublishMethod)method;
        boolean deleted = false;
        int i = 0;
        while (i < module.length) {
            if (module[i].isExternal()) {
                deleted = true;
            }
            ++i;
        }
        if (publishType == 3) {
            status = this.unpublish(this.server, module, monitor);
        } else if (deleted) {
            this.publishState = 0;
        } else if (publishType == 2) {
            status = this.fullPublish(module, module[module.length - 1], monitor);
        } else if (publishType == 1) {
            status = this.incrementalPublish(module, module[module.length - 1], monitor);
        }
        return status;
    }

    protected IStatus fullPublish(IModule[] moduleTree, IModule module, IProgressMonitor monitor) throws CoreException {
        IPath remoteDeployPath = SSHPublisher.getDeployPath(moduleTree, this.server);
        IModuleResource[] members = PublishUtil.getResources((IModule)module);
        if (new Path(module.getName()).segmentCount() <= 1) {
            SSHZippedJSTPublisher.launchCommand(this.publishMethod.getSession(), "rm -rf " + remoteDeployPath.toString(), monitor);
        }
        ArrayList<IStatus> list = new ArrayList<IStatus>();
        if (!PublishUtil.deployPackaged((IModule[])moduleTree) && !PublishUtil.isBinaryObject((IModule[])moduleTree)) {
            SSHCopyCallback callback = new SSHCopyCallback(remoteDeployPath, this.publishMethod);
            PublishCopyUtil util = new PublishCopyUtil((PublishCopyUtil.IPublishCopyCallbackHandler)callback);
            list.addAll(Arrays.asList(util.publishFull(members, monitor)));
        } else if (PublishUtil.isBinaryObject((IModule[])moduleTree)) {
            list.addAll(Arrays.asList(this.copyBinaryModule(moduleTree, monitor)));
        } else {
            IPath deployRoot = JBossServerCorePlugin.getServerStateLocation((IServer)this.server.getServer()).append("deploy").makeAbsolute();
            try {
                deployRoot.toFile();
                File temp = File.createTempFile(module.getName(), ".tmp", deployRoot.toFile());
                Path tempFile = new Path(temp.getAbsolutePath());
                list.addAll(Arrays.asList(PublishUtil.packModuleIntoJar((IModule)moduleTree[moduleTree.length - 1], (IPath)tempFile)));
                SSHPublisher.mkdirAndCopy(this.publishMethod.getSession(), tempFile.toString(), remoteDeployPath.toString());
            }
            catch (IOException ioe) {
                list.add((IStatus)new Status(4, "org.jboss.ide.eclipse.as.ssh", ioe.getMessage(), (Throwable)ioe));
            }
        }
        if (list.size() > 0) {
            return this.createMultiStatus(list, module);
        }
        return Status.OK_STATUS;
    }

    protected IStatus incrementalPublish(IModule[] moduleTree, IModule module, IProgressMonitor monitor) throws CoreException {
        IStatus[] results = new IStatus[]{};
        IPath remoteDeployPath = SSHPublisher.getDeployPath(moduleTree, this.server);
        if (!PublishUtil.deployPackaged((IModule[])moduleTree) && !PublishUtil.isBinaryObject((IModule[])moduleTree)) {
            SSHCopyCallback handler = new SSHCopyCallback(remoteDeployPath, this.publishMethod);
            results = new PublishCopyUtil((PublishCopyUtil.IPublishCopyCallbackHandler)handler).publishDelta(this.delta, monitor);
        } else if (this.delta.length > 0) {
            if (PublishUtil.isBinaryObject((IModule[])moduleTree)) {
                results = this.copyBinaryModule(moduleTree, monitor);
            } else {
                IPath localDeployRoot = JBossServerCorePlugin.getServerStateLocation((IServer)this.server.getServer()).append("deploy").makeAbsolute();
                try {
                    localDeployRoot.toFile();
                    File temp = File.createTempFile(module.getName(), ".tmp", localDeployRoot.toFile());
                    Path tempFile = new Path(temp.getAbsolutePath());
                    PublishUtil.packModuleIntoJar((IModule)moduleTree[moduleTree.length - 1], (IPath)tempFile);
                    SSHPublisher.mkdirAndCopy(this.publishMethod.getSession(), tempFile.toString(), remoteDeployPath.toString());
                }
                catch (IOException ioe) {
                    Status s = new Status(4, "org.jboss.ide.eclipse.as.ssh", ioe.getMessage(), (Throwable)ioe);
                    results = new IStatus[]{s};
                }
            }
        }
        if (results != null && results.length > 0) {
            MultiStatus ms = new MultiStatus("org.jboss.ide.eclipse.as.core", 0x2020004, NLS.bind((String)Messages.IncrementalPublishFail, (Object)module.getName()), null);
            int i = 0;
            while (i < results.length) {
                ms.add(results[i]);
                ++i;
            }
            return ms;
        }
        Status ret = new Status(0, "org.jboss.ide.eclipse.as.core", 0x2020001, NLS.bind((String)Messages.CountModifiedMembers, (Object)PublishUtil.countChanges((IModuleResourceDelta[])this.delta), (Object)module.getName()), null);
        return ret;
    }

    protected IStatus createMultiStatus(List<IStatus> list, IModule module) {
        MultiStatus ms = new MultiStatus("org.jboss.ide.eclipse.as.core", 0x2020002, NLS.bind((String)Messages.FullPublishFail, (Object)module.getName()), null);
        int i = 0;
        while (i < list.size()) {
            ms.add(list.get(i));
            ++i;
        }
        return ms;
    }

    protected IStatus[] copyBinaryModule(IModule[] moduleTree, IProgressMonitor monitor) {
        try {
            IPath remoteDeployPath = SSHPublisher.getDeployPath(moduleTree, this.server);
            IModuleResource[] members = PublishUtil.getResources((IModule[])moduleTree);
            File source = PublishUtil.getFile((IModuleResource)members[0]);
            if (source != null) {
                SSHZippedJSTPublisher.launchCopyCommand(this.publishMethod.getSession(), source.toString(), remoteDeployPath.toString(), monitor);
            }
        }
        catch (CoreException ce) {
            return new IStatus[]{ce.getStatus()};
        }
        return new IStatus[]{Status.OK_STATUS};
    }

    protected IStatus unpublish(IDeployableServer jbServer, IModule[] module, IProgressMonitor monitor) throws CoreException {
        IPath remotePath = SSHPublisher.getDeployPath(module, this.server);
        SSHZippedJSTPublisher.launchCommand(this.publishMethod.getSession(), "rm -rf " + remotePath.toString(), monitor);
        return Status.OK_STATUS;
    }

    public static IPath getDeployPath(IModule[] moduleTree, IDeployableServer server) {
        return PublishUtil.getDeployPath((IModule[])moduleTree, (String)SSHPublisher.getRemoteDeployFolder(server.getServer()));
    }

    public static String getRemoteDeployFolder(IServer server) {
        return ((Server)server).getAttribute("org.jboss.ide.eclipse.as.ssh.server.deployDirectory", null);
    }

    public static void mkdirAndCopy(Session session, String localFile, String remoteFile) throws CoreException {
        String parentFolder = new Path(remoteFile).removeLastSegments(1).toString();
        SSHZippedJSTPublisher.launchCommand(session, "mkdir -p " + parentFolder, (IProgressMonitor)new NullProgressMonitor());
        SSHZippedJSTPublisher.launchCopyCommand(session, localFile, remoteFile, (IProgressMonitor)new NullProgressMonitor());
    }

    public static class SSHCopyCallback
    implements PublishCopyUtil.IPublishCopyCallbackHandler {
        private IPath root;
        private SSHServerBehaviourDelegate.SSHPublishMethod method;

        public SSHCopyCallback(IPath deployRoot, SSHServerBehaviourDelegate.SSHPublishMethod method) {
            this.root = deployRoot;
            this.method = method;
        }

        public IStatus[] copyFile(IModuleFile mf, IPath path, IProgressMonitor monitor) throws CoreException {
            File sourceFile = PublishUtil.getFile((IModuleFile)mf);
            IPath destination = this.root.append(path);
            SSHPublisher.mkdirAndCopy(this.method.getSession(), sourceFile.getAbsolutePath(), destination.toString());
            return new IStatus[0];
        }

        public IStatus[] deleteResource(IPath path, IProgressMonitor monitor) {
            IPath remotePath = this.root.append(path);
            try {
                SSHZippedJSTPublisher.launchCommand(this.method.getSession(), "rm -rf " + remotePath.toString(), monitor);
            }
            catch (CoreException ce) {
                return new IStatus[]{ce.getStatus()};
            }
            return new IStatus[0];
        }

        public IStatus[] makeDirectoryIfRequired(IPath dir, IProgressMonitor monitor) {
            IPath remotePath = this.root.append(dir);
            try {
                SSHZippedJSTPublisher.launchCommand(this.method.getSession(), "mkdir -p " + remotePath.toString(), monitor);
            }
            catch (CoreException ce) {
                return new IStatus[]{ce.getStatus()};
            }
            return new IStatus[0];
        }
    }
}

