/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.ssh.server;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;
import org.jboss.ide.eclipse.as.core.publishers.LocalPublishMethod;
import org.jboss.ide.eclipse.as.core.server.IJBossServerPublishMethod;
import org.jboss.ide.eclipse.as.core.server.internal.DeployableServerBehavior;
import org.jboss.ide.eclipse.as.ssh.server.SSHPublishUtil;

public class SSHServerBehaviourDelegate
extends DeployableServerBehavior {
    public void stop(boolean force) {
        this.setServerState(4);
    }

    protected IJBossServerPublishMethod createPublishMethod() {
        return new SSHPublishMethod();
    }

    public class SSHPublishMethod
    extends LocalPublishMethod {
        public static final String SSH_PUBLISH_METHOD = "ssh";
        private Session session;

        public String getPublishMethodId() {
            return SSH_PUBLISH_METHOD;
        }

        public Session getSession() {
            return this.session;
        }

        public void publishStart(DeployableServerBehavior behaviour, IProgressMonitor monitor) throws CoreException {
            try {
                ServerUserInfo info = new ServerUserInfo(SSHServerBehaviourDelegate.this.getServer());
                JSch jsch = new JSch();
                this.session = jsch.getSession(info.getUser(), behaviour.getServer().getHost(), 22);
                jsch.setKnownHosts(info.getHostsFile());
                this.session.setUserInfo((UserInfo)info);
                this.session.connect();
            }
            catch (JSchException jsche) {
                throw new CoreException((IStatus)new Status(4, "org.jboss.ide.eclipse.as.ssh", "Remote Authentication Error", (Throwable)jsche));
            }
        }

        public int publishFinish(DeployableServerBehavior behaviour, IProgressMonitor monitor) throws CoreException {
            int ret = super.publishFinish(behaviour, monitor);
            if (this.session != null) {
                this.session.disconnect();
            }
            this.session = null;
            return ret;
        }
    }

    public static class ServerUserInfo
    implements UserInfo {
        private String user;
        private String password;
        private String hostsFile;

        public ServerUserInfo(IServer server) {
            IServer tmp = ServerCore.findServer((String)server.getId());
            SSHPublishUtil.getPass(tmp);
            this.user = SSHPublishUtil.getUser(server);
            this.password = SSHPublishUtil.getPass(server);
            this.hostsFile = SSHPublishUtil.getHostsFile(server);
        }

        public String getPassword() {
            return this.password;
        }

        public String getUser() {
            return this.user;
        }

        public String getHostsFile() {
            return this.hostsFile;
        }

        public String getPassphrase() {
            return null;
        }

        public boolean promptPassphrase(String message) {
            return true;
        }

        public boolean promptPassword(String message) {
            return true;
        }

        public void showMessage(String message) {
        }

        public boolean promptYesNo(String message) {
            return false;
        }
    }
}

