/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.ssh.server;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.model.IModuleResourceDelta;
import org.jboss.ide.eclipse.as.core.Messages;
import org.jboss.ide.eclipse.as.core.modules.SingleDeployableFactory;
import org.jboss.ide.eclipse.as.core.server.IDeployableServer;
import org.jboss.ide.eclipse.as.core.server.IJBossServerPublishMethod;
import org.jboss.ide.eclipse.as.core.server.IJBossServerPublisher;
import org.jboss.ide.eclipse.as.core.util.ServerConverter;
import org.jboss.ide.eclipse.as.ssh.server.SSHPublisher;
import org.jboss.ide.eclipse.as.ssh.server.SSHServerBehaviourDelegate;
import org.jboss.ide.eclipse.as.ssh.server.SSHZippedJSTPublisher;

public class SSHSingleFilePublisher
implements IJBossServerPublisher {
    private IDeployableServer server;
    private SSHServerBehaviourDelegate.SSHPublishMethod publishMethod;
    private int publishState = 1;

    public boolean accepts(String method, IServer server, IModule[] module) {
        if (!method.equals("ssh")) {
            return false;
        }
        if (module == null) {
            return true;
        }
        IDeployableServer ds = ServerConverter.getDeployableServer((IServer)server);
        boolean shouldAccept = ds != null && module.length == 1 && module[0].getModuleType().getId().equals("jboss.singlefile");
        return shouldAccept;
    }

    public int getPublishState() {
        return 1;
    }

    public IStatus publishModule(IJBossServerPublishMethod method, IServer server, IModule[] module, int publishType, IModuleResourceDelta[] delta, IProgressMonitor monitor) throws CoreException {
        this.server = ServerConverter.getDeployableServer((IServer)server);
        this.publishMethod = (SSHServerBehaviourDelegate.SSHPublishMethod)method;
        IModule module2 = module[0];
        IStatus status = null;
        if (publishType == 3) {
            status = this.unpublish(this.server, module2, monitor);
        } else if (publishType == 2 || publishType == 1) {
            status = this.publish(this.server, module2, monitor);
        }
        return status;
    }

    protected IStatus publish(IDeployableServer server, IModule module, IProgressMonitor monitor) {
        SingleDeployableFactory.SingleDeployableModuleDelegate delegate = (SingleDeployableFactory.SingleDeployableModuleDelegate)module.loadAdapter(SingleDeployableFactory.SingleDeployableModuleDelegate.class, (IProgressMonitor)new NullProgressMonitor());
        if (delegate != null) {
            IPath sourcePath = delegate.getGlobalSourcePath();
            String destFolder = SSHPublisher.getRemoteDeployFolder(server.getServer());
            IPath destFile = new Path(destFolder).append(sourcePath.lastSegment());
            try {
                SSHPublisher.mkdirAndCopy(this.publishMethod.getSession(), sourcePath.toOSString(), destFile.toString());
            }
            catch (CoreException ce) {
                return ce.getStatus();
            }
        } else {
            this.publishState = 0;
        }
        return Status.OK_STATUS;
    }

    protected IStatus unpublish(IDeployableServer server, IModule module, IProgressMonitor monitor) throws CoreException {
        SingleDeployableFactory.SingleDeployableModuleDelegate delegate = (SingleDeployableFactory.SingleDeployableModuleDelegate)module.loadAdapter(SingleDeployableFactory.SingleDeployableModuleDelegate.class, (IProgressMonitor)new NullProgressMonitor());
        if (delegate == null) {
            this.publishState = 0;
            Status status = new Status(2, "org.jboss.ide.eclipse.as.core", 33751058, NLS.bind((String)Messages.DeleteModuleFail, (Object)module.getName()), null);
            return status;
        }
        IPath sourcePath = delegate.getGlobalSourcePath();
        String destFolder = SSHPublisher.getRemoteDeployFolder(server.getServer());
        IPath destFile = new Path(destFolder).append(sourcePath.lastSegment());
        SSHZippedJSTPublisher.launchCommand(this.publishMethod.getSession(), "rm -rf " + destFile.toString(), monitor);
        Status status = new Status(0, "org.jboss.ide.eclipse.as.core", 0x2030003, NLS.bind((String)Messages.ModuleDeleted, (Object)module.getName()), null);
        return status;
    }
}

