/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.ssh.server;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.common.componentcore.ModuleCoreNature;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.internal.Server;
import org.eclipse.wst.server.core.model.IModuleResourceDelta;
import org.jboss.ide.eclipse.archives.webtools.modules.LocalZippedPublisherUtil;
import org.jboss.ide.eclipse.as.core.JBossServerCorePlugin;
import org.jboss.ide.eclipse.as.core.server.IDeployableServer;
import org.jboss.ide.eclipse.as.core.server.IJBossServerPublishMethod;
import org.jboss.ide.eclipse.as.core.server.IJBossServerPublisher;
import org.jboss.ide.eclipse.as.core.util.ServerConverter;
import org.jboss.ide.eclipse.as.ssh.server.SSHPublishUtil;
import org.jboss.ide.eclipse.as.ssh.server.SSHServerBehaviourDelegate;

public class SSHZippedJSTPublisher
implements IJBossServerPublisher {
    public boolean accepts(String method, IServer server, IModule[] module) {
        if (!method.equals("ssh")) {
            return false;
        }
        if (module == null) {
            return true;
        }
        IDeployableServer ds = ServerConverter.getDeployableServer((IServer)server);
        boolean shouldAccept = ds != null && ModuleCoreNature.isFlexibleProject((IProject)module[0].getProject()) && SSHPublishUtil.getZipsSSHDeployments(server);
        return shouldAccept;
    }

    public int getPublishState() {
        return 1;
    }

    public IStatus publishModule(IJBossServerPublishMethod method, IServer server, IModule[] module, int publishType, IModuleResourceDelta[] delta, IProgressMonitor monitor) throws CoreException {
        SSHServerBehaviourDelegate.SSHPublishMethod method2 = (SSHServerBehaviourDelegate.SSHPublishMethod)method;
        IPath deployRoot = JBossServerCorePlugin.getServerStateLocation((IServer)server).append("deploy").makeAbsolute();
        LocalZippedPublisherUtil localDelegate = new LocalZippedPublisherUtil();
        localDelegate.publishModule(server, deployRoot.toOSString(), module, publishType, delta, monitor);
        IPath outputFilepath = localDelegate.getOutputFilePath(module);
        String deployFolder = this.getRemoteDeployFolder(server);
        String deployFile = new Path(deployFolder).append(outputFilepath.lastSegment()).toString();
        if (publishType == 3) {
            SSHZippedJSTPublisher.launchRemoveCommand(method2.getSession(), deployFile, monitor);
        } else {
            SSHZippedJSTPublisher.launchCopyCommand(method2.getSession(), outputFilepath.toString(), deployFile, monitor);
        }
        return null;
    }

    protected String getRemoteDeployFolder(IServer server) {
        return ((Server)server).getAttribute("org.jboss.ide.eclipse.as.ssh.server.deployDirectory", null);
    }

    public static void launchRemoveCommand(Session session, String remoteLocation, IProgressMonitor monitor) throws CoreException {
        String command = "rm " + remoteLocation;
        SSHZippedJSTPublisher.launchCommand(session, command, monitor);
    }

    public static void launchCommand(Session session, String command, IProgressMonitor monitor) throws CoreException {
        SSHZippedJSTPublisher.launchThreadedCommand(session, command, monitor);
    }

    protected static void launchThreadedCommand(final Session session, final String command, final IProgressMonitor monitor) throws CoreException {
        LaunchRunnable r = new LaunchRunnable(){

            public void run() throws CoreException {
                SSHZippedJSTPublisher.launchCommandNoThread(session, command, monitor);
            }
        };
        SSHZippedJSTPublisher.launchThreadedCommand(r, monitor);
    }

    protected static void launchCommandNoThread(Session session, String command, IProgressMonitor monitor) throws CoreException {
        Channel channel = null;
        try {
            try {
                channel = session.openChannel("exec");
                ((ChannelExec)channel).setCommand(command);
                channel.connect();
                while (!channel.isClosed()) {
                    try {
                        Thread.sleep(300L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            catch (JSchException jSchException) {
                throw new CoreException((IStatus)new Status(4, "org.jboss.ide.eclipse.as.ssh", 0x2008000, "Error executing command: " + command, null));
            }
        }
        finally {
            channel.disconnect();
        }
    }

    public static void launchCopyCommand(final Session session, final String localFile, final String remoteFile, final IProgressMonitor monitor) throws CoreException {
        LaunchRunnable r = new LaunchRunnable(){

            public void run() throws CoreException {
                SSHZippedJSTPublisher.launchCopyCommandImpl(session, localFile, remoteFile, monitor);
            }
        };
        SSHZippedJSTPublisher.launchThreadedCommand(r, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void launchThreadedCommand(final LaunchRunnable runnable, IProgressMonitor monitor) throws CoreException {
        Object object;
        final Exception[] e = new Exception[]{null};
        final Object waitObject = new Object();
        final Boolean[] subtaskComplete = new Boolean[]{new Boolean(false)};
        Thread t = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Exception exception = null;
                try {
                    runnable.run();
                }
                catch (Exception ex) {
                    exception = ex;
                }
                Object object = waitObject;
                synchronized (object) {
                    e[0] = exception;
                    subtaskComplete[0] = new Boolean(true);
                    waitObject.notifyAll();
                }
            }
        };
        t.start();
        while (t.isAlive() && !monitor.isCanceled()) {
            object = waitObject;
            synchronized (object) {
                if (subtaskComplete[0].booleanValue()) {
                    break;
                }
                try {
                    waitObject.wait(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        object = waitObject;
        synchronized (object) {
            if (!subtaskComplete[0].booleanValue()) {
                t.interrupt();
                Status status = new Status(2, "org.jboss.ide.eclipse.as.core", 0x60000000, "SSH command canceled", (Throwable)e[0]);
                CoreException ce = new CoreException((IStatus)status);
                throw ce;
            }
            if (e[0] != null) {
                Status status = new Status(4, "org.jboss.ide.eclipse.as.core", 0x60000000, "Error running remote command", (Throwable)e[0]);
                CoreException ce = new CoreException((IStatus)status);
                throw ce;
            }
        }
    }

    protected static void launchCopyCommandImpl(Session session, String localFile, String remoteFile, IProgressMonitor monitor) throws CoreException {
        Channel channel = null;
        OutputStream out = null;
        try {
            try {
                int len;
                String command = "scp -p -t " + remoteFile;
                channel = session.openChannel("exec");
                ((ChannelExec)channel).setCommand(command);
                out = channel.getOutputStream();
                InputStream in = channel.getInputStream();
                channel.connect();
                if (SSHZippedJSTPublisher.checkAck(in) != 0) {
                    throw new CoreException((IStatus)new Status(4, "org.jboss.ide.eclipse.as.ssh", 0x2008000, "Error transfering file: " + localFile, null));
                }
                long filesize = new File(localFile).length();
                command = "C0644 " + filesize + " ";
                command = localFile.lastIndexOf(47) > 0 ? String.valueOf(command) + localFile.substring(localFile.lastIndexOf(47) + 1) : String.valueOf(command) + localFile;
                command = String.valueOf(command) + "\n";
                out.write(command.getBytes());
                out.flush();
                if (SSHZippedJSTPublisher.checkAck(in) != 0) {
                    throw new CoreException((IStatus)new Status(4, "org.jboss.ide.eclipse.as.ssh", 0x2008000, "Error transfering file: " + localFile, null));
                }
                FileInputStream fis = new FileInputStream(localFile);
                byte[] buf = new byte[1024];
                while ((len = fis.read(buf, 0, buf.length)) > 0) {
                    out.write(buf, 0, len);
                }
                fis.close();
                fis = null;
                buf[0] = 0;
                out.write(buf, 0, 1);
                out.flush();
                if (SSHZippedJSTPublisher.checkAck(in) != 0) {
                    throw new CoreException((IStatus)new Status(4, "org.jboss.ide.eclipse.as.ssh", 0x2008000, "Error transfering file: " + localFile, null));
                }
            }
            catch (JSchException jsche) {
                throw new CoreException((IStatus)new Status(4, "org.jboss.ide.eclipse.as.ssh", 0x2008000, "Error transfering file: " + localFile, (Throwable)jsche));
            }
            catch (IOException ioe) {
                throw new CoreException((IStatus)new Status(4, "org.jboss.ide.eclipse.as.ssh", 0x2008000, "Error transfering file: " + localFile, (Throwable)ioe));
            }
        }
        catch (Throwable throwable) {
            if (channel != null) {
                channel.disconnect();
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (channel != null) {
            channel.disconnect();
        }
        if (out != null) {
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
    }

    static int checkAck(InputStream in) throws IOException {
        int b = in.read();
        if (b == 0) {
            return b;
        }
        if (b == -1) {
            return b;
        }
        if (b == 1 || b == 2) {
            int c;
            StringBuffer sb = new StringBuffer();
            do {
                c = in.read();
                sb.append((char)c);
            } while (c != 10);
        }
        return b;
    }

    public static class LaunchRunnable {
        public void run() throws CoreException {
        }
    }
}

