/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.ssh.ui.editor;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.wst.server.ui.internal.command.ServerCommand;
import org.jboss.ide.eclipse.as.core.ExtensionManager;
import org.jboss.ide.eclipse.as.core.server.IDeployableServer;
import org.jboss.ide.eclipse.as.core.server.IJBossServerPublisher;
import org.jboss.ide.eclipse.as.core.server.internal.ServerAttributeHelper;
import org.jboss.ide.eclipse.as.core.util.DeploymentPreferenceLoader;
import org.jboss.ide.eclipse.as.ssh.Messages;
import org.jboss.ide.eclipse.as.ssh.server.SSHPublishUtil;
import org.jboss.ide.eclipse.as.ui.editor.IDeploymentEditorTab;
import org.jboss.ide.eclipse.as.ui.editor.ModuleDeploymentPage;

public class SSHDeploymentModuleTab
implements IDeploymentEditorTab {
    private ModuleDeploymentPage page;
    private Text userText;
    private Text passText;
    private Text deployText;
    private Text hostsFileText;
    private ModifyListener userListener;
    private ModifyListener passListener;
    private ModifyListener deployListener;
    private ModifyListener hostsListener;
    private Button zipDeployWTPProjects;
    private Button browseHostsFileButton;
    private SelectionListener zipListener;
    private SelectionListener browseHostsButtonListener;

    public String getTabName() {
        return Messages.SCPDeploymentSectionTitle;
    }

    public void setDeploymentPage(ModuleDeploymentPage page) {
        this.page = page;
    }

    public void setDeploymentPrefs(DeploymentPreferenceLoader.DeploymentPreferences prefs) {
    }

    public Control createControl(Composite parent) {
        Composite random = new Composite(parent, 0);
        GridData randomData = new GridData(1808);
        random.setLayoutData((Object)randomData);
        random.setLayout((Layout)new FormLayout());
        Composite defaultComposite = this.createDefaultComposite(random);
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 5);
        fd.top = new FormAttachment(0, 5);
        fd.right = new FormAttachment(100, -5);
        defaultComposite.setLayoutData((Object)fd);
        return random;
    }

    protected Composite createDefaultComposite(Composite parent) {
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        Section section = toolkit.createSection(parent, 322);
        section.setText(Messages.SCPDeploymentSectionTitle);
        section.setLayoutData((Object)new GridData(784));
        Composite composite = toolkit.createComposite((Composite)section);
        composite.setLayout((Layout)new FormLayout());
        Label descriptionLabel = toolkit.createLabel(composite, Messages.SCPDeploymentDescription);
        FormData descriptionLabelData = new FormData();
        descriptionLabelData.left = new FormAttachment(0, 5);
        descriptionLabelData.top = new FormAttachment(0, 5);
        descriptionLabel.setLayoutData((Object)descriptionLabelData);
        Label top = descriptionLabel;
        Composite inner = toolkit.createComposite(composite);
        inner.setLayout((Layout)new GridLayout(3, false));
        FormData innerData = new FormData();
        innerData.top = new FormAttachment((Control)descriptionLabel, 5);
        innerData.left = new FormAttachment(0, 5);
        innerData.right = new FormAttachment(100, -5);
        inner.setLayoutData((Object)innerData);
        top = inner;
        GridData textData = new GridData(16384, 0x1000000, true, false, 2, 1);
        textData.widthHint = 300;
        Label label = toolkit.createLabel(inner, Messages.DeployRootFolder);
        label.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        this.deployText = toolkit.createText(inner, SSHPublishUtil.getDeployDir(this.page.getServer().getOriginal()), 2048);
        this.deployListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SSHDeploymentModuleTab.this.page.execute((ServerCommand)new SetDeployDirCommand());
            }
        };
        this.deployText.addModifyListener(this.deployListener);
        this.deployText.setEnabled(true);
        this.deployText.setLayoutData((Object)textData);
        Label userLabel = toolkit.createLabel(inner, Messages.UserLabel);
        userLabel.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        this.userText = toolkit.createText(inner, SSHPublishUtil.getUser(this.page.getServer().getOriginal()), 2048);
        this.userListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SSHDeploymentModuleTab.this.page.execute((ServerCommand)new SetUserCommand());
            }
        };
        this.userText.addModifyListener(this.userListener);
        this.userText.setEnabled(true);
        this.userText.setLayoutData((Object)textData);
        Label passLabel = toolkit.createLabel(inner, Messages.PassLabel);
        passLabel.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        this.passText = toolkit.createText(inner, SSHPublishUtil.getPass(this.page.getServer().getOriginal()), 2048);
        this.passListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SSHDeploymentModuleTab.this.page.execute((ServerCommand)new SetPasswordCommand());
            }
        };
        this.passText.addModifyListener(this.passListener);
        this.passText.setEnabled(true);
        this.passText.setLayoutData((Object)textData);
        Label hostsLabel = toolkit.createLabel(inner, Messages.HostsLabel);
        hostsLabel.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        Composite hostsFileComposite = new Composite(inner, 0);
        hostsFileComposite.setLayoutData((Object)textData);
        hostsFileComposite.setLayout((Layout)new GridLayout(2, false));
        this.hostsFileText = toolkit.createText(hostsFileComposite, SSHPublishUtil.getHostsFile(this.page.getServer().getOriginal()), 2048);
        this.hostsListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SSHDeploymentModuleTab.this.page.execute((ServerCommand)new SetHostsFileCommand());
            }
        };
        this.hostsFileText.addModifyListener(this.hostsListener);
        this.hostsFileText.setEnabled(true);
        GridData hostsFileData = new GridData(16384, 0x1000000, true, false);
        hostsFileData.widthHint = 200;
        hostsFileData.grabExcessHorizontalSpace = true;
        this.hostsFileText.setLayoutData((Object)hostsFileData);
        this.browseHostsFileButton = toolkit.createButton(hostsFileComposite, Messages.browse, 8);
        this.browseHostsButtonListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SSHDeploymentModuleTab.this.browseForHostsSelected();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        this.browseHostsFileButton.addSelectionListener(this.browseHostsButtonListener);
        this.zipDeployWTPProjects = toolkit.createButton(composite, Messages.EditorZipDeployments, 32);
        boolean zippedPublisherAvailable = this.isSSHZippedPublisherAvailable();
        boolean value = this.getZipsSSHDeployments();
        this.zipDeployWTPProjects.setEnabled(zippedPublisherAvailable);
        this.zipDeployWTPProjects.setSelection(zippedPublisherAvailable && value);
        FormData zipButtonData = new FormData();
        zipButtonData.right = new FormAttachment(100, -5);
        zipButtonData.left = new FormAttachment(0, 5);
        zipButtonData.top = new FormAttachment((Control)top, 5);
        this.zipDeployWTPProjects.setLayoutData((Object)zipButtonData);
        this.zipListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SSHDeploymentModuleTab.this.page.execute((ServerCommand)new SetZipCommand());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        };
        this.zipDeployWTPProjects.addSelectionListener(this.zipListener);
        toolkit.paintBordersFor(composite);
        section.setClient((Control)composite);
        this.page.getSaveStatus();
        return section;
    }

    protected boolean isSSHZippedPublisherAvailable() {
        IJBossServerPublisher[] publishers = ExtensionManager.getDefault().getZippedPublishers();
        int i = 0;
        while (i < publishers.length) {
            if (publishers[i].accepts("ssh", this.getServer().getServer(), null)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void browseForHostsSelected() {
        FileDialog d = new FileDialog(new Shell());
        d.setFilterPath(this.page.makeGlobal(this.hostsFileText.getText()));
        String x = d.open();
        if (x != null) {
            this.hostsFileText.setText(x);
        }
    }

    protected ServerAttributeHelper getHelper() {
        return new ServerAttributeHelper(this.page.getServer().getOriginal(), this.page.getServer());
    }

    private boolean getZipsSSHDeployments() {
        return this.getHelper().getAttribute("org.jboss.ide.eclipse.as.ssh.server.zipDeploymentsPreference", false);
    }

    private IDeployableServer getServer() {
        return (IDeployableServer)this.page.getServer().loadAdapter(IDeployableServer.class, (IProgressMonitor)new NullProgressMonitor());
    }

    public class SetDeployDirCommand
    extends SetPropertyCommand {
        public SetDeployDirCommand() {
            super(Messages.EditorSetDeployCommandLabel, SSHDeploymentModuleTab.this.deployText, SSHDeploymentModuleTab.this.deployListener, "org.jboss.ide.eclipse.as.ssh.server.deployDirectory");
        }
    }

    public class SetHostsFileCommand
    extends SetPropertyCommand {
        public SetHostsFileCommand() {
            super(Messages.EditorSetPasswordCommandLabel, SSHDeploymentModuleTab.this.hostsFileText, SSHDeploymentModuleTab.this.hostsListener, "org.jboss.ide.eclipse.as.ssh.server.hostsFile");
        }
    }

    public class SetPasswordCommand
    extends SetPropertyCommand {
        public SetPasswordCommand() {
            super(Messages.EditorSetPasswordCommandLabel, SSHDeploymentModuleTab.this.passText, SSHDeploymentModuleTab.this.passListener, "org.jboss.ide.eclipse.as.ssh.server.password");
        }
    }

    public class SetPropertyCommand
    extends ServerCommand {
        protected String oldDir;
        protected String newDir;
        protected Text text;
        protected ModifyListener listener;
        protected String attribute;

        public SetPropertyCommand(String label, Text text, ModifyListener listener, String attribute) {
            super(SSHDeploymentModuleTab.this.page.getServer(), label);
            this.text = text;
            this.newDir = text.getText();
            this.listener = listener;
            this.attribute = attribute;
            this.oldDir = SSHDeploymentModuleTab.this.getHelper().getAttribute(attribute, "");
        }

        public void execute() {
            SSHDeploymentModuleTab.this.getHelper().setAttribute(this.attribute, this.newDir);
            SSHDeploymentModuleTab.this.page.getSaveStatus();
        }

        public void undo() {
            this.text.removeModifyListener(this.listener);
            SSHDeploymentModuleTab.this.getHelper().setAttribute(this.attribute, this.oldDir);
            this.text.setText(this.oldDir);
            this.text.addModifyListener(this.listener);
            SSHDeploymentModuleTab.this.page.getSaveStatus();
        }
    }

    public class SetUserCommand
    extends SetPropertyCommand {
        public SetUserCommand() {
            super(Messages.EditorSetUserCommandLabel, SSHDeploymentModuleTab.this.userText, SSHDeploymentModuleTab.this.userListener, "org.jboss.ide.eclipse.as.ssh.server.username");
        }
    }

    public class SetZipCommand
    extends ServerCommand {
        boolean oldVal;
        boolean newVal;

        public SetZipCommand() {
            super(SSHDeploymentModuleTab.this.page.getServer(), Messages.EditorZipDeployments);
            this.oldVal = SSHDeploymentModuleTab.this.getHelper().getAttribute("org.jboss.ide.eclipse.as.ssh.server.zipDeploymentsPreference", false);
            this.newVal = SSHDeploymentModuleTab.this.zipDeployWTPProjects.getSelection();
        }

        public void execute() {
            SSHDeploymentModuleTab.this.getHelper().setAttribute("org.jboss.ide.eclipse.as.ssh.server.zipDeploymentsPreference", this.newVal);
            SSHDeploymentModuleTab.this.page.getSaveStatus();
        }

        public void undo() {
            SSHDeploymentModuleTab.this.zipDeployWTPProjects.removeSelectionListener(SSHDeploymentModuleTab.this.zipListener);
            SSHDeploymentModuleTab.this.zipDeployWTPProjects.setSelection(this.oldVal);
            SSHDeploymentModuleTab.this.getHelper().setAttribute("org.jboss.ide.eclipse.as.ssh.server.zipDeploymentsPreference", this.oldVal);
            SSHDeploymentModuleTab.this.zipDeployWTPProjects.addSelectionListener(SSHDeploymentModuleTab.this.zipListener);
            SSHDeploymentModuleTab.this.page.getSaveStatus();
        }
    }
}

