/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.ssh.ui.wizard;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.ui.internal.ImageResource;
import org.eclipse.wst.server.ui.wizard.IWizardHandle;
import org.eclipse.wst.server.ui.wizard.WizardFragment;
import org.jboss.ide.eclipse.as.ssh.Messages;
import org.jboss.ide.eclipse.as.ssh.server.SSHServerDelegate;

public class SCPServerWizardFragment
extends WizardFragment {
    private IWizardHandle handle;
    private Text userText;
    private Text passText;
    private Text deployText;
    private ModifyListener listener;
    private SelectionListener browseHostsButtonListener;
    private String user;
    private String pass;
    private String deploy;

    public Composite createComposite(Composite parent, IWizardHandle handle) {
        this.handle = handle;
        handle.setDescription(Messages.SCPServerDescription);
        handle.setImageDescriptor(ImageResource.getImageDescriptor((String)"newServerWiz"));
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)new FormLayout());
        this.addWidgets(main);
        this.validate();
        return main;
    }

    protected void addWidgets(Composite composite) {
        composite.setLayout((Layout)new FormLayout());
        Composite inner = new Composite(composite, 0);
        inner.setLayout((Layout)new GridLayout(3, false));
        FormData innerData = new FormData();
        innerData.top = new FormAttachment(0, 5);
        innerData.left = new FormAttachment(0, 5);
        innerData.right = new FormAttachment(100, -5);
        inner.setLayoutData((Object)innerData);
        GridData textData = new GridData(16384, 0x1000000, true, false, 2, 1);
        textData.widthHint = 300;
        Label label = new Label(inner, 0);
        label.setText(Messages.DeployRootFolder);
        this.deployText = new Text(inner, 2048);
        this.deployText.setText("/home/rob/deployFolder");
        this.listener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SCPServerWizardFragment.this.updateValues();
            }
        };
        this.deployText.addModifyListener(this.listener);
        this.deployText.setEnabled(true);
        this.deployText.setLayoutData((Object)textData);
        Label userLabel = new Label(inner, 0);
        userLabel.setText(Messages.UserLabel);
        this.userText = new Text(inner, 2048);
        this.userText.setText("username");
        this.userText.addModifyListener(this.listener);
        this.userText.setEnabled(true);
        this.userText.setLayoutData((Object)textData);
        Label passLabel = new Label(inner, 0);
        passLabel.setText(Messages.PassLabel);
        this.passText = new Text(inner, 2048);
        this.passText.setText("password");
        this.passText.addModifyListener(this.listener);
        this.passText.setEnabled(true);
        this.passText.setLayoutData((Object)textData);
    }

    protected void updateValues() {
        this.user = this.userText.getText();
        this.pass = this.passText.getText();
        this.deploy = this.deployText.getText();
        this.validate();
    }

    public void enter() {
    }

    public void exit() {
    }

    public boolean hasComposite() {
        return true;
    }

    protected void validate() {
        this.handle.setMessage(null, 0);
        this.handle.update();
    }

    public boolean isComplete() {
        return this.handle.getMessageType() == 0;
    }

    public void performFinish(IProgressMonitor monitor) throws CoreException {
        IServerWorkingCopy serverWC = (IServerWorkingCopy)this.getTaskModel().getObject("server");
        SSHServerDelegate server = (SSHServerDelegate)((Object)serverWC.loadAdapter(SSHServerDelegate.class, (IProgressMonitor)new NullProgressMonitor()));
        server.setUsername(this.user);
        server.setPassword(this.pass);
        server.setHostsFile(null);
        server.setDeployFolder(this.deploy);
    }
}

