/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.birt.oda.impl;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.List;
import org.eclipse.datatools.connectivity.oda.IParameterMetaData;
import org.eclipse.datatools.connectivity.oda.IQuery;
import org.eclipse.datatools.connectivity.oda.IResultSet;
import org.eclipse.datatools.connectivity.oda.IResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.SortSpec;
import org.eclipse.datatools.connectivity.oda.spec.QuerySpecification;
import org.hibernate.Session;
import org.jboss.tools.birt.oda.impl.HibernateConnection;
import org.jboss.tools.birt.oda.impl.HibernateParameterMetaData;
import org.jboss.tools.birt.oda.impl.HibernateResultSet;
import org.jboss.tools.birt.oda.impl.HibernateResultSetMetaData;
import org.jboss.tools.birt.oda.impl.Parameter;

public class HibernateOdaQuery
implements IQuery {
    private HibernateConnection connection;
    private HibernateResultSetMetaData resultSetMetaData;
    private HibernateParameterMetaData parameterMetaData = new HibernateParameterMetaData();
    private Session session;

    public HibernateOdaQuery(HibernateConnection connection) {
        this.connection = connection;
        this.session = connection.getSession();
    }

    public void prepare(String queryText) throws OdaException {
        this.resultSetMetaData = this.getConnection().getOdaSessionFactory().prepare(queryText, this.session);
    }

    public void setAppContext(Object context) throws OdaException {
    }

    public void close() throws OdaException {
    }

    public IResultSetMetaData getMetaData() throws OdaException {
        return this.resultSetMetaData;
    }

    public IResultSet executeQuery() throws OdaException {
        try {
            return new HibernateResultSet(this);
        }
        catch (Exception e) {
            throw new OdaException(e.getLocalizedMessage());
        }
    }

    public void setProperty(String name, String value) throws OdaException {
    }

    public void setMaxRows(int max) throws OdaException {
        this.getConnection().getOdaSessionFactory().setMaxRows(max);
    }

    public int getMaxRows() throws OdaException {
        return this.getConnection().getOdaSessionFactory().getMaxRows();
    }

    public void clearInParameters() throws OdaException {
        this.parameterMetaData.getParameters().clear();
    }

    public void setInt(String parameterName, int value) throws OdaException {
        this.setParameter(parameterName, Parameter.IntegerType, (Object)value);
    }

    private void setParameter(String parameterName, int type, Object value) {
        Parameter parameter = this.getParameter(parameterName);
        if (parameter == null) {
            parameter = new Parameter(type, parameterName, value);
            this.parameterMetaData.getParameters().add(parameter);
        } else {
            parameter.setValue(value);
            parameter.setType(type);
        }
    }

    private Parameter getParameter(String parameterName) {
        if (parameterName == null) {
            return null;
        }
        List<Parameter> parameters = this.parameterMetaData.getParameters();
        for (Parameter parameter : parameters) {
            if (!parameterName.equals(parameter.getName())) continue;
            return parameter;
        }
        return null;
    }

    public void setInt(int parameterId, int value) throws OdaException {
        this.setParameter(parameterId, Parameter.IntegerType, (Object)value);
    }

    private void setParameter(int parameterId, int type, Object value) {
        List<Parameter> parameters = this.parameterMetaData.getParameters();
        String parameterName = "parameter" + parameterId;
        if (parameters.size() < parameterId) {
            Parameter parameter = new Parameter(type, parameterName, value);
            this.parameterMetaData.getParameters().add(parameter);
        } else {
            Parameter parameter = this.parameterMetaData.getParameters().get(parameterId - 1);
            parameter.setValue(value);
            parameter.setType(type);
        }
    }

    public void setDouble(String parameterName, double value) throws OdaException {
        this.setParameter(parameterName, Parameter.DoubleType, (Object)new Double(value));
    }

    public void setDouble(int parameterId, double value) throws OdaException {
        this.setParameter(parameterId, Parameter.DoubleType, (Object)new Double(value));
    }

    public void setBigDecimal(String parameterName, BigDecimal value) throws OdaException {
        this.setParameter(parameterName, Parameter.BigDecimalType, (Object)value);
    }

    public void setBigDecimal(int parameterId, BigDecimal value) throws OdaException {
        this.setParameter(parameterId, Parameter.BigDecimalType, (Object)value);
    }

    public void setString(String parameterName, String value) throws OdaException {
        this.setParameter(parameterName, Parameter.StringType, (Object)value);
    }

    public void setString(int parameterId, String value) throws OdaException {
        this.setParameter(parameterId, Parameter.StringType, (Object)value);
    }

    public void setDate(String parameterName, Date value) throws OdaException {
        this.setParameter(parameterName, Parameter.DateType, (Object)value);
    }

    public void setDate(int parameterId, Date value) throws OdaException {
        this.setParameter(parameterId, Parameter.DateType, (Object)value);
    }

    public void setTime(String parameterName, Time value) throws OdaException {
        this.setParameter(parameterName, Parameter.TimeType, (Object)value);
    }

    public void setTime(int parameterId, Time value) throws OdaException {
        this.setParameter(parameterId, Parameter.TimeType, (Object)value);
    }

    public void setTimestamp(String parameterName, Timestamp value) throws OdaException {
        this.setParameter(parameterName, Parameter.TimestampType, (Object)value);
    }

    public void setTimestamp(int parameterId, Timestamp value) throws OdaException {
        this.setParameter(parameterId, Parameter.TimestampType, (Object)value);
    }

    public void setBoolean(String parameterName, boolean value) throws OdaException {
        this.setParameter(parameterName, Parameter.BooleanType, (Object)new Boolean(value));
    }

    public void setBoolean(int parameterId, boolean value) throws OdaException {
        this.setParameter(parameterId, Parameter.BooleanType, (Object)new Boolean(value));
    }

    public void setNull(String parameterName) throws OdaException {
        Parameter parameter = this.getParameter(parameterName);
        if (parameter != null) {
            parameter.setValue(null);
        }
    }

    public void setNull(int parameterId) throws OdaException {
        Parameter parameter = this.parameterMetaData.getParameters().get(parameterId);
        if (parameter != null) {
            parameter.setValue(null);
        }
    }

    public int findInParameter(String parameterName) throws OdaException {
        if (parameterName == null) {
            return 0;
        }
        for (Parameter parameter : this.parameterMetaData.getParameters()) {
            if (!parameterName.equals(parameter.getName())) continue;
            return this.parameterMetaData.getParameters().indexOf(parameter);
        }
        return 0;
    }

    public IParameterMetaData getParameterMetaData() throws OdaException {
        return this.parameterMetaData;
    }

    public void setSortSpec(SortSpec sortBy) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public SortSpec getSortSpec() throws OdaException {
        return null;
    }

    public HibernateConnection getConnection() {
        return this.connection;
    }

    public void cancel() throws OdaException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public String getEffectiveQueryText() {
        return null;
    }

    public QuerySpecification getSpecification() {
        return null;
    }

    public void setObject(String parameterName, Object value) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void setObject(int parameterId, Object value) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void setSpecification(QuerySpecification querySpec) throws OdaException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }
}

