/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.birt.oda.ui.impl;

import java.util.Properties;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.hibernate.HibernateException;
import org.hibernate.SessionFactory;
import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.console.KnownConfigurations;
import org.jboss.tools.birt.oda.ui.Activator;
import org.jboss.tools.birt.oda.ui.Messages;

public class HibernateSelectionPageHelper {
    private static final String DEFAULT_MAX_ROWS = "100";
    private WizardPage wizardPage;
    private PreferencePage propertyPage;
    private Combo configurationCombo;
    private Text jndiSessionFactoryName;
    private Text maxRows;
    private Button testButton;

    public HibernateSelectionPageHelper(WizardPage page) {
        this.wizardPage = page;
    }

    public HibernateSelectionPageHelper(PreferencePage page) {
        this.propertyPage = page;
    }

    void createCustomControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.verticalSpacing = 10;
        layout.marginBottom = 10;
        composite.setLayout((Layout)layout);
        Label configurationLabel = new Label(composite, 131072);
        configurationLabel.setText(Messages.HibernateSelectionPageHelper_Configuration);
        this.configurationCombo = new Combo(composite, 0);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.configurationCombo.setLayoutData((Object)gridData);
        Label jndiLabel = new Label(composite, 131072);
        jndiLabel.setText(Messages.HibernateSelectionPageHelper_JNDI_URL);
        this.jndiSessionFactoryName = new Text(composite, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.jndiSessionFactoryName.setLayoutData((Object)gridData);
        ConsoleConfiguration[] configurations = KnownConfigurations.getInstance().getConfigurations();
        String[] configurationNames = new String[configurations.length];
        int i = 0;
        while (i < configurations.length) {
            configurationNames[i] = configurations[i].getName();
            ++i;
        }
        this.configurationCombo.setItems(configurationNames);
        Label maxFetchLabel = new Label(composite, 0);
        maxFetchLabel.setText(Messages.HibernateSelectionPageHelper_Max_results);
        this.maxRows = new Text(composite, 2048);
        this.maxRows.setLayoutData((Object)gridData);
        this.configurationCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                HibernateSelectionPageHelper.this.validateData();
                HibernateSelectionPageHelper.this.adjustJndiName();
            }
        });
        this.adjustJndiName();
        new Label(composite, 0);
        this.testButton = new Button(composite, 8);
        this.testButton.setText(Messages.HibernateSelectionPageHelper_Test_connection);
        this.testButton.setLayoutData((Object)new GridData(2));
        this.testButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HibernateSelectionPageHelper.this.testConnection();
            }
        });
        this.validateData();
    }

    private void adjustJndiName() {
        String configurationName;
        String jndiName = this.jndiSessionFactoryName.getText();
        if ((jndiName == null || jndiName.length() <= 0) && (configurationName = this.configurationCombo.getText()) != null && configurationName.length() > 0) {
            int index = configurationName.indexOf("-ejb");
            if (index > 0) {
                configurationName = configurationName.substring(0, index);
            }
            this.jndiSessionFactoryName.setText("java:/" + configurationName);
        }
    }

    private void setMessage(String message, int type) {
        if (this.wizardPage != null) {
            this.wizardPage.setMessage(message, type);
        } else if (this.propertyPage != null) {
            this.propertyPage.setMessage(message, type);
        }
    }

    private void setMessage(String message) {
        if (this.wizardPage != null) {
            this.wizardPage.setMessage(message);
        } else if (this.propertyPage != null) {
            this.propertyPage.setMessage(message);
        }
    }

    private void validateData() {
        if (this.configurationCombo.getText().trim().length() > 0) {
            this.setMessage(Messages.HibernateSelectionPageHelper_Edit_the_selected_data_source);
            this.testButton.setEnabled(true);
            this.setPageComplete(true);
        } else {
            this.setMessage(Messages.HibernateSelectionPageHelper_Configuration_must_not_be_empty, 3);
            this.testButton.setEnabled(false);
            this.setPageComplete(false);
        }
    }

    public void initCustomControl(Properties profileProps) {
        if (profileProps != null) {
            String confName = profileProps.getProperty("configuration");
            if (confName != null) {
                this.configurationCombo.setText(confName);
            }
            String maxResult = profileProps.getProperty("maxRows");
            this.maxRows.setText(maxResult);
        } else {
            if (this.configurationCombo.getItemCount() > 0) {
                this.configurationCombo.select(0);
            }
            this.maxRows.setText(DEFAULT_MAX_ROWS);
        }
    }

    protected void testConnection() {
        String configurationName = this.configurationCombo.getText();
        ConsoleConfiguration[] configurations = KnownConfigurations.getInstance().getConfigurations();
        ConsoleConfiguration consoleConfiguration = null;
        String title = Messages.HibernateSelectionPageHelper_Test_connection1;
        int i = 0;
        while (i < configurations.length) {
            if (configurations[i].getName().equals(configurationName)) {
                consoleConfiguration = configurations[i];
                break;
            }
            ++i;
        }
        if (consoleConfiguration != null) {
            try {
                SessionFactory sessionFactory = consoleConfiguration.getSessionFactory();
                if (sessionFactory == null) {
                    consoleConfiguration.build();
                    consoleConfiguration.buildSessionFactory();
                    sessionFactory = consoleConfiguration.getSessionFactory();
                }
                MessageDialog.openInformation((Shell)this.getShell(), (String)title, (String)Messages.HibernateSelectionPageHelper_Connection_successfull);
            }
            catch (HibernateException e) {
                String message = e.getLocalizedMessage();
                Status status = new Status(4, "org.jboss.tools.birt.oda.ui", message, (Throwable)e);
                Activator.getDefault().getLog().log((IStatus)status);
                ErrorDialog.openError((Shell)this.getShell(), (String)title, (String)message, (IStatus)status);
            }
        } else {
            MessageDialog.openConfirm((Shell)this.getShell(), (String)title, (String)NLS.bind((String)Messages.HibernateSelectionPageHelper_Invalid_configuration, (Object)configurationName));
        }
    }

    private Shell getShell() {
        if (this.wizardPage != null) {
            return this.wizardPage.getShell();
        }
        if (this.propertyPage != null) {
            return this.propertyPage.getShell();
        }
        return null;
    }

    public String getConfiguration() {
        return this.configurationCombo.getText();
    }

    public String getMaxRows() {
        return this.maxRows.getText();
    }

    Properties collectCustomProperties(Properties props) {
        if (props == null) {
            props = new Properties();
        }
        props.setProperty("configuration", this.getConfiguration());
        props.setProperty("maxRows", this.getMaxRows());
        return props;
    }

    private void setPageComplete(boolean complete) {
        if (this.wizardPage != null) {
            this.wizardPage.setPageComplete(complete);
        } else if (this.propertyPage != null) {
            this.propertyPage.setValid(complete);
        }
    }
}

